/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.batik.bridge.BatikWrapFactory;
import org.apache.batik.bridge.EventTargetWrapper;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.RhinoInterpreterFactory;
import org.apache.batik.bridge.Window;
import org.apache.batik.bridge.WindowWrapper;
import org.apache.batik.script.ImportInfo;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.rhino.BatikSecurityController;
import org.apache.batik.script.rhino.RhinoClassLoader;
import org.apache.batik.script.rhino.RhinoClassShutter;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.EventTarget;

public class RhinoInterpreter
implements Interpreter {
    private static final int MAX_CACHED_SCRIPTS = 32;
    public static final String SOURCE_NAME_SVG = "<SVG>";
    public static final String BIND_NAME_WINDOW = "window";
    protected static List contexts = new LinkedList();
    protected Window window;
    protected ScriptableObject globalObject = null;
    protected LinkedList compiledScripts = new LinkedList();
    protected WrapFactory wrapFactory = new BatikWrapFactory(this);
    protected ClassShutter classShutter = new RhinoClassShutter();
    protected RhinoClassLoader rhinoClassLoader;
    protected SecurityController securityController = new BatikSecurityController();
    protected ContextFactory contextFactory = new Factory();
    protected Context defaultContext;

    public RhinoInterpreter(URL uRL) {
        this.init(uRL, null);
    }

    public RhinoInterpreter(URL uRL, ImportInfo importInfo) {
        this.init(uRL, importInfo);
    }

    protected void init(URL uRL, final ImportInfo importInfo) {
        try {
            this.rhinoClassLoader = new RhinoClassLoader(uRL, this.getClass().getClassLoader());
        }
        catch (SecurityException securityException) {
            this.rhinoClassLoader = null;
        }
        ContextAction contextAction = new ContextAction(){

            public Object run(Context context) {
                String string;
                ScriptableObject scriptableObject = context.initStandardObjects(null, false);
                RhinoInterpreter.this.defineGlobalWrapperClass((Scriptable)scriptableObject);
                RhinoInterpreter.this.globalObject = RhinoInterpreter.this.createGlobalObject(context);
                ClassCache classCache = ClassCache.get((Scriptable)RhinoInterpreter.this.globalObject);
                classCache.setCachingEnabled(RhinoInterpreter.this.rhinoClassLoader != null);
                ImportInfo importInfo2 = importInfo;
                if (importInfo2 == null) {
                    importInfo2 = ImportInfo.getImports();
                }
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = importInfo2.getPackages();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    stringBuffer.append("importPackage(Packages.");
                    stringBuffer.append(string);
                    stringBuffer.append(");");
                }
                iterator = importInfo2.getClasses();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    stringBuffer.append("importClass(Packages.");
                    stringBuffer.append(string);
                    stringBuffer.append(");");
                }
                context.evaluateString((Scriptable)RhinoInterpreter.this.globalObject, stringBuffer.toString(), null, 0, (Object)RhinoInterpreter.this.rhinoClassLoader);
                return null;
            }
        };
        this.contextFactory.call(contextAction);
    }

    @Override
    public String[] getMimeTypes() {
        return RhinoInterpreterFactory.RHINO_MIMETYPES;
    }

    public Window getWindow() {
        return this.window;
    }

    public ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    protected void defineGlobalWrapperClass(Scriptable scriptable) {
        try {
            ScriptableObject.defineClass((Scriptable)scriptable, WindowWrapper.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ScriptableObject createGlobalObject(Context context) {
        return new WindowWrapper(context);
    }

    public AccessControlContext getAccessControlContext() {
        if (this.rhinoClassLoader == null) {
            return null;
        }
        return this.rhinoClassLoader.getAccessControlContext();
    }

    protected ScriptableObject getGlobalObject() {
        return this.globalObject;
    }

    @Override
    public Object evaluate(Reader reader) {
        return this.evaluate(reader, SOURCE_NAME_SVG);
    }

    @Override
    public Object evaluate(final Reader reader, final String string) {
        ContextAction contextAction = new ContextAction(){

            public Object run(Context context) {
                try {
                    return context.evaluateReader((Scriptable)RhinoInterpreter.this.globalObject, reader, string, 1, (Object)RhinoInterpreter.this.rhinoClassLoader);
                }
                catch (IOException iOException) {
                    throw new WrappedException((Throwable)iOException);
                }
            }
        };
        try {
            return this.contextFactory.call(contextAction);
        }
        catch (JavaScriptException javaScriptException) {
            Object object = javaScriptException.getValue();
            Throwable throwable = object instanceof Exception ? (Exception)object : javaScriptException;
            throw new InterpreterException((Exception)throwable, throwable.getMessage(), -1, -1);
        }
        catch (WrappedException wrappedException) {
            Throwable throwable = wrappedException.getWrappedException();
            if (throwable instanceof Exception) {
                throw new InterpreterException((Exception)throwable, throwable.getMessage(), -1, -1);
            }
            throw new InterpreterException(throwable.getMessage(), -1, -1);
        }
        catch (InterruptedBridgeException interruptedBridgeException) {
            throw interruptedBridgeException;
        }
        catch (RuntimeException runtimeException) {
            throw new InterpreterException(runtimeException, runtimeException.getMessage(), -1, -1);
        }
    }

    @Override
    public Object evaluate(final String string) {
        ContextAction contextAction = new ContextAction(){

            public Object run(final Context context) {
                Script script = null;
                Entry entry = null;
                Iterator iterator = RhinoInterpreter.this.compiledScripts.iterator();
                while (iterator.hasNext()) {
                    entry = (Entry)iterator.next();
                    if (!entry.str.equals(string)) continue;
                    script = entry.script;
                    iterator.remove();
                    break;
                }
                if (script == null) {
                    PrivilegedAction privilegedAction = new PrivilegedAction(){

                        public Object run() {
                            try {
                                return context.compileReader((Reader)new StringReader(string), RhinoInterpreter.SOURCE_NAME_SVG, 1, (Object)RhinoInterpreter.this.rhinoClassLoader);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException.getMessage());
                            }
                        }
                    };
                    script = (Script)AccessController.doPrivileged(privilegedAction);
                    if (RhinoInterpreter.this.compiledScripts.size() + 1 > 32) {
                        RhinoInterpreter.this.compiledScripts.removeFirst();
                    }
                    RhinoInterpreter.this.compiledScripts.addLast(new Entry(string, script));
                } else {
                    RhinoInterpreter.this.compiledScripts.addLast(entry);
                }
                return script.exec(context, (Scriptable)RhinoInterpreter.this.globalObject);
            }
        };
        try {
            return this.contextFactory.call(contextAction);
        }
        catch (InterpreterException interpreterException) {
            throw interpreterException;
        }
        catch (JavaScriptException javaScriptException) {
            Object object = javaScriptException.getValue();
            Throwable throwable = object instanceof Exception ? (Exception)object : javaScriptException;
            throw new InterpreterException((Exception)throwable, throwable.getMessage(), -1, -1);
        }
        catch (WrappedException wrappedException) {
            Throwable throwable = wrappedException.getWrappedException();
            if (throwable instanceof Exception) {
                throw new InterpreterException((Exception)throwable, throwable.getMessage(), -1, -1);
            }
            throw new InterpreterException(throwable.getMessage(), -1, -1);
        }
        catch (RuntimeException runtimeException) {
            throw new InterpreterException(runtimeException, runtimeException.getMessage(), -1, -1);
        }
    }

    @Override
    public void dispose() {
        if (this.rhinoClassLoader != null) {
            ClassCache classCache = ClassCache.get((Scriptable)this.globalObject);
            classCache.setCachingEnabled(false);
        }
    }

    @Override
    public void bindObject(final String string, final Object object) {
        this.contextFactory.call(new ContextAction(){

            public Object run(Context context) {
                Object object2 = object;
                if (string.equals(RhinoInterpreter.BIND_NAME_WINDOW) && object instanceof Window) {
                    ((WindowWrapper)RhinoInterpreter.this.globalObject).window = (Window)object;
                    RhinoInterpreter.this.window = (Window)object;
                    object2 = RhinoInterpreter.this.globalObject;
                }
                Scriptable scriptable = Context.toObject((Object)object2, (Scriptable)RhinoInterpreter.this.globalObject);
                RhinoInterpreter.this.globalObject.put(string, (Scriptable)RhinoInterpreter.this.globalObject, (Object)scriptable);
                return null;
            }
        });
    }

    void callHandler(final Function function, final Object object) {
        this.contextFactory.call(new ContextAction(){

            public Object run(Context context) {
                Scriptable scriptable = Context.toObject((Object)object, (Scriptable)RhinoInterpreter.this.globalObject);
                Object[] objectArray = new Object[]{scriptable};
                function.call(context, (Scriptable)RhinoInterpreter.this.globalObject, (Scriptable)RhinoInterpreter.this.globalObject, objectArray);
                return null;
            }
        });
    }

    void callMethod(final ScriptableObject scriptableObject, final String string, final ArgumentsBuilder argumentsBuilder) {
        this.contextFactory.call(new ContextAction(){

            public Object run(Context context) {
                ScriptableObject.callMethod((Scriptable)scriptableObject, (String)string, (Object[])argumentsBuilder.buildArguments());
                return null;
            }
        });
    }

    void callHandler(final Function function, final Object[] objectArray) {
        this.contextFactory.call(new ContextAction(){

            public Object run(Context context) {
                function.call(context, (Scriptable)RhinoInterpreter.this.globalObject, (Scriptable)RhinoInterpreter.this.globalObject, objectArray);
                return null;
            }
        });
    }

    void callHandler(final Function function, final ArgumentsBuilder argumentsBuilder) {
        this.contextFactory.call(new ContextAction(){

            public Object run(Context context) {
                Object[] objectArray = argumentsBuilder.buildArguments();
                function.call(context, function.getParentScope(), (Scriptable)RhinoInterpreter.this.globalObject, objectArray);
                return null;
            }
        });
    }

    Object call(ContextAction contextAction) {
        return this.contextFactory.call(contextAction);
    }

    Scriptable buildEventTargetWrapper(EventTarget eventTarget) {
        return new EventTargetWrapper((Scriptable)this.globalObject, eventTarget, this);
    }

    @Override
    public void setOut(Writer writer) {
    }

    @Override
    public Locale getLocale() {
        return null;
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public String formatMessage(String string, Object[] objectArray) {
        return null;
    }

    protected class Factory
    extends ContextFactory {
        protected Factory() {
        }

        protected Context makeContext() {
            Context context = super.makeContext();
            context.setWrapFactory(RhinoInterpreter.this.wrapFactory);
            context.setSecurityController(RhinoInterpreter.this.securityController);
            context.setClassShutter(RhinoInterpreter.this.classShutter);
            if (RhinoInterpreter.this.rhinoClassLoader == null) {
                context.setOptimizationLevel(-1);
            }
            return context;
        }
    }

    protected static class Entry {
        public String str;
        public Script script;

        public Entry(String string, Script script) {
            this.str = string;
            this.script = script;
        }
    }

    public static interface ArgumentsBuilder {
        public Object[] buildArguments();
    }
}

