/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.batik.ext.awt.geom.RectListManager;
import org.apache.batik.gvt.renderer.ImageRenderer;

public class RepaintManager {
    static final int COPY_OVERHEAD = 10000;
    static final int COPY_LINE_OVERHEAD = 10;
    protected ImageRenderer renderer;

    public RepaintManager(ImageRenderer imageRenderer) {
        this.renderer = imageRenderer;
    }

    public Collection updateRendering(Collection collection) {
        this.renderer.flush(collection);
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(collection.size());
        AffineTransform affineTransform = this.renderer.getTransform();
        for (Object e2 : collection) {
            Shape shape = (Shape)e2;
            shape = affineTransform.createTransformedShape(shape);
            Rectangle2D rectangle2D = shape.getBounds2D();
            int n2 = (int)Math.floor(rectangle2D.getX());
            int n3 = (int)Math.floor(rectangle2D.getY());
            int n4 = (int)Math.ceil(rectangle2D.getX() + rectangle2D.getWidth());
            int n5 = (int)Math.ceil(rectangle2D.getY() + rectangle2D.getHeight());
            Rectangle rectangle = new Rectangle(n2 - 1, n3 - 1, n4 - n2 + 3, n5 - n3 + 3);
            arrayList.add(rectangle);
        }
        Object object = null;
        try {
            object = new RectListManager(arrayList);
            ((RectListManager)object).mergeRects(10000, 10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.renderer.repaint((RectListManager)object);
        return object;
    }

    public void setupRenderer(AffineTransform affineTransform, boolean bl2, Shape shape, int n2, int n3) {
        this.renderer.setTransform(affineTransform);
        this.renderer.setDoubleBuffered(bl2);
        this.renderer.updateOffScreen(n2, n3);
        this.renderer.clearOffScreen();
    }

    public BufferedImage getOffScreen() {
        return this.renderer.getOffScreen();
    }
}

