/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.CSSFontFace;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;

public final class DefaultFontFamilyResolver
implements FontFamilyResolver {
    public static final DefaultFontFamilyResolver SINGLETON;
    private static final AWTFontFamily DEFAULT_FONT_FAMILY;
    protected static final Map fonts;
    protected static final List awtFontFamilies;
    protected static final List awtFonts;
    protected static final Map resolvedFontFamilies;

    private DefaultFontFamilyResolver() {
    }

    @Override
    public AWTFontFamily resolve(String string, FontFace fontFace) {
        String string2 = (String)fonts.get(fontFace.getFamilyName().toLowerCase());
        if (string2 == null) {
            return null;
        }
        CSSFontFace cSSFontFace = FontFace.createFontFace(string2, fontFace);
        return new AWTFontFamily(fontFace);
    }

    @Override
    public GVTFontFamily loadFont(InputStream inputStream, FontFace fontFace) {
        Font font = Font.createFont(0, inputStream);
        return new AWTFontFamily(fontFace, font);
    }

    @Override
    public GVTFontFamily resolve(String string) {
        GVTFontFamily gVTFontFamily = (GVTFontFamily)resolvedFontFamilies.get(string = string.toLowerCase());
        if (gVTFontFamily == null) {
            String string2 = (String)fonts.get(string);
            if (string2 != null) {
                gVTFontFamily = new AWTFontFamily(string2);
            }
            resolvedFontFamilies.put(string, gVTFontFamily);
        }
        return gVTFontFamily;
    }

    @Override
    public GVTFontFamily getFamilyThatCanDisplay(char c2) {
        for (int i2 = 0; i2 < awtFontFamilies.size(); ++i2) {
            AWTFontFamily aWTFontFamily = (AWTFontFamily)awtFontFamilies.get(i2);
            AWTGVTFont aWTGVTFont = (AWTGVTFont)awtFonts.get(i2);
            if (!aWTGVTFont.canDisplay(c2) || aWTFontFamily.getFamilyName().indexOf("Song") != -1) continue;
            return aWTFontFamily;
        }
        return null;
    }

    @Override
    public GVTFontFamily getDefault() {
        return DEFAULT_FONT_FAMILY;
    }

    static {
        Object object;
        SINGLETON = new DefaultFontFamilyResolver();
        DEFAULT_FONT_FAMILY = new AWTFontFamily("SansSerif");
        fonts = new HashMap();
        awtFontFamilies = new ArrayList();
        awtFonts = new ArrayList();
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n2 = stringArray != null ? stringArray.length : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            fonts.put(stringArray[i2].toLowerCase(), stringArray[i2]);
            object = new StringTokenizer(stringArray[i2]);
            String string = "";
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = string + ((StringTokenizer)object).nextToken();
            }
            fonts.put(string.toLowerCase(), stringArray[i2]);
            String string2 = stringArray[i2].replace(' ', '-');
            if (string2.equals(stringArray[i2])) continue;
            fonts.put(string2.toLowerCase(), stringArray[i2]);
        }
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        for (Font object2 : fontArray) {
            fonts.put(object2.getFontName().toLowerCase(), object2.getFontName());
        }
        awtFontFamilies.add(DEFAULT_FONT_FAMILY);
        awtFonts.add(new AWTGVTFont(DEFAULT_FONT_FAMILY.getFamilyName(), 0, 12));
        object = fonts.values();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            String string = (String)e2;
            AWTFontFamily aWTFontFamily = new AWTFontFamily(string);
            awtFontFamilies.add(aWTFontFamily);
            AWTGVTFont aWTGVTFont = new AWTGVTFont(string, 0, 12);
            awtFonts.add(aWTGVTFont);
        }
        resolvedFontFamilies = new HashMap();
    }
}

