/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.FocusManager;
import org.apache.batik.bridge.StrokingTextPainter;
import org.apache.batik.bridge.TextHit;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextSpanLayout;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.DOMKeyEvent;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class BridgeEventSupport
implements SVGConstants {
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;

    protected BridgeEventSupport() {
    }

    public static void addGVTListener(BridgeContext bridgeContext, Document document) {
        EventDispatcher eventDispatcher;
        UserAgent userAgent = bridgeContext.getUserAgent();
        if (userAgent != null && (eventDispatcher = userAgent.getEventDispatcher()) != null) {
            Listener listener = new Listener(bridgeContext, userAgent);
            eventDispatcher.addGraphicsNodeMouseListener(listener);
            eventDispatcher.addGraphicsNodeKeyListener(listener);
            GVTUnloadListener gVTUnloadListener = new GVTUnloadListener(eventDispatcher, listener);
            NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)document);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGUnload", gVTUnloadListener, false, null);
            BridgeEventSupport.storeEventListenerNS(bridgeContext, nodeEventTarget, "http://www.w3.org/2001/xml-events", "SVGUnload", gVTUnloadListener, false);
        }
    }

    protected static void storeEventListener(BridgeContext bridgeContext, EventTarget eventTarget, String string, EventListener eventListener, boolean bl2) {
        bridgeContext.storeEventListener(eventTarget, string, eventListener, bl2);
    }

    protected static void storeEventListenerNS(BridgeContext bridgeContext, EventTarget eventTarget, String string, String string2, EventListener eventListener, boolean bl2) {
        bridgeContext.storeEventListenerNS(eventTarget, string, string2, eventListener, bl2);
    }

    protected static class Listener
    implements GraphicsNodeKeyListener,
    GraphicsNodeMouseListener {
        protected BridgeContext context;
        protected UserAgent ua;
        protected Element lastTargetElement;
        protected boolean isDown;

        public Listener(BridgeContext bridgeContext, UserAgent userAgent) {
            this.context = bridgeContext;
            this.ua = userAgent;
        }

        @Override
        public void keyPressed(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
            if (!this.isDown) {
                this.isDown = true;
                this.dispatchKeyEvent("keydown", graphicsNodeKeyEvent);
            }
            if (graphicsNodeKeyEvent.getKeyChar() == '\uffff') {
                this.dispatchKeyEvent("keypress", graphicsNodeKeyEvent);
            }
        }

        @Override
        public void keyReleased(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
            this.dispatchKeyEvent("keyup", graphicsNodeKeyEvent);
            this.isDown = false;
        }

        @Override
        public void keyTyped(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
            this.dispatchKeyEvent("keypress", graphicsNodeKeyEvent);
        }

        protected void dispatchKeyEvent(String string, GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
            FocusManager focusManager = this.context.getFocusManager();
            if (focusManager == null) {
                return;
            }
            Element element = (Element)((Object)focusManager.getCurrentEventTarget());
            if (element == null) {
                element = this.context.getDocument().getDocumentElement();
            }
            DocumentEvent documentEvent = (DocumentEvent)((Object)element.getOwnerDocument());
            DOMKeyEvent dOMKeyEvent = (DOMKeyEvent)documentEvent.createEvent("KeyEvents");
            dOMKeyEvent.initKeyEvent(string, true, true, graphicsNodeKeyEvent.isControlDown(), graphicsNodeKeyEvent.isAltDown(), graphicsNodeKeyEvent.isShiftDown(), graphicsNodeKeyEvent.isMetaDown(), this.mapKeyCode(graphicsNodeKeyEvent.getKeyCode()), graphicsNodeKeyEvent.getKeyChar(), null);
            try {
                ((EventTarget)((Object)element)).dispatchEvent(dOMKeyEvent);
            }
            catch (RuntimeException runtimeException) {
                this.ua.displayError(runtimeException);
            }
        }

        protected final int mapKeyCode(int n2) {
            switch (n2) {
                case 10: {
                    return 13;
                }
                case 262: {
                    return 0;
                }
                case 263: {
                    return 0;
                }
            }
            return n2;
        }

        @Override
        public void mouseClicked(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("click", graphicsNodeMouseEvent, true);
        }

        @Override
        public void mousePressed(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mousedown", graphicsNodeMouseEvent, true);
        }

        @Override
        public void mouseReleased(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseup", graphicsNodeMouseEvent, true);
        }

        @Override
        public void mouseEntered(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            Point point = graphicsNodeMouseEvent.getClientPoint();
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getGraphicsNode();
            Element element = this.getEventTarget(graphicsNode, graphicsNodeMouseEvent.getPoint2D());
            Element element2 = this.getRelatedElement(graphicsNodeMouseEvent);
            this.dispatchMouseEvent("mouseover", element, element2, point, graphicsNodeMouseEvent, true);
        }

        @Override
        public void mouseExited(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            Point point = graphicsNodeMouseEvent.getClientPoint();
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getRelatedNode();
            Element element = this.getEventTarget(graphicsNode, graphicsNodeMouseEvent.getPoint2D());
            if (this.lastTargetElement != null) {
                this.dispatchMouseEvent("mouseout", this.lastTargetElement, element, point, graphicsNodeMouseEvent, true);
                this.lastTargetElement = null;
            }
        }

        @Override
        public void mouseDragged(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mousemove", graphicsNodeMouseEvent, false);
        }

        @Override
        public void mouseMoved(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            Point point = graphicsNodeMouseEvent.getClientPoint();
            Element element = this.lastTargetElement;
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getGraphicsNode();
            Element element2 = this.getEventTarget(graphicsNode, graphicsNodeMouseEvent.getPoint2D());
            if (element != element2) {
                if (element != null) {
                    this.dispatchMouseEvent("mouseout", element, element2, point, graphicsNodeMouseEvent, true);
                }
                if (element2 != null) {
                    this.dispatchMouseEvent("mouseover", element2, element, point, graphicsNodeMouseEvent, true);
                }
            }
            this.dispatchMouseEvent("mousemove", element2, null, point, graphicsNodeMouseEvent, false);
        }

        protected void dispatchMouseEvent(String string, GraphicsNodeMouseEvent graphicsNodeMouseEvent, boolean bl2) {
            Point point = graphicsNodeMouseEvent.getClientPoint();
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getGraphicsNode();
            Element element = this.getEventTarget(graphicsNode, graphicsNodeMouseEvent.getPoint2D());
            Element element2 = this.getRelatedElement(graphicsNodeMouseEvent);
            this.dispatchMouseEvent(string, element, element2, point, graphicsNodeMouseEvent, bl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchMouseEvent(String string, Element element, Element element2, Point point, GraphicsNodeMouseEvent graphicsNodeMouseEvent, boolean bl2) {
            if (element == null) {
                return;
            }
            Point point2 = graphicsNodeMouseEvent.getScreenPoint();
            DocumentEvent documentEvent = (DocumentEvent)((Object)element.getOwnerDocument());
            DOMMouseEvent dOMMouseEvent = (DOMMouseEvent)documentEvent.createEvent("MouseEvents");
            String string2 = DOMUtilities.getModifiersList(graphicsNodeMouseEvent.getLockState(), graphicsNodeMouseEvent.getModifiers());
            dOMMouseEvent.initMouseEventNS("http://www.w3.org/2001/xml-events", string, true, bl2, null, graphicsNodeMouseEvent.getClickCount(), point2.x, point2.y, point.x, point.y, (short)(graphicsNodeMouseEvent.getButton() - 1), (EventTarget)((Object)element2), string2);
            try {
                ((EventTarget)((Object)element)).dispatchEvent(dOMMouseEvent);
            }
            catch (RuntimeException runtimeException) {
                this.ua.displayError(runtimeException);
            }
            finally {
                this.lastTargetElement = element;
            }
        }

        protected Element getRelatedElement(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getRelatedNode();
            Element element = null;
            if (graphicsNode != null) {
                element = this.context.getElement(graphicsNode);
            }
            return element;
        }

        protected Element getEventTarget(GraphicsNode graphicsNode, Point2D point2D) {
            TextNode textNode;
            List list;
            Element element = this.context.getElement(graphicsNode);
            if (element != null && graphicsNode instanceof TextNode && (list = (textNode = (TextNode)graphicsNode).getTextRuns()) != null) {
                float f2 = (float)point2D.getX();
                float f3 = (float)point2D.getY();
                for (Object e2 : list) {
                    SoftReference softReference;
                    Object t2;
                    StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)e2;
                    AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
                    TextSpanLayout textSpanLayout = textRun.getLayout();
                    TextHit textHit = textSpanLayout.hitTestChar(f2, f3);
                    Rectangle2D rectangle2D = textSpanLayout.getBounds2D();
                    if (textHit == null || rectangle2D == null || !rectangle2D.contains(f2, f3) || !((t2 = (softReference = (SoftReference)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_ID)).get()) instanceof Element)) continue;
                    return (Element)t2;
                }
            }
            return element;
        }
    }

    protected static class GVTUnloadListener
    implements EventListener {
        protected EventDispatcher dispatcher;
        protected Listener listener;

        public GVTUnloadListener(EventDispatcher eventDispatcher, Listener listener) {
            this.dispatcher = eventDispatcher;
            this.listener = listener;
        }

        @Override
        public void handleEvent(Event event) {
            this.dispatcher.removeGraphicsNodeMouseListener(this.listener);
            this.dispatcher.removeGraphicsNodeKeyListener(this.listener);
            NodeEventTarget nodeEventTarget = (NodeEventTarget)event.getTarget();
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGUnload", this, false);
        }
    }
}

