/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import java.util.Arrays;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatablePathDataValue
extends AnimatableValue {
    protected short[] commands;
    protected float[] parameters;
    protected static final char[] PATH_COMMANDS = new char[]{' ', 'z', 'M', 'm', 'L', 'l', 'C', 'c', 'Q', 'q', 'A', 'a', 'H', 'h', 'V', 'v', 'S', 's', 'T', 't'};
    protected static final int[] PATH_PARAMS = new int[]{0, 0, 2, 2, 2, 2, 6, 6, 4, 4, 7, 7, 1, 1, 1, 1, 4, 4, 2, 2};

    protected AnimatablePathDataValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatablePathDataValue(AnimationTarget animationTarget, short[] sArray, float[] fArray) {
        super(animationTarget);
        this.commands = sArray;
        this.parameters = fArray;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        AnimatablePathDataValue animatablePathDataValue;
        AnimatablePathDataValue animatablePathDataValue2 = (AnimatablePathDataValue)animatableValue2;
        AnimatablePathDataValue animatablePathDataValue3 = (AnimatablePathDataValue)animatableValue3;
        boolean bl2 = animatableValue2 != null;
        boolean bl3 = animatableValue3 != null;
        boolean bl4 = bl2 && animatablePathDataValue2.parameters.length == this.parameters.length && Arrays.equals(animatablePathDataValue2.commands, this.commands);
        boolean bl5 = bl3 && animatablePathDataValue3.parameters.length == this.parameters.length && Arrays.equals(animatablePathDataValue3.commands, this.commands);
        AnimatablePathDataValue animatablePathDataValue4 = !bl4 && bl2 && (double)f2 >= 0.5 ? animatablePathDataValue2 : this;
        int n3 = animatablePathDataValue4.commands.length;
        int n4 = animatablePathDataValue4.parameters.length;
        if (animatableValue == null) {
            animatablePathDataValue = new AnimatablePathDataValue(this.target);
            animatablePathDataValue.commands = new short[n3];
            animatablePathDataValue.parameters = new float[n4];
            System.arraycopy(animatablePathDataValue4.commands, 0, animatablePathDataValue.commands, 0, n3);
        } else {
            animatablePathDataValue = (AnimatablePathDataValue)animatableValue;
            if (animatablePathDataValue.commands == null || animatablePathDataValue.commands.length != n3) {
                animatablePathDataValue.commands = new short[n3];
                System.arraycopy(animatablePathDataValue4.commands, 0, animatablePathDataValue.commands, 0, n3);
                animatablePathDataValue.hasChanged = true;
            } else if (!Arrays.equals(animatablePathDataValue4.commands, animatablePathDataValue.commands)) {
                System.arraycopy(animatablePathDataValue4.commands, 0, animatablePathDataValue.commands, 0, n3);
                animatablePathDataValue.hasChanged = true;
            }
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            float f3 = animatablePathDataValue4.parameters[i2];
            if (bl4) {
                f3 += f2 * (animatablePathDataValue2.parameters[i2] - f3);
            }
            if (bl5) {
                f3 += (float)n2 * animatablePathDataValue3.parameters[i2];
            }
            if (animatablePathDataValue.parameters[i2] == f3) continue;
            animatablePathDataValue.parameters[i2] = f3;
            animatablePathDataValue.hasChanged = true;
        }
        return animatablePathDataValue;
    }

    public short[] getCommands() {
        return this.commands;
    }

    public float[] getParameters() {
        return this.parameters;
    }

    @Override
    public boolean canPace() {
        return false;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        return 0.0f;
    }

    @Override
    public AnimatableValue getZeroValue() {
        short[] sArray = new short[this.commands.length];
        System.arraycopy(this.commands, 0, sArray, 0, this.commands.length);
        float[] fArray = new float[this.parameters.length];
        return new AnimatablePathDataValue(this.target, sArray, fArray);
    }

    @Override
    public String toStringRep() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (short s2 : this.commands) {
            stringBuffer.append(PATH_COMMANDS[s2]);
            for (int i2 = 0; i2 < PATH_PARAMS[s2]; ++i2) {
                stringBuffer.append(' ');
                stringBuffer.append(this.parameters[n2++]);
            }
        }
        return stringBuffer.toString();
    }
}

