/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableLengthValue
extends AnimatableValue {
    protected static final String[] UNITS = new String[]{"", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc"};
    protected short lengthType;
    protected float lengthValue;
    protected short percentageInterpretation;

    protected AnimatableLengthValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableLengthValue(AnimationTarget animationTarget, short s2, float f2, short s3) {
        super(animationTarget);
        this.lengthType = s2;
        this.lengthValue = f2;
        this.percentageInterpretation = s3;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        float f3;
        AnimatableLengthValue animatableLengthValue;
        AnimatableLengthValue animatableLengthValue2 = animatableValue == null ? new AnimatableLengthValue(this.target) : (AnimatableLengthValue)animatableValue;
        short s2 = animatableLengthValue2.lengthType;
        float f4 = animatableLengthValue2.lengthValue;
        short s3 = animatableLengthValue2.percentageInterpretation;
        animatableLengthValue2.lengthType = this.lengthType;
        animatableLengthValue2.lengthValue = this.lengthValue;
        animatableLengthValue2.percentageInterpretation = this.percentageInterpretation;
        if (animatableValue2 != null) {
            animatableLengthValue = (AnimatableLengthValue)animatableValue2;
            if (!AnimatableLengthValue.compatibleTypes(animatableLengthValue2.lengthType, animatableLengthValue2.percentageInterpretation, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation)) {
                animatableLengthValue2.lengthValue = this.target.svgToUserSpace(animatableLengthValue2.lengthValue, animatableLengthValue2.lengthType, animatableLengthValue2.percentageInterpretation);
                animatableLengthValue2.lengthType = 1;
                f3 = animatableLengthValue.target.svgToUserSpace(animatableLengthValue.lengthValue, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation);
            } else {
                f3 = animatableLengthValue.lengthValue;
            }
            animatableLengthValue2.lengthValue += f2 * (f3 - animatableLengthValue2.lengthValue);
        }
        if (animatableValue3 != null) {
            animatableLengthValue = (AnimatableLengthValue)animatableValue3;
            if (!AnimatableLengthValue.compatibleTypes(animatableLengthValue2.lengthType, animatableLengthValue2.percentageInterpretation, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation)) {
                animatableLengthValue2.lengthValue = this.target.svgToUserSpace(animatableLengthValue2.lengthValue, animatableLengthValue2.lengthType, animatableLengthValue2.percentageInterpretation);
                animatableLengthValue2.lengthType = 1;
                f3 = animatableLengthValue.target.svgToUserSpace(animatableLengthValue.lengthValue, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation);
            } else {
                f3 = animatableLengthValue.lengthValue;
            }
            animatableLengthValue2.lengthValue += (float)n2 * f3;
        }
        if (s3 != animatableLengthValue2.percentageInterpretation || s2 != animatableLengthValue2.lengthType || f4 != animatableLengthValue2.lengthValue) {
            animatableLengthValue2.hasChanged = true;
        }
        return animatableLengthValue2;
    }

    public static boolean compatibleTypes(short s2, short s3, short s4, short s5) {
        return s2 == s4 && (s2 != 2 || s3 == s5) || s2 == 1 && s4 == 5 || s2 == 5 && s4 == 1;
    }

    public int getLengthType() {
        return this.lengthType;
    }

    public float getLengthValue() {
        return this.lengthValue;
    }

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableLengthValue animatableLengthValue = (AnimatableLengthValue)animatableValue;
        float f2 = this.target.svgToUserSpace(this.lengthValue, this.lengthType, this.percentageInterpretation);
        float f3 = this.target.svgToUserSpace(animatableLengthValue.lengthValue, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation);
        return Math.abs(f2 - f3);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableLengthValue(this.target, 1, 0.0f, this.percentageInterpretation);
    }

    @Override
    public String getCssText() {
        return AnimatableLengthValue.formatNumber(this.lengthValue) + UNITS[this.lengthType - 1];
    }
}

