/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableLengthListValue
extends AnimatableValue {
    protected short[] lengthTypes;
    protected float[] lengthValues;
    protected short percentageInterpretation;

    protected AnimatableLengthListValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableLengthListValue(AnimationTarget animationTarget, short[] sArray, float[] fArray, short s2) {
        super(animationTarget);
        this.lengthTypes = sArray;
        this.lengthValues = fArray;
        this.percentageInterpretation = s2;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        AnimatableLengthListValue animatableLengthListValue;
        float[] fArray;
        short[] sArray;
        boolean bl2;
        AnimatableLengthListValue animatableLengthListValue2 = (AnimatableLengthListValue)animatableValue2;
        AnimatableLengthListValue animatableLengthListValue3 = (AnimatableLengthListValue)animatableValue3;
        boolean bl3 = animatableValue2 != null;
        boolean bl4 = animatableValue3 != null;
        boolean bl5 = bl2 = !(bl3 && animatableLengthListValue2.lengthTypes.length != this.lengthTypes.length || bl4 && animatableLengthListValue3.lengthTypes.length != this.lengthTypes.length);
        if (!bl2 && bl3 && (double)f2 >= 0.5) {
            sArray = animatableLengthListValue2.lengthTypes;
            fArray = animatableLengthListValue2.lengthValues;
        } else {
            sArray = this.lengthTypes;
            fArray = this.lengthValues;
        }
        int n3 = sArray.length;
        if (animatableValue == null) {
            animatableLengthListValue = new AnimatableLengthListValue(this.target);
            animatableLengthListValue.lengthTypes = new short[n3];
            animatableLengthListValue.lengthValues = new float[n3];
        } else {
            animatableLengthListValue = (AnimatableLengthListValue)animatableValue;
            if (animatableLengthListValue.lengthTypes == null || animatableLengthListValue.lengthTypes.length != n3) {
                animatableLengthListValue.lengthTypes = new short[n3];
                animatableLengthListValue.lengthValues = new float[n3];
            }
        }
        animatableLengthListValue.hasChanged = this.percentageInterpretation != animatableLengthListValue.percentageInterpretation;
        animatableLengthListValue.percentageInterpretation = this.percentageInterpretation;
        for (int i2 = 0; i2 < n3; ++i2) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            short s2 = sArray[i2];
            float f5 = fArray[i2];
            if (bl2) {
                if (bl3 && !AnimatableLengthValue.compatibleTypes(s2, this.percentageInterpretation, animatableLengthListValue2.lengthTypes[i2], animatableLengthListValue2.percentageInterpretation) || bl4 && !AnimatableLengthValue.compatibleTypes(s2, this.percentageInterpretation, animatableLengthListValue3.lengthTypes[i2], animatableLengthListValue3.percentageInterpretation)) {
                    f5 = this.target.svgToUserSpace(f5, s2, this.percentageInterpretation);
                    s2 = 1;
                    if (bl3) {
                        f3 = animatableValue2.target.svgToUserSpace(animatableLengthListValue2.lengthValues[i2], animatableLengthListValue2.lengthTypes[i2], animatableLengthListValue2.percentageInterpretation);
                    }
                    if (bl4) {
                        f4 = animatableValue3.target.svgToUserSpace(animatableLengthListValue3.lengthValues[i2], animatableLengthListValue3.lengthTypes[i2], animatableLengthListValue3.percentageInterpretation);
                    }
                } else {
                    if (bl3) {
                        f3 = animatableLengthListValue2.lengthValues[i2];
                    }
                    if (bl4) {
                        f4 = animatableLengthListValue3.lengthValues[i2];
                    }
                }
                f5 += f2 * (f3 - f5) + (float)n2 * f4;
            }
            if (!animatableLengthListValue.hasChanged) {
                animatableLengthListValue.hasChanged = s2 != animatableLengthListValue.lengthTypes[i2] || f5 != animatableLengthListValue.lengthValues[i2];
            }
            animatableLengthListValue.lengthTypes[i2] = s2;
            animatableLengthListValue.lengthValues[i2] = f5;
        }
        return animatableLengthListValue;
    }

    public short[] getLengthTypes() {
        return this.lengthTypes;
    }

    public float[] getLengthValues() {
        return this.lengthValues;
    }

    @Override
    public boolean canPace() {
        return false;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        return 0.0f;
    }

    @Override
    public AnimatableValue getZeroValue() {
        float[] fArray = new float[this.lengthValues.length];
        return new AnimatableLengthListValue(this.target, this.lengthTypes, fArray, this.percentageInterpretation);
    }

    @Override
    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lengthValues.length > 0) {
            stringBuffer.append(AnimatableLengthListValue.formatNumber(this.lengthValues[0]));
            stringBuffer.append(AnimatableLengthValue.UNITS[this.lengthTypes[0] - 1]);
        }
        for (int i2 = 1; i2 < this.lengthValues.length; ++i2) {
            stringBuffer.append(',');
            stringBuffer.append(AnimatableLengthListValue.formatNumber(this.lengthValues[i2]));
            stringBuffer.append(AnimatableLengthValue.UNITS[this.lengthTypes[i2] - 1]);
        }
        return stringBuffer.toString();
    }
}

