/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.batik.anim.AnimationException;
import org.apache.batik.anim.timing.EventLikeTimingSpecifier;
import org.apache.batik.anim.timing.InstanceTime;
import org.apache.batik.anim.timing.Interval;
import org.apache.batik.anim.timing.TimeContainer;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimingSpecifier;
import org.apache.batik.anim.timing.TimingSpecifierListProducer;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.parser.ClockHandler;
import org.apache.batik.parser.ClockParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.util.SMILConstants;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public abstract class TimedElement
implements SMILConstants {
    public static final int FILL_REMOVE = 0;
    public static final int FILL_FREEZE = 1;
    public static final int RESTART_ALWAYS = 0;
    public static final int RESTART_WHEN_NOT_ACTIVE = 1;
    public static final int RESTART_NEVER = 2;
    public static final float INDEFINITE = Float.POSITIVE_INFINITY;
    public static final float UNRESOLVED = Float.NaN;
    protected TimedDocumentRoot root;
    protected TimeContainer parent;
    protected TimingSpecifier[] beginTimes;
    protected TimingSpecifier[] endTimes;
    protected float simpleDur;
    protected boolean durMedia;
    protected float repeatCount;
    protected float repeatDur;
    protected int currentRepeatIteration;
    protected float lastRepeatTime;
    protected int fillMode;
    protected int restartMode;
    protected float min;
    protected boolean minMedia;
    protected float max;
    protected boolean maxMedia;
    protected boolean isActive;
    protected boolean isFrozen;
    protected float lastSampleTime;
    protected float repeatDuration;
    protected List beginInstanceTimes = new ArrayList();
    protected List endInstanceTimes = new ArrayList();
    protected Interval currentInterval;
    protected float lastIntervalEnd;
    protected Interval previousInterval;
    protected LinkedList beginDependents = new LinkedList();
    protected LinkedList endDependents = new LinkedList();
    protected boolean shouldUpdateCurrentInterval = true;
    protected boolean hasParsed;
    protected Map handledEvents = new HashMap();
    protected boolean isSampling;
    protected boolean hasPropagated;
    protected static final String RESOURCES = "org.apache.batik.anim.resources.Messages";
    protected static LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.anim.resources.Messages", TimedElement.class.getClassLoader());

    public TimedElement() {
        this.beginTimes = new TimingSpecifier[0];
        this.endTimes = this.beginTimes;
        this.simpleDur = Float.NaN;
        this.repeatCount = Float.NaN;
        this.repeatDur = Float.NaN;
        this.lastRepeatTime = Float.NaN;
        this.max = Float.POSITIVE_INFINITY;
        this.lastSampleTime = Float.NaN;
        this.lastIntervalEnd = Float.NEGATIVE_INFINITY;
    }

    public TimedDocumentRoot getRoot() {
        return this.root;
    }

    public float getActiveTime() {
        return this.lastSampleTime;
    }

    public float getSimpleTime() {
        return this.lastSampleTime - this.lastRepeatTime;
    }

    protected float addInstanceTime(InstanceTime instanceTime, boolean bl2) {
        this.hasPropagated = true;
        List list = bl2 ? this.beginInstanceTimes : this.endInstanceTimes;
        int n2 = Collections.binarySearch(list, instanceTime);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        list.add(n2, instanceTime);
        this.shouldUpdateCurrentInterval = true;
        float f2 = this.root.isSampling() && !this.isSampling ? this.sampleAt(this.root.getCurrentTime(), this.root.isHyperlinking()) : Float.POSITIVE_INFINITY;
        this.hasPropagated = false;
        this.root.currentIntervalWillUpdate();
        return f2;
    }

    protected float removeInstanceTime(InstanceTime instanceTime, boolean bl2) {
        int n2;
        int n3;
        this.hasPropagated = true;
        List list = bl2 ? this.beginInstanceTimes : this.endInstanceTimes;
        for (n3 = n2 = Collections.binarySearch(list, instanceTime); n3 >= 0; --n3) {
            InstanceTime instanceTime2 = (InstanceTime)list.get(n3);
            if (instanceTime2 == instanceTime) {
                list.remove(n3);
                break;
            }
            if (instanceTime2.compareTo(instanceTime) != 0) break;
        }
        n3 = list.size();
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            InstanceTime instanceTime3 = (InstanceTime)list.get(i2);
            if (instanceTime3 == instanceTime) {
                list.remove(i2);
                break;
            }
            if (instanceTime3.compareTo(instanceTime) != 0) break;
        }
        this.shouldUpdateCurrentInterval = true;
        float f2 = this.root.isSampling() && !this.isSampling ? this.sampleAt(this.root.getCurrentTime(), this.root.isHyperlinking()) : Float.POSITIVE_INFINITY;
        this.hasPropagated = false;
        this.root.currentIntervalWillUpdate();
        return f2;
    }

    protected float instanceTimeChanged(InstanceTime instanceTime, boolean bl2) {
        this.hasPropagated = true;
        this.shouldUpdateCurrentInterval = true;
        float f2 = this.root.isSampling() && !this.isSampling ? this.sampleAt(this.root.getCurrentTime(), this.root.isHyperlinking()) : Float.POSITIVE_INFINITY;
        this.hasPropagated = false;
        return f2;
    }

    protected void addDependent(TimingSpecifier timingSpecifier, boolean bl2) {
        if (bl2) {
            this.beginDependents.add(timingSpecifier);
        } else {
            this.endDependents.add(timingSpecifier);
        }
    }

    protected void removeDependent(TimingSpecifier timingSpecifier, boolean bl2) {
        if (bl2) {
            this.beginDependents.remove(timingSpecifier);
        } else {
            this.endDependents.remove(timingSpecifier);
        }
    }

    public float getSimpleDur() {
        if (this.durMedia) {
            return this.getImplicitDur();
        }
        if (TimedElement.isUnresolved(this.simpleDur)) {
            if (TimedElement.isUnresolved(this.repeatCount) && TimedElement.isUnresolved(this.repeatDur) && this.endTimes.length > 0) {
                return Float.POSITIVE_INFINITY;
            }
            return this.getImplicitDur();
        }
        return this.simpleDur;
    }

    public static boolean isUnresolved(float f2) {
        return Float.isNaN(f2);
    }

    public float getActiveDur(float f2, float f3) {
        float f4;
        float f5 = this.getSimpleDur();
        if (!TimedElement.isUnresolved(f3) && f5 == Float.POSITIVE_INFINITY) {
            float f6 = this.minusTime(f3, f2);
            this.repeatDuration = this.minTime(this.max, this.maxTime(this.min, f6));
            return this.repeatDuration;
        }
        if (f5 == 0.0f) {
            f4 = 0.0f;
        } else if (TimedElement.isUnresolved(this.repeatDur) && TimedElement.isUnresolved(this.repeatCount)) {
            f4 = f5;
        } else {
            float f7 = TimedElement.isUnresolved(this.repeatCount) ? Float.POSITIVE_INFINITY : this.multiplyTime(f5, this.repeatCount);
            float f8 = TimedElement.isUnresolved(this.repeatDur) ? Float.POSITIVE_INFINITY : this.repeatDur;
            f4 = this.minTime(this.minTime(f7, f8), Float.POSITIVE_INFINITY);
        }
        float f9 = TimedElement.isUnresolved(f3) || f3 == Float.POSITIVE_INFINITY ? f4 : this.minTime(f4, this.minusTime(f3, f2));
        this.repeatDuration = f4;
        return this.minTime(this.max, this.maxTime(this.min, f9));
    }

    protected float minusTime(float f2, float f3) {
        if (TimedElement.isUnresolved(f2) || TimedElement.isUnresolved(f3)) {
            return Float.NaN;
        }
        if (f2 == Float.POSITIVE_INFINITY || f3 == Float.POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        return f2 - f3;
    }

    protected float multiplyTime(float f2, float f3) {
        if (TimedElement.isUnresolved(f2) || f2 == Float.POSITIVE_INFINITY) {
            return f2;
        }
        return f2 * f3;
    }

    protected float minTime(float f2, float f3) {
        if (f2 == 0.0f || f3 == 0.0f) {
            return 0.0f;
        }
        if ((f2 == Float.POSITIVE_INFINITY || TimedElement.isUnresolved(f2)) && f3 != Float.POSITIVE_INFINITY && !TimedElement.isUnresolved(f3)) {
            return f3;
        }
        if ((f3 == Float.POSITIVE_INFINITY || TimedElement.isUnresolved(f3)) && f2 != Float.POSITIVE_INFINITY && !TimedElement.isUnresolved(f2)) {
            return f2;
        }
        if (f2 == Float.POSITIVE_INFINITY && TimedElement.isUnresolved(f3) || TimedElement.isUnresolved(f2) && f3 == Float.POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        if (f2 < f3) {
            return f2;
        }
        return f3;
    }

    protected float maxTime(float f2, float f3) {
        if ((f2 == Float.POSITIVE_INFINITY || TimedElement.isUnresolved(f2)) && f3 != Float.POSITIVE_INFINITY && !TimedElement.isUnresolved(f3)) {
            return f2;
        }
        if ((f3 == Float.POSITIVE_INFINITY || TimedElement.isUnresolved(f3)) && f2 != Float.POSITIVE_INFINITY && !TimedElement.isUnresolved(f2)) {
            return f3;
        }
        if (f2 == Float.POSITIVE_INFINITY && TimedElement.isUnresolved(f3) || TimedElement.isUnresolved(f2) && f3 == Float.POSITIVE_INFINITY) {
            return Float.NaN;
        }
        if (f2 > f3) {
            return f2;
        }
        return f3;
    }

    protected float getImplicitDur() {
        return Float.NaN;
    }

    protected float notifyNewInterval(Interval interval) {
        float f2;
        float f3 = Float.POSITIVE_INFINITY;
        for (TimingSpecifier timingSpecifier : this.beginDependents) {
            f2 = timingSpecifier.newInterval(interval);
            if (!(f2 < f3)) continue;
            f3 = f2;
        }
        for (TimingSpecifier timingSpecifier : this.endDependents) {
            f2 = timingSpecifier.newInterval(interval);
            if (!(f2 < f3)) continue;
            f3 = f2;
        }
        return f3;
    }

    protected float notifyRemoveInterval(Interval interval) {
        float f2;
        float f3 = Float.POSITIVE_INFINITY;
        for (TimingSpecifier timingSpecifier : this.beginDependents) {
            f2 = timingSpecifier.removeInterval(interval);
            if (!(f2 < f3)) continue;
            f3 = f2;
        }
        for (TimingSpecifier timingSpecifier : this.endDependents) {
            f2 = timingSpecifier.removeInterval(interval);
            if (!(f2 < f3)) continue;
            f3 = f2;
        }
        return f3;
    }

    protected float sampleAt(float f2, boolean bl2) {
        float f3;
        boolean bl3;
        float f4;
        this.isSampling = true;
        float f5 = f2;
        Iterator iterator = this.handledEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl4;
            boolean bl5;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Event event = (Event)entry2.getKey();
            Set set = (Set)entry2.getValue();
            Iterator iterator2 = set.iterator();
            boolean bl6 = false;
            boolean bl7 = false;
            while (!(!iterator2.hasNext() || bl6 && bl7)) {
                EventLikeTimingSpecifier eventLikeTimingSpecifier = (EventLikeTimingSpecifier)iterator2.next();
                if (eventLikeTimingSpecifier.isBegin()) {
                    bl6 = true;
                    continue;
                }
                bl7 = true;
            }
            if (bl6 && bl7) {
                bl5 = !this.isActive || this.restartMode == 0;
                bl4 = !bl5;
            } else if (bl6 && (!this.isActive || this.restartMode == 0)) {
                bl5 = true;
                bl4 = false;
            } else {
                if (!bl7 || !this.isActive) continue;
                bl5 = false;
                bl4 = true;
            }
            for (EventLikeTimingSpecifier eventLikeTimingSpecifier : set) {
                boolean bl8 = eventLikeTimingSpecifier.isBegin();
                if ((!bl8 || !bl5) && (bl8 || !bl4)) continue;
                eventLikeTimingSpecifier.resolve(event);
                this.shouldUpdateCurrentInterval = true;
            }
        }
        this.handledEvents.clear();
        if (this.currentInterval != null && this.lastSampleTime < (f4 = this.currentInterval.getBegin()) && f5 >= f4) {
            if (!this.isActive) {
                this.toActive(f4);
            }
            this.isActive = true;
            this.isFrozen = false;
            this.lastRepeatTime = f4;
            this.fireTimeEvent("beginEvent", this.currentInterval.getBegin(), 0);
        }
        boolean bl9 = bl3 = this.currentInterval != null && f5 >= this.currentInterval.getEnd();
        if (this.currentInterval != null && f5 >= (f3 = this.currentInterval.getBegin())) {
            float f6 = this.getSimpleDur();
            while (f5 - this.lastRepeatTime >= f6 && this.lastRepeatTime + f6 < f3 + this.repeatDuration) {
                this.lastRepeatTime += f6;
                ++this.currentRepeatIteration;
                this.fireTimeEvent(this.root.getRepeatEventName(), this.lastRepeatTime, this.currentRepeatIteration);
            }
        }
        float f7 = Float.POSITIVE_INFINITY;
        if (bl2) {
            this.shouldUpdateCurrentInterval = true;
        }
        while (this.shouldUpdateCurrentInterval || bl3) {
            float f8;
            boolean bl10;
            if (bl3) {
                this.previousInterval = this.currentInterval;
                this.isActive = false;
                this.isFrozen = this.fillMode == 1;
                this.toInactive(false, this.isFrozen);
                this.fireTimeEvent("endEvent", this.currentInterval.getEnd(), 0);
            }
            boolean bl11 = bl10 = this.currentInterval == null && this.previousInterval == null;
            if (this.currentInterval != null && bl2) {
                this.isActive = false;
                this.isFrozen = false;
                this.toInactive(false, false);
                this.currentInterval = null;
            }
            if (this.currentInterval == null || bl3) {
                if (bl10 || bl2 || this.restartMode != 2) {
                    boolean bl12 = true;
                    if (bl10 || bl2) {
                        f8 = Float.NEGATIVE_INFINITY;
                    } else {
                        f8 = this.previousInterval.getEnd();
                        bl12 = f8 != this.previousInterval.getBegin();
                    }
                    Interval interval = this.computeInterval(bl10, false, f8, bl12);
                    if (interval == null) {
                        this.currentInterval = null;
                    } else {
                        float f9 = this.selectNewInterval(f5, interval);
                        if (f9 < f7) {
                            f7 = f9;
                        }
                    }
                } else {
                    this.currentInterval = null;
                }
            } else {
                f8 = this.currentInterval.getBegin();
                if (f8 > f5) {
                    float f10;
                    boolean bl13 = true;
                    if (this.previousInterval == null) {
                        f10 = Float.NEGATIVE_INFINITY;
                    } else {
                        f10 = this.previousInterval.getEnd();
                        bl13 = f10 != this.previousInterval.getBegin();
                    }
                    Interval interval = this.computeInterval(false, false, f10, bl13);
                    float f11 = this.notifyRemoveInterval(this.currentInterval);
                    if (f11 < f7) {
                        f7 = f11;
                    }
                    if (interval == null) {
                        this.currentInterval = null;
                    } else {
                        f11 = this.selectNewInterval(f5, interval);
                        if (f11 < f7) {
                            f7 = f11;
                        }
                    }
                } else {
                    float f12;
                    Interval interval = this.computeInterval(false, true, f8, true);
                    float f13 = interval.getEnd();
                    if (this.currentInterval.getEnd() != f13 && (f12 = this.currentInterval.setEnd(f13, interval.getEndInstanceTime())) < f7) {
                        f7 = f12;
                    }
                }
            }
            this.shouldUpdateCurrentInterval = false;
            bl2 = false;
            bl3 = this.currentInterval != null && f5 >= this.currentInterval.getEnd();
        }
        float f14 = this.getSimpleDur();
        if (this.isActive && !this.isFrozen) {
            if (f5 - this.currentInterval.getBegin() >= this.repeatDuration) {
                this.isFrozen = this.fillMode == 1;
                this.toInactive(true, this.isFrozen);
            } else {
                this.sampledAt(f5 - this.lastRepeatTime, f14, this.currentRepeatIteration);
            }
        }
        if (this.isFrozen) {
            boolean bl14;
            float f15;
            if (this.isActive) {
                f15 = this.currentInterval.getBegin() + this.repeatDuration - this.lastRepeatTime;
                bl14 = this.lastRepeatTime + f14 == this.currentInterval.getBegin() + this.repeatDuration;
            } else {
                f15 = this.previousInterval.getEnd() - this.lastRepeatTime;
                boolean bl15 = bl14 = this.lastRepeatTime + f14 == this.previousInterval.getEnd();
            }
            if (bl14) {
                this.sampledLastValue(this.currentRepeatIteration);
            } else {
                this.sampledAt(f15 % f14, f14, this.currentRepeatIteration);
            }
        } else if (!this.isActive) {
            // empty if block
        }
        this.isSampling = false;
        this.lastSampleTime = f5;
        if (this.currentInterval != null) {
            float f16 = this.currentInterval.getBegin() - f5;
            if (f16 <= 0.0f) {
                float f17 = f16 = this.isConstantAnimation() || this.isFrozen ? this.currentInterval.getEnd() - f5 : 0.0f;
            }
            if (f7 < f16) {
                return f7;
            }
            return f16;
        }
        return f7;
    }

    protected boolean endHasEventConditions() {
        for (TimingSpecifier timingSpecifier : this.endTimes) {
            if (!timingSpecifier.isEventCondition()) continue;
            return true;
        }
        return false;
    }

    protected float selectNewInterval(float f2, Interval interval) {
        this.currentInterval = interval;
        float f3 = this.notifyNewInterval(this.currentInterval);
        float f4 = this.currentInterval.getBegin();
        if (f2 >= f4) {
            this.lastRepeatTime = f4;
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            this.toActive(f4);
            this.isActive = true;
            this.isFrozen = false;
            this.fireTimeEvent("beginEvent", f4, 0);
            float f5 = this.getSimpleDur();
            float f6 = this.currentInterval.getEnd();
            while (f2 - this.lastRepeatTime >= f5 && this.lastRepeatTime + f5 < f6) {
                this.lastRepeatTime += f5;
                ++this.currentRepeatIteration;
                this.fireTimeEvent(this.root.getRepeatEventName(), this.lastRepeatTime, this.currentRepeatIteration);
            }
        }
        return f3;
    }

    protected Interval computeInterval(boolean bl2, boolean bl3, float f2, boolean bl4) {
        Iterator iterator = this.beginInstanceTimes.iterator();
        Iterator iterator2 = this.endInstanceTimes.iterator();
        float f3 = this.parent.getSimpleDur();
        InstanceTime instanceTime = iterator2.hasNext() ? (InstanceTime)iterator2.next() : null;
        boolean bl5 = true;
        InstanceTime instanceTime2 = null;
        InstanceTime instanceTime3 = null;
        while (true) {
            float f4;
            float f5;
            float f6;
            if (bl3) {
                f6 = f2;
                while (iterator.hasNext() && !((instanceTime3 = (InstanceTime)iterator.next()).getTime() > f6)) {
                }
            } else {
                while (true) {
                    if (!iterator.hasNext()) {
                        return null;
                    }
                    instanceTime2 = (InstanceTime)iterator.next();
                    f6 = instanceTime2.getTime();
                    if (!(bl4 && f6 >= f2) && (bl4 || !(f6 > f2))) continue;
                    if (!iterator.hasNext()) break;
                    instanceTime3 = (InstanceTime)iterator.next();
                    if (instanceTime2.getTime() != instanceTime3.getTime()) break;
                    instanceTime3 = null;
                }
            }
            if (f6 >= f3) {
                return null;
            }
            if (this.endTimes.length == 0) {
                f5 = f6 + this.getActiveDur(f6, Float.POSITIVE_INFINITY);
            } else {
                if (this.endInstanceTimes.isEmpty()) {
                    f5 = Float.NaN;
                } else {
                    f5 = instanceTime.getTime();
                    if (bl2 && !bl5 && f5 == f6 || !bl2 && this.currentInterval != null && f5 == this.currentInterval.getEnd() && (bl4 && f2 >= f5 || !bl4 && f2 > f5)) {
                        do {
                            if (iterator2.hasNext()) continue;
                            if (this.endHasEventConditions()) {
                                f5 = Float.NaN;
                                break;
                            }
                            return null;
                        } while (!((f5 = (instanceTime = (InstanceTime)iterator2.next()).getTime()) > f6));
                    }
                    bl5 = false;
                    while (!(f5 >= f6)) {
                        if (!iterator2.hasNext()) {
                            if (this.endHasEventConditions()) {
                                f5 = Float.NaN;
                                break;
                            }
                            return null;
                        }
                        instanceTime = (InstanceTime)iterator2.next();
                        f5 = instanceTime.getTime();
                    }
                }
                f4 = this.getActiveDur(f6, f5);
                f5 = f6 + f4;
            }
            if (!bl2 || f5 > 0.0f || f6 == 0.0f && f5 == 0.0f || TimedElement.isUnresolved(f5)) {
                if (this.restartMode == 0 && instanceTime3 != null && ((f4 = instanceTime3.getTime()) < f5 || TimedElement.isUnresolved(f5))) {
                    f5 = f4;
                    instanceTime = instanceTime3;
                }
                Interval interval = new Interval(f6, f5, instanceTime2, instanceTime);
                return interval;
            }
            if (bl3) {
                return null;
            }
            f2 = f5;
        }
    }

    protected void reset(boolean bl2) {
        InstanceTime instanceTime;
        Iterator iterator = this.beginInstanceTimes.iterator();
        while (iterator.hasNext()) {
            instanceTime = (InstanceTime)iterator.next();
            if (!instanceTime.getClearOnReset() || !bl2 && this.currentInterval != null && this.currentInterval.getBeginInstanceTime() == instanceTime) continue;
            iterator.remove();
        }
        iterator = this.endInstanceTimes.iterator();
        while (iterator.hasNext()) {
            instanceTime = (InstanceTime)iterator.next();
            if (!instanceTime.getClearOnReset()) continue;
            iterator.remove();
        }
        if (this.isFrozen) {
            this.removeFill();
        }
        this.currentRepeatIteration = 0;
        this.lastRepeatTime = Float.NaN;
        this.isActive = false;
        this.isFrozen = false;
        this.lastSampleTime = Float.NaN;
    }

    public void parseAttributes(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        if (!this.hasParsed) {
            this.parseBegin(string);
            this.parseDur(string2);
            this.parseEnd(string3);
            this.parseMin(string4);
            this.parseMax(string5);
            if (this.min > this.max) {
                this.min = 0.0f;
                this.max = Float.POSITIVE_INFINITY;
            }
            this.parseRepeatCount(string6);
            this.parseRepeatDur(string7);
            this.parseFill(string8);
            this.parseRestart(string9);
            this.hasParsed = true;
        }
    }

    protected void parseBegin(String string) {
        try {
            if (string.length() == 0) {
                string = "0";
            }
            this.beginTimes = TimingSpecifierListProducer.parseTimingSpecifierList(this, true, string, this.root.useSVG11AccessKeys, this.root.useSVG12AccessKeys);
        }
        catch (ParseException parseException) {
            throw this.createException("attribute.malformed", new Object[]{null, "begin"});
        }
    }

    protected void parseDur(String string) {
        if (string.equals("media")) {
            this.durMedia = true;
            this.simpleDur = Float.NaN;
        } else {
            this.durMedia = false;
            if (string.length() == 0 || string.equals("indefinite")) {
                this.simpleDur = Float.POSITIVE_INFINITY;
            } else {
                try {
                    this.simpleDur = this.parseClockValue(string, false);
                }
                catch (ParseException parseException) {
                    throw this.createException("attribute.malformed", new Object[]{null, "dur"});
                }
                if (this.simpleDur < 0.0f) {
                    this.simpleDur = Float.POSITIVE_INFINITY;
                }
            }
        }
    }

    protected float parseClockValue(String string, boolean bl2) {
        ClockParser clockParser = new ClockParser(bl2);
        class Handler
        implements ClockHandler {
            protected float v = 0.0f;

            Handler() {
            }

            @Override
            public void clockValue(float f2) {
                this.v = f2;
            }
        }
        Handler handler = new Handler();
        clockParser.setClockHandler(handler);
        clockParser.parse(string);
        return handler.v;
    }

    protected void parseEnd(String string) {
        try {
            this.endTimes = TimingSpecifierListProducer.parseTimingSpecifierList(this, false, string, this.root.useSVG11AccessKeys, this.root.useSVG12AccessKeys);
        }
        catch (ParseException parseException) {
            throw this.createException("attribute.malformed", new Object[]{null, "end"});
        }
    }

    protected void parseMin(String string) {
        if (string.equals("media")) {
            this.min = 0.0f;
            this.minMedia = true;
        } else {
            this.minMedia = false;
            if (string.length() == 0) {
                this.min = 0.0f;
            } else {
                try {
                    this.min = this.parseClockValue(string, false);
                }
                catch (ParseException parseException) {
                    this.min = 0.0f;
                }
                if (this.min < 0.0f) {
                    this.min = 0.0f;
                }
            }
        }
    }

    protected void parseMax(String string) {
        if (string.equals("media")) {
            this.max = Float.POSITIVE_INFINITY;
            this.maxMedia = true;
        } else {
            this.maxMedia = false;
            if (string.length() == 0 || string.equals("indefinite")) {
                this.max = Float.POSITIVE_INFINITY;
            } else {
                try {
                    this.max = this.parseClockValue(string, false);
                }
                catch (ParseException parseException) {
                    this.max = Float.POSITIVE_INFINITY;
                }
                if (this.max < 0.0f) {
                    this.max = 0.0f;
                }
            }
        }
    }

    protected void parseRepeatCount(String string) {
        if (string.length() == 0) {
            this.repeatCount = Float.NaN;
        } else if (string.equals("indefinite")) {
            this.repeatCount = Float.POSITIVE_INFINITY;
        } else {
            try {
                this.repeatCount = Float.parseFloat(string);
                if (this.repeatCount > 0.0f) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.createException("attribute.malformed", new Object[]{null, "repeatCount"});
            }
        }
    }

    protected void parseRepeatDur(String string) {
        try {
            this.repeatDur = string.length() == 0 ? Float.NaN : (string.equals("indefinite") ? Float.POSITIVE_INFINITY : this.parseClockValue(string, false));
        }
        catch (ParseException parseException) {
            throw this.createException("attribute.malformed", new Object[]{null, "repeatDur"});
        }
    }

    protected void parseFill(String string) {
        if (string.length() == 0 || string.equals("remove")) {
            this.fillMode = 0;
        } else if (string.equals("freeze")) {
            this.fillMode = 1;
        } else {
            throw this.createException("attribute.malformed", new Object[]{null, "fill"});
        }
    }

    protected void parseRestart(String string) {
        if (string.length() == 0 || string.equals("always")) {
            this.restartMode = 0;
        } else if (string.equals("whenNotActive")) {
            this.restartMode = 1;
        } else if (string.equals("never")) {
            this.restartMode = 2;
        } else {
            throw this.createException("attribute.malformed", new Object[]{null, "restart"});
        }
    }

    public void initialize() {
        for (TimingSpecifier timingSpecifier : this.beginTimes) {
            timingSpecifier.initialize();
        }
        for (TimingSpecifier timingSpecifier : this.endTimes) {
            timingSpecifier.initialize();
        }
    }

    public void deinitialize() {
        for (TimingSpecifier timingSpecifier : this.beginTimes) {
            timingSpecifier.deinitialize();
        }
        for (TimingSpecifier timingSpecifier : this.endTimes) {
            timingSpecifier.deinitialize();
        }
    }

    public void beginElement() {
        this.beginElement(0.0f);
    }

    public void beginElement(float f2) {
        float f3 = this.root.convertWallclockTime(Calendar.getInstance());
        InstanceTime instanceTime = new InstanceTime(null, f3 + f2, true);
        this.addInstanceTime(instanceTime, true);
    }

    public void endElement() {
        this.endElement(0.0f);
    }

    public void endElement(float f2) {
        float f3 = this.root.convertWallclockTime(Calendar.getInstance());
        InstanceTime instanceTime = new InstanceTime(null, f3 + f2, true);
        this.addInstanceTime(instanceTime, false);
    }

    public float getLastSampleTime() {
        return this.lastSampleTime;
    }

    public float getCurrentBeginTime() {
        float f2;
        block3: {
            block2: {
                float f3;
                if (this.currentInterval == null) break block2;
                f2 = this.currentInterval.getBegin();
                if (!(f3 < this.lastSampleTime)) break block3;
            }
            return Float.NaN;
        }
        return f2;
    }

    public boolean canBegin() {
        return this.currentInterval == null || this.isActive && this.restartMode != 2;
    }

    public boolean canEnd() {
        return this.isActive;
    }

    public float getHyperlinkBeginTime() {
        if (this.isActive) {
            return this.currentInterval.getBegin();
        }
        if (!this.beginInstanceTimes.isEmpty()) {
            return ((InstanceTime)this.beginInstanceTimes.get(0)).getTime();
        }
        return Float.NaN;
    }

    public TimingSpecifier[] getBeginTimingSpecifiers() {
        return (TimingSpecifier[])this.beginTimes.clone();
    }

    public TimingSpecifier[] getEndTimingSpecifiers() {
        return (TimingSpecifier[])this.endTimes.clone();
    }

    protected void fireTimeEvent(String string, float f2, int n2) {
        Calendar calendar = (Calendar)this.root.getDocumentBeginTime().clone();
        calendar.add(14, (int)Math.round((double)f2 * 1000.0));
        this.fireTimeEvent(string, calendar, n2);
    }

    void eventOccurred(TimingSpecifier timingSpecifier, Event event) {
        HashSet<TimingSpecifier> hashSet = (HashSet<TimingSpecifier>)this.handledEvents.get(event);
        if (hashSet == null) {
            hashSet = new HashSet<TimingSpecifier>();
            this.handledEvents.put(event, hashSet);
        }
        hashSet.add(timingSpecifier);
        this.root.currentIntervalWillUpdate();
    }

    protected abstract void fireTimeEvent(String var1, Calendar var2, int var3);

    protected abstract void toActive(float var1);

    protected abstract void toInactive(boolean var1, boolean var2);

    protected abstract void removeFill();

    protected abstract void sampledAt(float var1, float var2, int var3);

    protected abstract void sampledLastValue(int var1);

    protected abstract TimedElement getTimedElementById(String var1);

    protected abstract EventTarget getEventTargetById(String var1);

    protected abstract EventTarget getRootEventTarget();

    public abstract Element getElement();

    protected abstract EventTarget getAnimationEventTarget();

    public abstract boolean isBefore(TimedElement var1);

    protected abstract boolean isConstantAnimation();

    public AnimationException createException(String string, Object[] objectArray) {
        Element element = this.getElement();
        if (element != null) {
            objectArray[0] = element.getNodeName();
        }
        return new AnimationException(this, string, objectArray);
    }

    public static void setLocale(Locale locale) {
        localizableSupport.setLocale(locale);
    }

    public static Locale getLocale() {
        return localizableSupport.getLocale();
    }

    public static String formatMessage(String string, Object[] objectArray) {
        return localizableSupport.formatMessage(string, objectArray);
    }

    public static String toString(float f2) {
        if (Float.isNaN(f2)) {
            return "UNRESOLVED";
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return "INDEFINITE";
        }
        return Float.toString(f2);
    }
}

