/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.Calendar;
import java.util.LinkedList;
import org.apache.batik.anim.timing.InstanceTime;
import org.apache.batik.anim.timing.Interval;
import org.apache.batik.anim.timing.TimeContainer;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.timing.TimegraphListener;
import org.apache.batik.anim.timing.TimingSpecifier;
import org.apache.batik.util.DoublyIndexedSet;

public abstract class TimedDocumentRoot
extends TimeContainer {
    protected Calendar documentBeginTime;
    protected boolean useSVG11AccessKeys;
    protected boolean useSVG12AccessKeys;
    protected DoublyIndexedSet propagationFlags = new DoublyIndexedSet();
    protected LinkedList listeners = new LinkedList();
    protected boolean isSampling;
    protected boolean isHyperlinking;

    public TimedDocumentRoot(boolean bl2, boolean bl3) {
        this.root = this;
        this.useSVG11AccessKeys = bl2;
        this.useSVG12AccessKeys = bl3;
    }

    @Override
    protected float getImplicitDur() {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    public float getDefaultBegin(TimedElement timedElement) {
        return 0.0f;
    }

    public float getCurrentTime() {
        return this.lastSampleTime;
    }

    public boolean isSampling() {
        return this.isSampling;
    }

    public boolean isHyperlinking() {
        return this.isHyperlinking;
    }

    public float seekTo(float f2, boolean bl2) {
        boolean bl3;
        TimedElement[] timedElementArray;
        this.isSampling = true;
        this.lastSampleTime = f2;
        this.isHyperlinking = bl2;
        this.propagationFlags.clear();
        float f3 = Float.POSITIVE_INFINITY;
        for (TimedElement timedElement : timedElementArray = this.getChildren()) {
            float f4 = timedElement.sampleAt(f2, bl2);
            if (!(f4 < f3)) continue;
            f3 = f4;
        }
        do {
            bl3 = false;
            for (TimedElement timedElement : timedElementArray) {
                if (!timedElement.shouldUpdateCurrentInterval) continue;
                bl3 = true;
                float f5 = timedElement.sampleAt(f2, bl2);
                if (!(f5 < f3)) continue;
                f3 = f5;
            }
        } while (bl3);
        this.isSampling = false;
        if (bl2) {
            this.root.currentIntervalWillUpdate();
        }
        return f3;
    }

    public void resetDocument(Calendar calendar) {
        this.documentBeginTime = calendar == null ? Calendar.getInstance() : calendar;
        this.reset(true);
    }

    public Calendar getDocumentBeginTime() {
        return this.documentBeginTime;
    }

    public float convertEpochTime(long l2) {
        long l3 = this.documentBeginTime.getTime().getTime();
        return (float)(l2 - l3) / 1000.0f;
    }

    public float convertWallclockTime(Calendar calendar) {
        long l2 = this.documentBeginTime.getTime().getTime();
        long l3 = calendar.getTime().getTime();
        return (float)(l3 - l2) / 1000.0f;
    }

    public void addTimegraphListener(TimegraphListener timegraphListener) {
        this.listeners.add(timegraphListener);
    }

    public void removeTimegraphListener(TimegraphListener timegraphListener) {
        this.listeners.remove(timegraphListener);
    }

    void fireElementAdded(TimedElement timedElement) {
        for (Object e2 : this.listeners) {
            ((TimegraphListener)e2).elementAdded(timedElement);
        }
    }

    void fireElementRemoved(TimedElement timedElement) {
        for (Object e2 : this.listeners) {
            ((TimegraphListener)e2).elementRemoved(timedElement);
        }
    }

    boolean shouldPropagate(Interval interval, TimingSpecifier timingSpecifier, boolean bl2) {
        InstanceTime instanceTime;
        InstanceTime instanceTime2 = instanceTime = bl2 ? interval.getBeginInstanceTime() : interval.getEndInstanceTime();
        if (this.propagationFlags.contains(instanceTime, timingSpecifier)) {
            return false;
        }
        this.propagationFlags.add(instanceTime, timingSpecifier);
        return true;
    }

    protected void currentIntervalWillUpdate() {
    }

    protected abstract String getEventNamespaceURI(String var1);

    protected abstract String getEventType(String var1);

    protected abstract String getRepeatEventName();
}

