/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.LinkedList;
import java.util.List;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;

public abstract class TimeContainer
extends TimedElement {
    protected List children = new LinkedList();

    public void addChild(TimedElement timedElement) {
        if (timedElement == this) {
            throw new IllegalArgumentException("recursive datastructure not allowed here!");
        }
        this.children.add(timedElement);
        timedElement.parent = this;
        this.setRoot(timedElement, this.root);
        this.root.fireElementAdded(timedElement);
        this.root.currentIntervalWillUpdate();
    }

    protected void setRoot(TimedElement timedElement, TimedDocumentRoot timedDocumentRoot) {
        timedElement.root = timedDocumentRoot;
        if (timedElement instanceof TimeContainer) {
            TimeContainer timeContainer = (TimeContainer)timedElement;
            for (Object e2 : timeContainer.children) {
                TimedElement timedElement2 = (TimedElement)e2;
                this.setRoot(timedElement2, timedDocumentRoot);
            }
        }
    }

    public void removeChild(TimedElement timedElement) {
        this.children.remove(timedElement);
        timedElement.parent = null;
        this.setRoot(timedElement, null);
        this.root.fireElementRemoved(timedElement);
        this.root.currentIntervalWillUpdate();
    }

    public TimedElement[] getChildren() {
        return this.children.toArray(new TimedElement[this.children.size()]);
    }

    @Override
    protected float sampleAt(float f2, boolean bl2) {
        super.sampleAt(f2, bl2);
        return this.sampleChildren(f2, bl2);
    }

    protected float sampleChildren(float f2, boolean bl2) {
        float f3 = Float.POSITIVE_INFINITY;
        for (Object e2 : this.children) {
            TimedElement timedElement = (TimedElement)e2;
            float f4 = timedElement.sampleAt(f2, bl2);
            if (!(f4 < f3)) continue;
            f3 = f4;
        }
        return f3;
    }

    @Override
    protected void reset(boolean bl2) {
        super.reset(bl2);
        for (Object e2 : this.children) {
            TimedElement timedElement = (TimedElement)e2;
            timedElement.reset(bl2);
        }
    }

    @Override
    protected boolean isConstantAnimation() {
        return false;
    }

    public abstract float getDefaultBegin(TimedElement var1);
}

