/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import org.apache.batik.anim.timing.EventLikeTimingSpecifier;
import org.apache.batik.anim.timing.InstanceTime;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.dom.events.NodeEventTarget;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class EventbaseTimingSpecifier
extends EventLikeTimingSpecifier
implements EventListener {
    protected String eventbaseID;
    protected TimedElement eventbase;
    protected EventTarget eventTarget;
    protected String eventNamespaceURI;
    protected String eventType;
    protected String eventName;

    public EventbaseTimingSpecifier(TimedElement timedElement, boolean bl2, float f2, String string, String string2) {
        super(timedElement, bl2, f2);
        this.eventbaseID = string;
        this.eventName = string2;
        TimedDocumentRoot timedDocumentRoot = timedElement.getRoot();
        this.eventNamespaceURI = timedDocumentRoot.getEventNamespaceURI(string2);
        this.eventType = timedDocumentRoot.getEventType(string2);
        this.eventTarget = string == null ? timedElement.getAnimationEventTarget() : timedElement.getEventTargetById(string);
    }

    @Override
    public String toString() {
        return (this.eventbaseID == null ? "" : this.eventbaseID + ".") + this.eventName + (this.offset != 0.0f ? super.toString() : "");
    }

    @Override
    public void initialize() {
        ((NodeEventTarget)this.eventTarget).addEventListenerNS(this.eventNamespaceURI, this.eventType, this, false, null);
    }

    @Override
    public void deinitialize() {
        ((NodeEventTarget)this.eventTarget).removeEventListenerNS(this.eventNamespaceURI, this.eventType, this, false);
    }

    @Override
    public void handleEvent(Event event) {
        this.owner.eventOccurred(this, event);
    }

    @Override
    public void resolve(Event event) {
        float f2 = this.owner.getRoot().convertEpochTime(event.getTimeStamp());
        InstanceTime instanceTime = new InstanceTime(this, f2 + this.offset, true);
        this.owner.addInstanceTime(instanceTime, this.isBegin);
    }
}

