/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import org.apache.batik.anim.timing.EventLikeTimingSpecifier;
import org.apache.batik.anim.timing.InstanceTime;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.dom.events.DOMKeyEvent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.w3c.dom.events.KeyboardEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class AccesskeyTimingSpecifier
extends EventLikeTimingSpecifier
implements EventListener {
    protected char accesskey;
    protected boolean isSVG12AccessKey;
    protected String keyName;

    public AccesskeyTimingSpecifier(TimedElement timedElement, boolean bl2, float f2, char c2) {
        super(timedElement, bl2, f2);
        this.accesskey = c2;
    }

    public AccesskeyTimingSpecifier(TimedElement timedElement, boolean bl2, float f2, String string) {
        super(timedElement, bl2, f2);
        this.isSVG12AccessKey = true;
        this.keyName = string;
    }

    @Override
    public String toString() {
        if (this.isSVG12AccessKey) {
            return "accessKey(" + this.keyName + ")" + (this.offset != 0.0f ? super.toString() : "");
        }
        return "accesskey(" + this.accesskey + ")" + (this.offset != 0.0f ? super.toString() : "");
    }

    @Override
    public void initialize() {
        if (this.isSVG12AccessKey) {
            NodeEventTarget nodeEventTarget = (NodeEventTarget)this.owner.getRootEventTarget();
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this, false, null);
        } else {
            EventTarget eventTarget = this.owner.getRootEventTarget();
            eventTarget.addEventListener("keypress", this, false);
        }
    }

    @Override
    public void deinitialize() {
        if (this.isSVG12AccessKey) {
            NodeEventTarget nodeEventTarget = (NodeEventTarget)this.owner.getRootEventTarget();
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this, false);
        } else {
            EventTarget eventTarget = this.owner.getRootEventTarget();
            eventTarget.removeEventListener("keypress", this, false);
        }
    }

    @Override
    public void handleEvent(Event event) {
        boolean bl2;
        if (event.getType().charAt(3) == 'p') {
            DOMKeyEvent dOMKeyEvent = (DOMKeyEvent)event;
            bl2 = dOMKeyEvent.getCharCode() == this.accesskey;
        } else {
            KeyboardEvent keyboardEvent = (KeyboardEvent)event;
            bl2 = keyboardEvent.getKeyIdentifier().equals(this.keyName);
        }
        if (bl2) {
            this.owner.eventOccurred(this, event);
        }
    }

    @Override
    public void resolve(Event event) {
        float f2 = this.owner.getRoot().convertEpochTime(event.getTimeStamp());
        InstanceTime instanceTime = new InstanceTime(this, f2 + this.offset, true);
        this.owner.addInstanceTime(instanceTime, this.isBegin);
    }
}

