/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.batik.anim.dom.XBLOMHandlerGroupElement;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.xbl.NodeXBL;
import org.apache.batik.dom.xbl.ShadowTreeEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;

public class XBLEventSupport
extends EventSupport {
    protected HashMap<String, EventListenerList> capturingImplementationListeners;
    protected HashMap<String, EventListenerList> bubblingImplementationListeners;
    protected static HashMap<String, String> eventTypeAliases = new HashMap();

    public XBLEventSupport(AbstractNode abstractNode) {
        super(abstractNode);
    }

    @Override
    public void addEventListenerNS(String string, String string2, EventListener eventListener, boolean bl2, Object object) {
        String string3;
        super.addEventListenerNS(string, string2, eventListener, bl2, object);
        if ((string == null || string.equals("http://www.w3.org/2001/xml-events")) && (string3 = eventTypeAliases.get(string2)) != null) {
            super.addEventListenerNS(string, string3, eventListener, bl2, object);
        }
    }

    @Override
    public void removeEventListenerNS(String string, String string2, EventListener eventListener, boolean bl2) {
        String string3;
        super.removeEventListenerNS(string, string2, eventListener, bl2);
        if ((string == null || string.equals("http://www.w3.org/2001/xml-events")) && (string3 = eventTypeAliases.get(string2)) != null) {
            super.removeEventListenerNS(string, string3, eventListener, bl2);
        }
    }

    public void addImplementationEventListenerNS(String string, String string2, EventListener eventListener, boolean bl2) {
        HashMap<String, EventListenerList> hashMap;
        if (bl2) {
            if (this.capturingImplementationListeners == null) {
                this.capturingImplementationListeners = new HashMap();
            }
            hashMap = this.capturingImplementationListeners;
        } else {
            if (this.bubblingImplementationListeners == null) {
                this.bubblingImplementationListeners = new HashMap();
            }
            hashMap = this.bubblingImplementationListeners;
        }
        EventListenerList eventListenerList = hashMap.get(string2);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            hashMap.put(string2, eventListenerList);
        }
        eventListenerList.addListener(string, null, eventListener);
    }

    public void removeImplementationEventListenerNS(String string, String string2, EventListener eventListener, boolean bl2) {
        HashMap<String, EventListenerList> hashMap;
        HashMap<String, EventListenerList> hashMap2 = hashMap = bl2 ? this.capturingImplementationListeners : this.bubblingImplementationListeners;
        if (hashMap == null) {
            return;
        }
        EventListenerList eventListenerList = hashMap.get(string2);
        if (eventListenerList == null) {
            return;
        }
        eventListenerList.removeListener(string, eventListener);
        if (eventListenerList.size() == 0) {
            hashMap.remove(string2);
        }
    }

    @Override
    public void moveEventListeners(EventSupport eventSupport) {
        super.moveEventListeners(eventSupport);
        XBLEventSupport xBLEventSupport = (XBLEventSupport)eventSupport;
        xBLEventSupport.capturingImplementationListeners = this.capturingImplementationListeners;
        xBLEventSupport.bubblingImplementationListeners = this.bubblingImplementationListeners;
        this.capturingImplementationListeners = null;
        this.bubblingImplementationListeners = null;
    }

    @Override
    public boolean dispatchEvent(NodeEventTarget nodeEventTarget, Event event) {
        NodeEventTarget nodeEventTarget2;
        int n2;
        Serializable serializable;
        AbstractEvent[] abstractEventArray;
        if (event == null) {
            return false;
        }
        if (!(event instanceof AbstractEvent)) {
            throw this.createEventException((short)9, "unsupported.event", new Object[0]);
        }
        AbstractEvent abstractEvent = (AbstractEvent)event;
        String string = abstractEvent.getType();
        if (string == null || string.length() == 0) {
            throw this.createEventException((short)0, "unspecified.event", new Object[0]);
        }
        this.setTarget(abstractEvent, nodeEventTarget);
        this.stopPropagation(abstractEvent, false);
        this.stopImmediatePropagation(abstractEvent, false);
        this.preventDefault(abstractEvent, false);
        NodeEventTarget[] nodeEventTargetArray = this.getAncestors(nodeEventTarget);
        int n3 = abstractEvent.getBubbleLimit();
        int n4 = 0;
        if (this.isSingleScopeEvent(abstractEvent)) {
            abstractEventArray = (AbstractEvent[])nodeEventTarget;
            Element element = abstractEventArray.getXblBoundElement();
            if (element != null) {
                for (n4 = nodeEventTargetArray.length; n4 > 0 && ((AbstractNode)(serializable = (AbstractNode)nodeEventTargetArray[n4 - 1])).getXblBoundElement() == element; --n4) {
                }
            }
        } else if (n3 != 0 && (n4 = nodeEventTargetArray.length - n3 + 1) < 0) {
            n4 = 0;
        }
        abstractEventArray = this.getRetargettedEvents(nodeEventTarget, nodeEventTargetArray, abstractEvent);
        boolean bl2 = false;
        serializable = new HashSet();
        HashSet hashSet = new HashSet();
        for (n2 = 0; n2 < n4; ++n2) {
            nodeEventTarget2 = nodeEventTargetArray[n2];
            this.setCurrentTarget(abstractEventArray[n2], nodeEventTarget2);
            this.setEventPhase(abstractEventArray[n2], (short)1);
            this.fireImplementationEventListeners(nodeEventTarget2, abstractEventArray[n2], true);
        }
        for (n2 = n4; n2 < nodeEventTargetArray.length; ++n2) {
            nodeEventTarget2 = nodeEventTargetArray[n2];
            this.setCurrentTarget(abstractEventArray[n2], nodeEventTarget2);
            this.setEventPhase(abstractEventArray[n2], (short)1);
            this.fireImplementationEventListeners(nodeEventTarget2, abstractEventArray[n2], true);
            this.fireEventListeners(nodeEventTarget2, abstractEventArray[n2], true, (HashSet)serializable, hashSet);
            this.fireHandlerGroupEventListeners(nodeEventTarget2, abstractEventArray[n2], true, (HashSet)serializable, hashSet);
            bl2 = bl2 || abstractEventArray[n2].getDefaultPrevented();
            ((AbstractCollection)((Object)serializable)).addAll(hashSet);
            hashSet.clear();
        }
        this.setEventPhase(abstractEvent, (short)2);
        this.setCurrentTarget(abstractEvent, nodeEventTarget);
        this.fireImplementationEventListeners(nodeEventTarget, abstractEvent, false);
        this.fireEventListeners(nodeEventTarget, abstractEvent, false, (HashSet)serializable, hashSet);
        this.fireHandlerGroupEventListeners(this.node, abstractEvent, false, (HashSet)serializable, hashSet);
        ((AbstractCollection)((Object)serializable)).addAll(hashSet);
        hashSet.clear();
        boolean bl3 = bl2 = bl2 || abstractEvent.getDefaultPrevented();
        if (abstractEvent.getBubbles()) {
            for (n2 = nodeEventTargetArray.length - 1; n2 >= n4; --n2) {
                nodeEventTarget2 = nodeEventTargetArray[n2];
                this.setCurrentTarget(abstractEventArray[n2], nodeEventTarget2);
                this.setEventPhase(abstractEventArray[n2], (short)3);
                this.fireImplementationEventListeners(nodeEventTarget2, abstractEventArray[n2], false);
                this.fireEventListeners(nodeEventTarget2, abstractEventArray[n2], false, (HashSet)serializable, hashSet);
                this.fireHandlerGroupEventListeners(nodeEventTarget2, abstractEventArray[n2], false, (HashSet)serializable, hashSet);
                bl2 = bl2 || abstractEventArray[n2].getDefaultPrevented();
                ((AbstractCollection)((Object)serializable)).addAll(hashSet);
                hashSet.clear();
            }
            for (n2 = n4 - 1; n2 >= 0; --n2) {
                nodeEventTarget2 = nodeEventTargetArray[n2];
                this.setCurrentTarget(abstractEventArray[n2], nodeEventTarget2);
                this.setEventPhase(abstractEventArray[n2], (short)3);
                this.fireImplementationEventListeners(nodeEventTarget2, abstractEventArray[n2], false);
                bl2 = bl2 || abstractEventArray[n2].getDefaultPrevented();
            }
        }
        if (!bl2) {
            this.runDefaultActions(abstractEvent);
        }
        return bl2;
    }

    protected void fireHandlerGroupEventListeners(NodeEventTarget nodeEventTarget, AbstractEvent abstractEvent, boolean bl2, HashSet hashSet, HashSet hashSet2) {
        NodeList nodeList = ((NodeXBL)((Object)nodeEventTarget)).getXblDefinitions();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node;
            for (node = nodeList.item(i2).getFirstChild(); node != null && !(node instanceof XBLOMHandlerGroupElement); node = node.getNextSibling()) {
            }
            if (node == null) continue;
            nodeEventTarget = (NodeEventTarget)((Object)node);
            String string = abstractEvent.getType();
            EventSupport eventSupport = nodeEventTarget.getEventSupport();
            if (eventSupport == null) continue;
            EventListenerList eventListenerList = eventSupport.getEventListeners(string, bl2);
            if (eventListenerList == null) {
                return;
            }
            EventListenerList.Entry[] entryArray = eventListenerList.getEventListeners();
            this.fireEventListeners(nodeEventTarget, abstractEvent, entryArray, hashSet, hashSet2);
        }
    }

    protected boolean isSingleScopeEvent(Event event) {
        return event instanceof MutationEvent || event instanceof ShadowTreeEvent;
    }

    protected AbstractEvent[] getRetargettedEvents(NodeEventTarget nodeEventTarget, NodeEventTarget[] nodeEventTargetArray, AbstractEvent abstractEvent) {
        boolean bl2 = this.isSingleScopeEvent(abstractEvent);
        AbstractNode abstractNode = (AbstractNode)nodeEventTarget;
        AbstractEvent[] abstractEventArray = new AbstractEvent[nodeEventTargetArray.length];
        if (nodeEventTargetArray.length > 0) {
            int n2 = nodeEventTargetArray.length - 1;
            Element element = abstractNode.getXblBoundElement();
            AbstractNode abstractNode2 = (AbstractNode)nodeEventTargetArray[n2];
            abstractEventArray[n2] = !bl2 && abstractNode2.getXblBoundElement() != element ? this.retargetEvent(abstractEvent, nodeEventTargetArray[n2]) : abstractEvent;
            while (--n2 >= 0) {
                abstractNode2 = (AbstractNode)nodeEventTargetArray[n2 + 1];
                element = abstractNode2.getXblBoundElement();
                AbstractNode abstractNode3 = (AbstractNode)nodeEventTargetArray[n2];
                Element element2 = abstractNode3.getXblBoundElement();
                if (!bl2 && element2 != element) {
                    abstractEventArray[n2] = this.retargetEvent(abstractEventArray[n2 + 1], nodeEventTargetArray[n2]);
                    continue;
                }
                abstractEventArray[n2] = abstractEventArray[n2 + 1];
            }
        }
        return abstractEventArray;
    }

    protected AbstractEvent retargetEvent(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        AbstractEvent abstractEvent2 = abstractEvent.cloneEvent();
        this.setTarget(abstractEvent2, nodeEventTarget);
        return abstractEvent2;
    }

    public EventListenerList getImplementationEventListeners(String string, boolean bl2) {
        HashMap<String, EventListenerList> hashMap = bl2 ? this.capturingImplementationListeners : this.bubblingImplementationListeners;
        return hashMap != null ? hashMap.get(string) : null;
    }

    protected void fireImplementationEventListeners(NodeEventTarget nodeEventTarget, AbstractEvent abstractEvent, boolean bl2) {
        String string = abstractEvent.getType();
        XBLEventSupport xBLEventSupport = (XBLEventSupport)nodeEventTarget.getEventSupport();
        if (xBLEventSupport == null) {
            return;
        }
        EventListenerList eventListenerList = xBLEventSupport.getImplementationEventListeners(string, bl2);
        if (eventListenerList == null) {
            return;
        }
        EventListenerList.Entry[] entryArray = eventListenerList.getEventListeners();
        this.fireEventListeners(nodeEventTarget, abstractEvent, entryArray, null, null);
    }

    static {
        eventTypeAliases.put("SVGLoad", "load");
        eventTypeAliases.put("SVGUnoad", "unload");
        eventTypeAliases.put("SVGAbort", "abort");
        eventTypeAliases.put("SVGError", "error");
        eventTypeAliases.put("SVGResize", "resize");
        eventTypeAliases.put("SVGScroll", "scroll");
        eventTypeAliases.put("SVGZoom", "zoom");
    }
}

