/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.dom.svg.SVGTextContent;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;

public class SVGTextContentSupport {
    public static int getNumberOfChars(Element element) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        return ((SVGTextContent)((Object)sVGOMElement.getSVGContext())).getNumberOfChars();
    }

    public static SVGRect getExtentOfChar(Element element, final int n2) {
        final SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n2 < 0 || n2 >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGRect(){

            @Override
            public float getX() {
                return (float)SVGTextContentSupport.getExtent(sVGOMElement, sVGTextContent, n2).getX();
            }

            @Override
            public void setX(float f2) {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            @Override
            public float getY() {
                return (float)SVGTextContentSupport.getExtent(sVGOMElement, sVGTextContent, n2).getY();
            }

            @Override
            public void setY(float f2) {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            @Override
            public float getWidth() {
                return (float)SVGTextContentSupport.getExtent(sVGOMElement, sVGTextContent, n2).getWidth();
            }

            @Override
            public void setWidth(float f2) {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            @Override
            public float getHeight() {
                return (float)SVGTextContentSupport.getExtent(sVGOMElement, sVGTextContent, n2).getHeight();
            }

            @Override
            public void setHeight(float f2) {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }
        };
    }

    protected static Rectangle2D getExtent(SVGOMElement sVGOMElement, SVGTextContent sVGTextContent, int n2) {
        Rectangle2D rectangle2D = sVGTextContent.getExtentOfChar(n2);
        if (rectangle2D == null) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        return rectangle2D;
    }

    public static SVGPoint getStartPositionOfChar(Element element, final int n2) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n2 < 0 || n2 >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGTextPoint(sVGOMElement){

            @Override
            public float getX() {
                return (float)SVGTextContentSupport.getStartPos(this.svgelt, sVGTextContent, n2).getX();
            }

            @Override
            public float getY() {
                return (float)SVGTextContentSupport.getStartPos(this.svgelt, sVGTextContent, n2).getY();
            }
        };
    }

    protected static Point2D getStartPos(SVGOMElement sVGOMElement, SVGTextContent sVGTextContent, int n2) {
        Point2D point2D = sVGTextContent.getStartPositionOfChar(n2);
        if (point2D == null) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        return point2D;
    }

    public static SVGPoint getEndPositionOfChar(Element element, final int n2) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n2 < 0 || n2 >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGTextPoint(sVGOMElement){

            @Override
            public float getX() {
                return (float)SVGTextContentSupport.getEndPos(this.svgelt, sVGTextContent, n2).getX();
            }

            @Override
            public float getY() {
                return (float)SVGTextContentSupport.getEndPos(this.svgelt, sVGTextContent, n2).getY();
            }
        };
    }

    protected static Point2D getEndPos(SVGOMElement sVGOMElement, SVGTextContent sVGTextContent, int n2) {
        Point2D point2D = sVGTextContent.getEndPositionOfChar(n2);
        if (point2D == null) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        return point2D;
    }

    public static void selectSubString(Element element, int n2, int n3) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n2 < 0 || n2 >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        sVGTextContent.selectSubString(n2, n3);
    }

    public static float getRotationOfChar(Element element, int n2) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n2 < 0 || n2 >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getRotationOfChar(n2);
    }

    public static float getComputedTextLength(Element element) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getComputedTextLength();
    }

    public static float getSubStringLength(Element element, int n2, int n3) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n2 < 0 || n2 >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getSubStringLength(n2, n3);
    }

    public static int getCharNumAtPosition(Element element, float f2, float f3) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getCharNumAtPosition(f2, f3);
    }

    public static class SVGTextPoint
    extends SVGOMPoint {
        SVGOMElement svgelt;

        SVGTextPoint(SVGOMElement sVGOMElement) {
            this.svgelt = sVGOMElement;
        }

        @Override
        public void setX(float f2) {
            throw this.svgelt.createDOMException((short)7, "readonly.point", null);
        }

        @Override
        public void setY(float f2) {
            throw this.svgelt.createDOMException((short)7, "readonly.point", null);
        }
    }
}

