/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.util.HashMap;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.StyleSheetProcessingInstruction;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Node;

public class SVGStyleSheetProcessingInstruction
extends StyleSheetProcessingInstruction
implements CSSStyleSheetNode {
    protected StyleSheet styleSheet;

    protected SVGStyleSheetProcessingInstruction() {
    }

    public SVGStyleSheetProcessingInstruction(String string, AbstractDocument abstractDocument, StyleSheetFactory styleSheetFactory) {
        super(string, abstractDocument, styleSheetFactory);
    }

    public String getStyleSheetURI() {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)this.getOwnerDocument();
        ParsedURL parsedURL = sVGOMDocument.getParsedURL();
        String string = this.getPseudoAttributes().get("href");
        if (parsedURL != null) {
            return new ParsedURL(parsedURL, string).toString();
        }
        return string;
    }

    @Override
    public StyleSheet getCSSStyleSheet() {
        HashMap<String, String> hashMap;
        String string;
        if (this.styleSheet == null && "text/css".equals(string = (hashMap = this.getPseudoAttributes()).get("type"))) {
            String string2 = hashMap.get("title");
            String string3 = hashMap.get("media");
            String string4 = hashMap.get("href");
            String string5 = hashMap.get("alternate");
            SVGOMDocument sVGOMDocument = (SVGOMDocument)this.getOwnerDocument();
            ParsedURL parsedURL = sVGOMDocument.getParsedURL();
            ParsedURL parsedURL2 = new ParsedURL(parsedURL, string4);
            CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
            this.styleSheet = cSSEngine.parseStyleSheet(parsedURL2, string3);
            this.styleSheet.setAlternate("yes".equals(string5));
            this.styleSheet.setTitle(string2);
        }
        return this.styleSheet;
    }

    @Override
    public void setData(String string) {
        super.setData(string);
        this.styleSheet = null;
    }

    @Override
    protected Node newNode() {
        return new SVGStyleSheetProcessingInstruction();
    }
}

