/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import org.apache.batik.anim.dom.AbstractSVGAnimatedLength;
import org.apache.batik.anim.dom.SVGOMAnimatedBoolean;
import org.apache.batik.anim.dom.SVGOMAnimatedEnumeration;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGStylableElement;
import org.apache.batik.anim.dom.SVGTextContentSupport;
import org.apache.batik.anim.dom.TraitInformation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.util.DoublyIndexedTable;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStringList;

public abstract class SVGOMTextContentElement
extends SVGStylableElement {
    protected static DoublyIndexedTable xmlTraitInformation;
    protected static final String[] LENGTH_ADJUST_VALUES;
    protected SVGOMAnimatedBoolean externalResourcesRequired;
    protected AbstractSVGAnimatedLength textLength;
    protected SVGOMAnimatedEnumeration lengthAdjust;

    protected SVGOMTextContentElement() {
    }

    protected SVGOMTextContentElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.initializeLiveAttributes();
    }

    @Override
    protected void initializeAllLiveAttributes() {
        super.initializeAllLiveAttributes();
        this.initializeLiveAttributes();
    }

    private void initializeLiveAttributes() {
        this.externalResourcesRequired = this.createLiveAnimatedBoolean(null, "externalResourcesRequired", false);
        this.lengthAdjust = this.createLiveAnimatedEnumeration(null, "lengthAdjust", LENGTH_ADJUST_VALUES, (short)1);
        this.textLength = new AbstractSVGAnimatedLength(this, null, "textLength", 2, true){
            boolean usedDefault;

            @Override
            protected String getDefaultValue() {
                this.usedDefault = true;
                return String.valueOf(SVGOMTextContentElement.this.getComputedTextLength());
            }

            @Override
            public SVGLength getBaseVal() {
                if (this.baseVal == null) {
                    this.baseVal = new SVGTextLength(this.direction);
                }
                return this.baseVal;
            }

            class SVGTextLength
            extends AbstractSVGAnimatedLength.BaseSVGLength {
                public SVGTextLength(short s2) {
                    super(this, s2);
                }

                @Override
                protected void revalidate() {
                    usedDefault = false;
                    super.revalidate();
                    if (usedDefault) {
                        this.valid = false;
                    }
                }
            }
        };
        this.liveAttributeValues.put(null, "textLength", this.textLength);
        this.textLength.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
    }

    public SVGAnimatedLength getTextLength() {
        return this.textLength;
    }

    public SVGAnimatedEnumeration getLengthAdjust() {
        return this.lengthAdjust;
    }

    public int getNumberOfChars() {
        return SVGTextContentSupport.getNumberOfChars(this);
    }

    public float getComputedTextLength() {
        return SVGTextContentSupport.getComputedTextLength(this);
    }

    public float getSubStringLength(int n2, int n3) {
        return SVGTextContentSupport.getSubStringLength(this, n2, n3);
    }

    public SVGPoint getStartPositionOfChar(int n2) {
        return SVGTextContentSupport.getStartPositionOfChar(this, n2);
    }

    public SVGPoint getEndPositionOfChar(int n2) {
        return SVGTextContentSupport.getEndPositionOfChar(this, n2);
    }

    public SVGRect getExtentOfChar(int n2) {
        return SVGTextContentSupport.getExtentOfChar(this, n2);
    }

    public float getRotationOfChar(int n2) {
        return SVGTextContentSupport.getRotationOfChar(this, n2);
    }

    public int getCharNumAtPosition(SVGPoint sVGPoint) {
        return SVGTextContentSupport.getCharNumAtPosition(this, sVGPoint.getX(), sVGPoint.getY());
    }

    public void selectSubString(int n2, int n3) {
        SVGTextContentSupport.selectSubString(this, n2, n3);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return this.externalResourcesRequired;
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang(this);
    }

    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace(this);
    }

    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures(this);
    }

    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions(this);
    }

    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage(this);
    }

    public boolean hasExtension(String string) {
        return SVGTestsSupport.hasExtension(this, string);
    }

    @Override
    protected DoublyIndexedTable getTraitInformationTable() {
        return xmlTraitInformation;
    }

    static {
        DoublyIndexedTable doublyIndexedTable = new DoublyIndexedTable(SVGStylableElement.xmlTraitInformation);
        doublyIndexedTable.put(null, "textLength", new TraitInformation(true, 3, 3));
        doublyIndexedTable.put(null, "lengthAdjust", new TraitInformation(true, 15));
        doublyIndexedTable.put(null, "externalResourcesRequired", new TraitInformation(true, 49));
        xmlTraitInformation = doublyIndexedTable;
        LENGTH_ADJUST_VALUES = new String[]{"", "spacing", "spacingAndGlyphs"};
    }
}

