/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.anim.dom.AbstractElement;
import org.apache.batik.anim.dom.AbstractSVGAnimatedValue;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.values.AnimatablePointListValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.svg.AbstractSVGPointList;
import org.apache.batik.dom.svg.ListBuilder;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGPointItem;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedPoints;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGOMAnimatedPoints
extends AbstractSVGAnimatedValue
implements SVGAnimatedPoints {
    protected BaseSVGPointList baseVal;
    protected AnimSVGPointList animVal;
    protected boolean changing;
    protected String defaultValue;

    public SVGOMAnimatedPoints(AbstractElement abstractElement, String string, String string2, String string3) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
    }

    @Override
    public SVGPointList getPoints() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGPointList();
        }
        return this.baseVal;
    }

    @Override
    public SVGPointList getAnimatedPoints() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGPointList();
        }
        return this.animVal;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.baseVal == null) {
                this.baseVal = new BaseSVGPointList();
            }
            this.baseVal.revalidate();
            if (this.baseVal.missing) {
                throw new LiveAttributeException(this.element, this.localName, 0, null);
            }
            if (this.baseVal.malformed) {
                throw new LiveAttributeException(this.element, this.localName, 1, this.baseVal.getValueAsString());
            }
        }
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGPointList sVGPointList = this.getPoints();
        int n2 = sVGPointList.getNumberOfItems();
        float[] fArray = new float[n2 * 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            SVGPoint sVGPoint = sVGPointList.getItem(i2);
            fArray[i2 * 2] = sVGPoint.getX();
            fArray[i2 * 2 + 1] = sVGPoint.getY();
        }
        return new AnimatablePointListValue(animationTarget, fArray);
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatablePointListValue animatablePointListValue = (AnimatablePointListValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGPointList();
            }
            this.animVal.setAnimatedValue(animatablePointListValue.getNumbers());
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGPointList
    extends AbstractSVGPointList {
        public AnimSVGPointList() {
            this.itemList = new ArrayList(1);
        }

        @Override
        protected DOMException createDOMException(short s2, String string, Object[] objectArray) {
            return SVGOMAnimatedPoints.this.element.createDOMException(s2, string, objectArray);
        }

        @Override
        protected SVGException createSVGException(short s2, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPoints.this.element).createSVGException(s2, string, objectArray);
        }

        @Override
        public int getNumberOfItems() {
            if (SVGOMAnimatedPoints.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedPoints.this.getPoints().getNumberOfItems();
        }

        @Override
        public SVGPoint getItem(int n2) {
            if (SVGOMAnimatedPoints.this.hasAnimVal) {
                return super.getItem(n2);
            }
            return SVGOMAnimatedPoints.this.getPoints().getItem(n2);
        }

        @Override
        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(this.getItemSeparator());
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuffer.toString();
        }

        @Override
        protected void setAttributeValue(String string) {
        }

        @Override
        public void clear() {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        @Override
        public SVGPoint initialize(SVGPoint sVGPoint) {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        @Override
        public SVGPoint insertItemBefore(SVGPoint sVGPoint, int n2) {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        @Override
        public SVGPoint replaceItem(SVGPoint sVGPoint, int n2) {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        @Override
        public SVGPoint removeItem(int n2) {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        @Override
        public SVGPoint appendItem(SVGPoint sVGPoint) {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        protected void setAnimatedValue(float[] fArray) {
            int n2;
            int n3 = this.itemList.size();
            for (n2 = 0; n2 < n3 && n2 < fArray.length / 2; ++n2) {
                SVGPointItem sVGPointItem = (SVGPointItem)this.itemList.get(n2);
                sVGPointItem.setX(fArray[n2 * 2]);
                sVGPointItem.setY(fArray[n2 * 2 + 1]);
            }
            while (n2 < fArray.length / 2) {
                this.appendItemImpl(new SVGPointItem(fArray[n2 * 2], fArray[n2 * 2 + 1]));
                ++n2;
            }
            while (n3 > fArray.length / 2) {
                this.removeItemImpl(--n3);
            }
        }

        @Override
        protected void resetAttribute() {
        }

        @Override
        protected void resetAttribute(SVGItem sVGItem) {
        }

        @Override
        protected void revalidate() {
            this.valid = true;
        }
    }

    protected class BaseSVGPointList
    extends AbstractSVGPointList {
        protected boolean missing;
        protected boolean malformed;

        protected BaseSVGPointList() {
        }

        @Override
        protected DOMException createDOMException(short s2, String string, Object[] objectArray) {
            return SVGOMAnimatedPoints.this.element.createDOMException(s2, string, objectArray);
        }

        @Override
        protected SVGException createSVGException(short s2, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPoints.this.element).createSVGException(s2, string, objectArray);
        }

        @Override
        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedPoints.this.element.getAttributeNodeNS(SVGOMAnimatedPoints.this.namespaceURI, SVGOMAnimatedPoints.this.localName);
            if (attr == null) {
                return SVGOMAnimatedPoints.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedPoints.this.changing = true;
                SVGOMAnimatedPoints.this.element.setAttributeNS(SVGOMAnimatedPoints.this.namespaceURI, SVGOMAnimatedPoints.this.localName, string);
            }
            finally {
                SVGOMAnimatedPoints.this.changing = false;
            }
        }

        @Override
        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        @Override
        protected void resetAttribute(SVGItem sVGItem) {
            super.resetAttribute(sVGItem);
            this.missing = false;
            this.malformed = false;
        }

        @Override
        protected void revalidate() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String string = this.getValueAsString();
            if (string == null) {
                this.missing = true;
                return;
            }
            try {
                ListBuilder listBuilder = new ListBuilder(this);
                this.doParse(string, listBuilder);
                if (listBuilder.getList() != null) {
                    this.clear(this.itemList);
                }
                this.itemList = listBuilder.getList();
            }
            catch (ParseException parseException) {
                this.itemList = new ArrayList(1);
                this.malformed = true;
            }
        }
    }
}

