/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.anim.dom.AbstractElement;
import org.apache.batik.anim.dom.AbstractSVGAnimatedValue;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.values.AnimatablePathDataValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.svg.AbstractSVGNormPathSegList;
import org.apache.batik.dom.svg.AbstractSVGPathSegList;
import org.apache.batik.dom.svg.ListBuilder;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGAnimatedPathDataSupport;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGPathSegItem;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathArrayProducer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedPathData;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegList;

public class SVGOMAnimatedPathData
extends AbstractSVGAnimatedValue
implements SVGAnimatedPathData {
    protected boolean changing;
    protected BaseSVGPathSegList pathSegs;
    protected NormalizedBaseSVGPathSegList normalizedPathSegs;
    protected AnimSVGPathSegList animPathSegs;
    protected String defaultValue;

    public SVGOMAnimatedPathData(AbstractElement abstractElement, String string, String string2, String string3) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
    }

    @Override
    public SVGPathSegList getAnimatedNormalizedPathSegList() {
        throw new UnsupportedOperationException("SVGAnimatedPathData.getAnimatedNormalizedPathSegList is not implemented");
    }

    @Override
    public SVGPathSegList getAnimatedPathSegList() {
        if (this.animPathSegs == null) {
            this.animPathSegs = new AnimSVGPathSegList();
        }
        return this.animPathSegs;
    }

    @Override
    public SVGPathSegList getNormalizedPathSegList() {
        if (this.normalizedPathSegs == null) {
            this.normalizedPathSegs = new NormalizedBaseSVGPathSegList();
        }
        return this.normalizedPathSegs;
    }

    @Override
    public SVGPathSegList getPathSegList() {
        if (this.pathSegs == null) {
            this.pathSegs = new BaseSVGPathSegList();
        }
        return this.pathSegs;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.pathSegs == null) {
                this.pathSegs = new BaseSVGPathSegList();
            }
            this.pathSegs.revalidate();
            if (this.pathSegs.missing) {
                throw new LiveAttributeException(this.element, this.localName, 0, null);
            }
            if (this.pathSegs.malformed) {
                throw new LiveAttributeException(this.element, this.localName, 1, this.pathSegs.getValueAsString());
            }
        }
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGPathSegList sVGPathSegList = this.getPathSegList();
        PathArrayProducer pathArrayProducer = new PathArrayProducer();
        SVGAnimatedPathDataSupport.handlePathSegList(sVGPathSegList, pathArrayProducer);
        return new AnimatablePathDataValue(animationTarget, pathArrayProducer.getPathCommands(), pathArrayProducer.getPathParameters());
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatablePathDataValue animatablePathDataValue = (AnimatablePathDataValue)animatableValue;
            if (this.animPathSegs == null) {
                this.animPathSegs = new AnimSVGPathSegList();
            }
            this.animPathSegs.setAnimatedValue(animatablePathDataValue.getCommands(), animatablePathDataValue.getParameters());
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public void attrAdded(Attr attr, String string) {
        if (!this.changing) {
            if (this.pathSegs != null) {
                this.pathSegs.invalidate();
            }
            if (this.normalizedPathSegs != null) {
                this.normalizedPathSegs.invalidate();
            }
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing) {
            if (this.pathSegs != null) {
                this.pathSegs.invalidate();
            }
            if (this.normalizedPathSegs != null) {
                this.normalizedPathSegs.invalidate();
            }
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrRemoved(Attr attr, String string) {
        if (!this.changing) {
            if (this.pathSegs != null) {
                this.pathSegs.invalidate();
            }
            if (this.normalizedPathSegs != null) {
                this.normalizedPathSegs.invalidate();
            }
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public class AnimSVGPathSegList
    extends AbstractSVGPathSegList {
        private int[] parameterIndex = new int[1];

        public AnimSVGPathSegList() {
            this.itemList = new ArrayList(1);
        }

        @Override
        protected DOMException createDOMException(short s2, String string, Object[] objectArray) {
            return SVGOMAnimatedPathData.this.element.createDOMException(s2, string, objectArray);
        }

        @Override
        protected SVGException createSVGException(short s2, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPathData.this.element).createSVGException(s2, string, objectArray);
        }

        @Override
        public int getNumberOfItems() {
            if (SVGOMAnimatedPathData.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedPathData.this.getPathSegList().getNumberOfItems();
        }

        @Override
        public SVGPathSeg getItem(int n2) {
            if (SVGOMAnimatedPathData.this.hasAnimVal) {
                return super.getItem(n2);
            }
            return SVGOMAnimatedPathData.this.getPathSegList().getItem(n2);
        }

        @Override
        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(this.getItemSeparator());
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuffer.toString();
        }

        @Override
        protected void setAttributeValue(String string) {
        }

        @Override
        public void clear() {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        @Override
        public SVGPathSeg initialize(SVGPathSeg sVGPathSeg) {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        @Override
        public SVGPathSeg insertItemBefore(SVGPathSeg sVGPathSeg, int n2) {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        @Override
        public SVGPathSeg replaceItem(SVGPathSeg sVGPathSeg, int n2) {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        @Override
        public SVGPathSeg removeItem(int n2) {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        @Override
        public SVGPathSeg appendItem(SVGPathSeg sVGPathSeg) {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        protected SVGPathSegItem newItem(short s2, float[] fArray, int[] nArray) {
            switch (s2) {
                case 10: 
                case 11: {
                    int n2 = nArray[0];
                    nArray[0] = n2 + 1;
                    int n3 = nArray[0];
                    nArray[0] = n3 + 1;
                    int n4 = nArray[0];
                    nArray[0] = n4 + 1;
                    int n5 = nArray[0];
                    nArray[0] = n5 + 1;
                    int n6 = nArray[0];
                    nArray[0] = n6 + 1;
                    int n7 = nArray[0];
                    nArray[0] = n7 + 1;
                    int n8 = nArray[0];
                    nArray[0] = n8 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegArcItem(s2, PATHSEG_LETTERS[s2], fArray[n2], fArray[n3], fArray[n4], fArray[n5] != 0.0f, fArray[n6] != 0.0f, fArray[n7], fArray[n8]);
                }
                case 1: {
                    return new SVGPathSegItem(s2, PATHSEG_LETTERS[s2]);
                }
                case 6: 
                case 7: {
                    int n9 = nArray[0];
                    nArray[0] = n9 + 1;
                    int n10 = nArray[0];
                    nArray[0] = n10 + 1;
                    int n11 = nArray[0];
                    nArray[0] = n11 + 1;
                    int n12 = nArray[0];
                    nArray[0] = n12 + 1;
                    int n13 = nArray[0];
                    nArray[0] = n13 + 1;
                    int n14 = nArray[0];
                    nArray[0] = n14 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem(s2, PATHSEG_LETTERS[s2], fArray[n9], fArray[n10], fArray[n11], fArray[n12], fArray[n13], fArray[n14]);
                }
                case 16: 
                case 17: {
                    int n15 = nArray[0];
                    nArray[0] = n15 + 1;
                    int n16 = nArray[0];
                    nArray[0] = n16 + 1;
                    int n17 = nArray[0];
                    nArray[0] = n17 + 1;
                    int n18 = nArray[0];
                    nArray[0] = n18 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegCurvetoCubicSmoothItem(s2, PATHSEG_LETTERS[s2], fArray[n15], fArray[n16], fArray[n17], fArray[n18]);
                }
                case 8: 
                case 9: {
                    int n19 = nArray[0];
                    nArray[0] = n19 + 1;
                    int n20 = nArray[0];
                    nArray[0] = n20 + 1;
                    int n21 = nArray[0];
                    nArray[0] = n21 + 1;
                    int n22 = nArray[0];
                    nArray[0] = n22 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem(s2, PATHSEG_LETTERS[s2], fArray[n19], fArray[n20], fArray[n21], fArray[n22]);
                }
                case 18: 
                case 19: {
                    int n23 = nArray[0];
                    nArray[0] = n23 + 1;
                    int n24 = nArray[0];
                    nArray[0] = n24 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticSmoothItem(s2, PATHSEG_LETTERS[s2], fArray[n23], fArray[n24]);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int n25 = nArray[0];
                    nArray[0] = n25 + 1;
                    int n26 = nArray[0];
                    nArray[0] = n26 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem(s2, PATHSEG_LETTERS[s2], fArray[n25], fArray[n26]);
                }
                case 12: 
                case 13: {
                    int n27 = nArray[0];
                    nArray[0] = n27 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegLinetoHorizontalItem(s2, PATHSEG_LETTERS[s2], fArray[n27]);
                }
                case 14: 
                case 15: {
                    int n28 = nArray[0];
                    nArray[0] = n28 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegLinetoVerticalItem(s2, PATHSEG_LETTERS[s2], fArray[n28]);
                }
            }
            return null;
        }

        protected void setAnimatedValue(short[] sArray, float[] fArray) {
            int n2;
            int n3 = this.itemList.size();
            int[] nArray = this.parameterIndex;
            nArray[0] = 0;
            block11: for (n2 = 0; n2 < n3 && n2 < sArray.length; ++n2) {
                SVGPathSeg sVGPathSeg = (SVGPathSeg)this.itemList.get(n2);
                if (sVGPathSeg.getPathSegType() != sArray[n2]) {
                    sVGPathSeg = this.newItem(sArray[n2], fArray, nArray);
                    continue;
                }
                switch (sArray[n2]) {
                    case 10: 
                    case 11: {
                        SVGPathSegItem sVGPathSegItem = (AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSeg;
                        int n4 = nArray[0];
                        nArray[0] = n4 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSegItem).setR1(fArray[n4]);
                        int n5 = nArray[0];
                        nArray[0] = n5 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSegItem).setR2(fArray[n5]);
                        int n6 = nArray[0];
                        nArray[0] = n6 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSegItem).setAngle(fArray[n6]);
                        int n7 = nArray[0];
                        nArray[0] = n7 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSegItem).setLargeArcFlag(fArray[n7] != 0.0f);
                        int n8 = nArray[0];
                        nArray[0] = n8 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSegItem).setSweepFlag(fArray[n8] != 0.0f);
                        int n9 = nArray[0];
                        nArray[0] = n9 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSegItem).setX(fArray[n9]);
                        int n10 = nArray[0];
                        nArray[0] = n10 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSegItem).setY(fArray[n10]);
                        continue block11;
                    }
                    case 1: {
                        continue block11;
                    }
                    case 6: 
                    case 7: {
                        SVGPathSegItem sVGPathSegItem = (AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSeg;
                        int n11 = nArray[0];
                        nArray[0] = n11 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSegItem).setX1(fArray[n11]);
                        int n12 = nArray[0];
                        nArray[0] = n12 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSegItem).setY1(fArray[n12]);
                        int n13 = nArray[0];
                        nArray[0] = n13 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSegItem).setX2(fArray[n13]);
                        int n14 = nArray[0];
                        nArray[0] = n14 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSegItem).setY2(fArray[n14]);
                        int n15 = nArray[0];
                        nArray[0] = n15 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSegItem).setX(fArray[n15]);
                        int n16 = nArray[0];
                        nArray[0] = n16 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSegItem).setY(fArray[n16]);
                        continue block11;
                    }
                    case 16: 
                    case 17: {
                        SVGPathSegItem sVGPathSegItem = (AbstractSVGPathSegList.SVGPathSegCurvetoCubicSmoothItem)sVGPathSeg;
                        int n17 = nArray[0];
                        nArray[0] = n17 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicSmoothItem)sVGPathSegItem).setX2(fArray[n17]);
                        int n18 = nArray[0];
                        nArray[0] = n18 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicSmoothItem)sVGPathSegItem).setY2(fArray[n18]);
                        int n19 = nArray[0];
                        nArray[0] = n19 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicSmoothItem)sVGPathSegItem).setX(fArray[n19]);
                        int n20 = nArray[0];
                        nArray[0] = n20 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoCubicSmoothItem)sVGPathSegItem).setY(fArray[n20]);
                        continue block11;
                    }
                    case 8: 
                    case 9: {
                        SVGPathSegItem sVGPathSegItem = (AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem)sVGPathSeg;
                        int n21 = nArray[0];
                        nArray[0] = n21 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem)sVGPathSegItem).setX1(fArray[n21]);
                        int n22 = nArray[0];
                        nArray[0] = n22 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem)sVGPathSegItem).setY1(fArray[n22]);
                        int n23 = nArray[0];
                        nArray[0] = n23 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem)sVGPathSegItem).setX(fArray[n23]);
                        int n24 = nArray[0];
                        nArray[0] = n24 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem)sVGPathSegItem).setY(fArray[n24]);
                        continue block11;
                    }
                    case 18: 
                    case 19: {
                        SVGPathSegItem sVGPathSegItem = (AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticSmoothItem)sVGPathSeg;
                        int n25 = nArray[0];
                        nArray[0] = n25 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticSmoothItem)sVGPathSegItem).setX(fArray[n25]);
                        int n26 = nArray[0];
                        nArray[0] = n26 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticSmoothItem)sVGPathSegItem).setY(fArray[n26]);
                        continue block11;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        SVGPathSegItem sVGPathSegItem = (AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem)sVGPathSeg;
                        int n27 = nArray[0];
                        nArray[0] = n27 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem)sVGPathSegItem).setX(fArray[n27]);
                        int n28 = nArray[0];
                        nArray[0] = n28 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem)sVGPathSegItem).setY(fArray[n28]);
                        continue block11;
                    }
                    case 12: 
                    case 13: {
                        SVGPathSegItem sVGPathSegItem = (AbstractSVGPathSegList.SVGPathSegLinetoHorizontalItem)sVGPathSeg;
                        int n29 = nArray[0];
                        nArray[0] = n29 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegLinetoHorizontalItem)sVGPathSegItem).setX(fArray[n29]);
                        continue block11;
                    }
                    case 14: 
                    case 15: {
                        SVGPathSegItem sVGPathSegItem = (AbstractSVGPathSegList.SVGPathSegLinetoVerticalItem)sVGPathSeg;
                        int n30 = nArray[0];
                        nArray[0] = n30 + 1;
                        ((AbstractSVGPathSegList.SVGPathSegLinetoVerticalItem)sVGPathSegItem).setY(fArray[n30]);
                        continue block11;
                    }
                }
            }
            while (n2 < sArray.length) {
                this.appendItemImpl(this.newItem(sArray[n2], fArray, nArray));
                ++n2;
            }
            while (n3 > sArray.length) {
                this.removeItemImpl(--n3);
            }
        }

        @Override
        protected void resetAttribute() {
        }

        @Override
        protected void resetAttribute(SVGItem sVGItem) {
        }

        @Override
        protected void revalidate() {
            this.valid = true;
        }
    }

    public class NormalizedBaseSVGPathSegList
    extends AbstractSVGNormPathSegList {
        protected boolean missing;
        protected boolean malformed;

        @Override
        protected DOMException createDOMException(short s2, String string, Object[] objectArray) {
            return SVGOMAnimatedPathData.this.element.createDOMException(s2, string, objectArray);
        }

        @Override
        protected SVGException createSVGException(short s2, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPathData.this.element).createSVGException(s2, string, objectArray);
        }

        @Override
        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedPathData.this.element.getAttributeNodeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName);
            if (attr == null) {
                return SVGOMAnimatedPathData.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedPathData.this.changing = true;
                SVGOMAnimatedPathData.this.element.setAttributeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName, string);
            }
            finally {
                SVGOMAnimatedPathData.this.changing = false;
            }
        }

        @Override
        protected void revalidate() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String string = this.getValueAsString();
            if (string == null) {
                this.missing = true;
                return;
            }
            try {
                ListBuilder listBuilder = new ListBuilder(this);
                this.doParse(string, listBuilder);
                if (listBuilder.getList() != null) {
                    this.clear(this.itemList);
                }
                this.itemList = listBuilder.getList();
            }
            catch (ParseException parseException) {
                this.itemList = new ArrayList(1);
                this.malformed = true;
            }
        }
    }

    public class BaseSVGPathSegList
    extends AbstractSVGPathSegList {
        protected boolean missing;
        protected boolean malformed;

        @Override
        protected DOMException createDOMException(short s2, String string, Object[] objectArray) {
            return SVGOMAnimatedPathData.this.element.createDOMException(s2, string, objectArray);
        }

        @Override
        protected SVGException createSVGException(short s2, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPathData.this.element).createSVGException(s2, string, objectArray);
        }

        @Override
        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedPathData.this.element.getAttributeNodeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName);
            if (attr == null) {
                return SVGOMAnimatedPathData.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedPathData.this.changing = true;
                SVGOMAnimatedPathData.this.element.setAttributeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName, string);
            }
            finally {
                SVGOMAnimatedPathData.this.changing = false;
            }
        }

        @Override
        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        @Override
        protected void resetAttribute(SVGItem sVGItem) {
            super.resetAttribute(sVGItem);
            this.missing = false;
            this.malformed = false;
        }

        @Override
        protected void revalidate() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String string = this.getValueAsString();
            if (string == null) {
                this.missing = true;
                return;
            }
            try {
                ListBuilder listBuilder = new ListBuilder(this);
                this.doParse(string, listBuilder);
                if (listBuilder.getList() != null) {
                    this.clear(this.itemList);
                }
                this.itemList = listBuilder.getList();
            }
            catch (ParseException parseException) {
                this.itemList = new ArrayList(1);
                this.malformed = true;
            }
        }
    }
}

