/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.anim.dom.AbstractElement;
import org.apache.batik.anim.dom.AbstractSVGAnimatedValue;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.values.AnimatableNumberListValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.svg.AbstractSVGNumberList;
import org.apache.batik.dom.svg.ListBuilder;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGNumberItem;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedNumberList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public class SVGOMAnimatedNumberList
extends AbstractSVGAnimatedValue
implements SVGAnimatedNumberList {
    protected BaseSVGNumberList baseVal;
    protected AnimSVGNumberList animVal;
    protected boolean changing;
    protected String defaultValue;
    protected boolean emptyAllowed;

    public SVGOMAnimatedNumberList(AbstractElement abstractElement, String string, String string2, String string3, boolean bl2) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
        this.emptyAllowed = bl2;
    }

    @Override
    public SVGNumberList getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGNumberList();
        }
        return this.baseVal;
    }

    @Override
    public SVGNumberList getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGNumberList();
        }
        return this.animVal;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.baseVal == null) {
                this.baseVal = new BaseSVGNumberList();
            }
            this.baseVal.revalidate();
            if (this.baseVal.missing) {
                throw new LiveAttributeException(this.element, this.localName, 0, null);
            }
            if (this.baseVal.malformed) {
                throw new LiveAttributeException(this.element, this.localName, 1, this.baseVal.getValueAsString());
            }
        }
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGNumberList sVGNumberList = this.getBaseVal();
        int n2 = sVGNumberList.getNumberOfItems();
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = sVGNumberList.getItem(n2).getValue();
        }
        return new AnimatableNumberListValue(animationTarget, fArray);
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableNumberListValue animatableNumberListValue = (AnimatableNumberListValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGNumberList();
            }
            this.animVal.setAnimatedValue(animatableNumberListValue.getNumbers());
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGNumberList
    extends AbstractSVGNumberList {
        public AnimSVGNumberList() {
            this.itemList = new ArrayList(1);
        }

        @Override
        protected DOMException createDOMException(short s2, String string, Object[] objectArray) {
            return SVGOMAnimatedNumberList.this.element.createDOMException(s2, string, objectArray);
        }

        @Override
        protected SVGException createSVGException(short s2, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedNumberList.this.element).createSVGException(s2, string, objectArray);
        }

        @Override
        protected Element getElement() {
            return SVGOMAnimatedNumberList.this.element;
        }

        @Override
        public int getNumberOfItems() {
            if (SVGOMAnimatedNumberList.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedNumberList.this.getBaseVal().getNumberOfItems();
        }

        @Override
        public SVGNumber getItem(int n2) {
            if (SVGOMAnimatedNumberList.this.hasAnimVal) {
                return super.getItem(n2);
            }
            return SVGOMAnimatedNumberList.this.getBaseVal().getItem(n2);
        }

        @Override
        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(this.getItemSeparator());
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuffer.toString();
        }

        @Override
        protected void setAttributeValue(String string) {
        }

        @Override
        public void clear() {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        @Override
        public SVGNumber initialize(SVGNumber sVGNumber) {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        @Override
        public SVGNumber insertItemBefore(SVGNumber sVGNumber, int n2) {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        @Override
        public SVGNumber replaceItem(SVGNumber sVGNumber, int n2) {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        @Override
        public SVGNumber removeItem(int n2) {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        @Override
        public SVGNumber appendItem(SVGNumber sVGNumber) {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        protected void setAnimatedValue(float[] fArray) {
            int n2;
            int n3 = this.itemList.size();
            for (n2 = 0; n2 < n3 && n2 < fArray.length; ++n2) {
                SVGNumberItem sVGNumberItem = (SVGNumberItem)this.itemList.get(n2);
                sVGNumberItem.setValue(fArray[n2]);
            }
            while (n2 < fArray.length) {
                this.appendItemImpl(new SVGNumberItem(fArray[n2]));
                ++n2;
            }
            while (n3 > fArray.length) {
                this.removeItemImpl(--n3);
            }
        }

        @Override
        protected void resetAttribute() {
        }

        @Override
        protected void resetAttribute(SVGItem sVGItem) {
        }

        @Override
        protected void revalidate() {
            this.valid = true;
        }
    }

    public class BaseSVGNumberList
    extends AbstractSVGNumberList {
        protected boolean missing;
        protected boolean malformed;

        @Override
        protected DOMException createDOMException(short s2, String string, Object[] objectArray) {
            return SVGOMAnimatedNumberList.this.element.createDOMException(s2, string, objectArray);
        }

        @Override
        protected SVGException createSVGException(short s2, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedNumberList.this.element).createSVGException(s2, string, objectArray);
        }

        @Override
        protected Element getElement() {
            return SVGOMAnimatedNumberList.this.element;
        }

        @Override
        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedNumberList.this.element.getAttributeNodeNS(SVGOMAnimatedNumberList.this.namespaceURI, SVGOMAnimatedNumberList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedNumberList.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedNumberList.this.changing = true;
                SVGOMAnimatedNumberList.this.element.setAttributeNS(SVGOMAnimatedNumberList.this.namespaceURI, SVGOMAnimatedNumberList.this.localName, string);
            }
            finally {
                SVGOMAnimatedNumberList.this.changing = false;
            }
        }

        @Override
        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        @Override
        protected void resetAttribute(SVGItem sVGItem) {
            super.resetAttribute(sVGItem);
            this.missing = false;
            this.malformed = false;
        }

        @Override
        protected void revalidate() {
            boolean bl2;
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String string = this.getValueAsString();
            boolean bl3 = bl2 = string != null && string.length() == 0;
            if (string == null || bl2 && !SVGOMAnimatedNumberList.this.emptyAllowed) {
                this.missing = true;
                return;
            }
            if (bl2) {
                this.itemList = new ArrayList(1);
            } else {
                try {
                    ListBuilder listBuilder = new ListBuilder(this);
                    this.doParse(string, listBuilder);
                    if (listBuilder.getList() != null) {
                        this.clear(this.itemList);
                    }
                    this.itemList = listBuilder.getList();
                }
                catch (ParseException parseException) {
                    this.itemList = new ArrayList(1);
                    this.valid = true;
                    this.malformed = true;
                }
            }
        }
    }
}

