/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import org.apache.batik.anim.dom.AbstractElement;
import org.apache.batik.anim.dom.AbstractSVGAnimatedValue;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableStringValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.w3c.dom.Attr;
import org.w3c.dom.svg.SVGAnimatedEnumeration;

public class SVGOMAnimatedEnumeration
extends AbstractSVGAnimatedValue
implements SVGAnimatedEnumeration {
    protected String[] values;
    protected short defaultValue;
    protected boolean valid;
    protected short baseVal;
    protected short animVal;
    protected boolean changing;

    public SVGOMAnimatedEnumeration(AbstractElement abstractElement, String string, String string2, String[] stringArray, short s2) {
        super(abstractElement, string, string2);
        this.values = stringArray;
        this.defaultValue = s2;
    }

    @Override
    public short getBaseVal() {
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public String getBaseValAsString() {
        if (!this.valid) {
            this.update();
        }
        return this.values[this.baseVal];
    }

    protected void update() {
        String string = this.element.getAttributeNS(this.namespaceURI, this.localName);
        this.baseVal = string.length() == 0 ? this.defaultValue : this.getEnumerationNumber(string);
        this.valid = true;
    }

    protected short getEnumerationNumber(String string) {
        for (short s2 = 0; s2 < this.values.length; s2 = (short)(s2 + 1)) {
            if (!string.equals(this.values[s2])) continue;
            return s2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBaseVal(short s2) {
        if (s2 >= 0 && s2 < this.values.length) {
            try {
                this.baseVal = s2;
                this.valid = true;
                this.changing = true;
                this.element.setAttributeNS(this.namespaceURI, this.localName, this.values[s2]);
            }
            finally {
                this.changing = false;
            }
        }
    }

    @Override
    public short getAnimVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public short getCheckedVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        if (this.baseVal == 0) {
            throw new LiveAttributeException(this.element, this.localName, 1, this.getBaseValAsString());
        }
        return this.baseVal;
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        return new AnimatableStringValue(animationTarget, this.getBaseValAsString());
    }

    @Override
    public void attrAdded(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            this.animVal = this.getEnumerationNumber(((AnimatableStringValue)animatableValue).getString());
            this.fireAnimatedAttributeListeners();
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrRemoved(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }
}

