/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.net.URL;
import java.util.HashMap;
import org.apache.batik.anim.dom.BindableElement;
import org.apache.batik.anim.dom.SVG12OMDocument;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMFlowDivElement;
import org.apache.batik.anim.dom.SVGOMFlowLineElement;
import org.apache.batik.anim.dom.SVGOMFlowParaElement;
import org.apache.batik.anim.dom.SVGOMFlowRegionBreakElement;
import org.apache.batik.anim.dom.SVGOMFlowRegionElement;
import org.apache.batik.anim.dom.SVGOMFlowRegionExcludeElement;
import org.apache.batik.anim.dom.SVGOMFlowRootElement;
import org.apache.batik.anim.dom.SVGOMFlowSpanElement;
import org.apache.batik.anim.dom.SVGOMHandlerElement;
import org.apache.batik.anim.dom.SVGOMMultiImageElement;
import org.apache.batik.anim.dom.SVGOMSolidColorElement;
import org.apache.batik.anim.dom.SVGOMSubImageElement;
import org.apache.batik.anim.dom.SVGOMSubImageRefElement;
import org.apache.batik.anim.dom.XBLEventSupport;
import org.apache.batik.anim.dom.XBLOMContentElement;
import org.apache.batik.anim.dom.XBLOMDefinitionElement;
import org.apache.batik.anim.dom.XBLOMHandlerGroupElement;
import org.apache.batik.anim.dom.XBLOMImportElement;
import org.apache.batik.anim.dom.XBLOMShadowTreeElement;
import org.apache.batik.anim.dom.XBLOMTemplateElement;
import org.apache.batik.anim.dom.XBLOMXBLElement;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.SVG12CSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.ExtensibleDOMImplementation;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.svg12.SVGOMWheelEvent;
import org.apache.batik.dom.svg12.XBLOMShadowTreeEvent;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;

public class SVG12DOMImplementation
extends SVGDOMImplementation {
    protected static HashMap<String, ExtensibleDOMImplementation.ElementFactory> svg12Factories = new HashMap(svg11Factories);
    protected static HashMap<String, ExtensibleDOMImplementation.ElementFactory> xblFactories;
    protected static final DOMImplementation DOM_IMPLEMENTATION;

    public SVG12DOMImplementation() {
        this.factories = svg12Factories;
        this.registerFeature("CSS", "2.0");
        this.registerFeature("StyleSheets", "2.0");
        this.registerFeature("SVG", new String[]{"1.0", "1.1", "1.2"});
        this.registerFeature("SVGEvents", new String[]{"1.0", "1.1", "1.2"});
    }

    @Override
    public CSSEngine createCSSEngine(AbstractStylableDocument abstractStylableDocument, CSSContext cSSContext, ExtendedParser extendedParser, ValueManager[] valueManagerArray, ShorthandManager[] shorthandManagerArray) {
        ParsedURL parsedURL = ((SVGOMDocument)abstractStylableDocument).getParsedURL();
        SVG12CSSEngine sVG12CSSEngine = new SVG12CSSEngine(abstractStylableDocument, parsedURL, extendedParser, valueManagerArray, shorthandManagerArray, cSSContext);
        URL uRL = this.getClass().getResource("resources/UserAgentStyleSheet.css");
        if (uRL != null) {
            ParsedURL parsedURL2 = new ParsedURL(uRL);
            InputSource inputSource = new InputSource(parsedURL2.toString());
            sVG12CSSEngine.setUserAgentStyleSheet(sVG12CSSEngine.parseStyleSheet(inputSource, parsedURL2, "all"));
        }
        return sVG12CSSEngine;
    }

    @Override
    public Document createDocument(String string, String string2, DocumentType documentType) {
        SVG12OMDocument sVG12OMDocument = new SVG12OMDocument(documentType, this);
        sVG12OMDocument.setIsSVG12(true);
        if (string2 != null) {
            sVG12OMDocument.appendChild(sVG12OMDocument.createElementNS(string, string2));
        }
        return sVG12OMDocument;
    }

    @Override
    public Element createElementNS(AbstractDocument abstractDocument, String string, String string2) {
        ExtensibleDOMImplementation.ElementFactory elementFactory;
        if (string == null) {
            return new GenericElement(string2.intern(), abstractDocument);
        }
        String string3 = DOMUtilities.getLocalName(string2);
        String string4 = DOMUtilities.getPrefix(string2);
        if ("http://www.w3.org/2000/svg".equals(string) ? (elementFactory = (ExtensibleDOMImplementation.ElementFactory)this.factories.get(string3)) != null : "http://www.w3.org/2004/xbl".equals(string) && (elementFactory = xblFactories.get(string3)) != null) {
            return elementFactory.create(string4, abstractDocument);
        }
        if (this.customFactories != null && (elementFactory = (ExtensibleDOMImplementation.ElementFactory)this.customFactories.get(string, string3)) != null) {
            return elementFactory.create(string4, abstractDocument);
        }
        return new BindableElement(string4, abstractDocument, string, string3);
    }

    @Override
    public DocumentEventSupport createDocumentEventSupport() {
        DocumentEventSupport documentEventSupport = super.createDocumentEventSupport();
        documentEventSupport.registerEventFactory("WheelEvent", new DocumentEventSupport.EventFactory(){

            @Override
            public Event createEvent() {
                return new SVGOMWheelEvent();
            }
        });
        documentEventSupport.registerEventFactory("ShadowTreeEvent", new DocumentEventSupport.EventFactory(){

            @Override
            public Event createEvent() {
                return new XBLOMShadowTreeEvent();
            }
        });
        return documentEventSupport;
    }

    @Override
    public EventSupport createEventSupport(AbstractNode abstractNode) {
        return new XBLEventSupport(abstractNode);
    }

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    static {
        svg12Factories.put("flowDiv", new FlowDivElementFactory());
        svg12Factories.put("flowLine", new FlowLineElementFactory());
        svg12Factories.put("flowPara", new FlowParaElementFactory());
        svg12Factories.put("flowRegionBreak", new FlowRegionBreakElementFactory());
        svg12Factories.put("flowRegion", new FlowRegionElementFactory());
        svg12Factories.put("flowRegionExclude", new FlowRegionExcludeElementFactory());
        svg12Factories.put("flowRoot", new FlowRootElementFactory());
        svg12Factories.put("flowSpan", new FlowSpanElementFactory());
        svg12Factories.put("handler", new HandlerElementFactory());
        svg12Factories.put("multiImage", new MultiImageElementFactory());
        svg12Factories.put("solidColor", new SolidColorElementFactory());
        svg12Factories.put("subImage", new SubImageElementFactory());
        svg12Factories.put("subImageRef", new SubImageRefElementFactory());
        xblFactories = new HashMap();
        xblFactories.put("xbl", new XBLXBLElementFactory());
        xblFactories.put("definition", new XBLDefinitionElementFactory());
        xblFactories.put("template", new XBLTemplateElementFactory());
        xblFactories.put("content", new XBLContentElementFactory());
        xblFactories.put("handlerGroup", new XBLHandlerGroupElementFactory());
        xblFactories.put("import", new XBLImportElementFactory());
        xblFactories.put("shadowTree", new XBLShadowTreeElementFactory());
        DOM_IMPLEMENTATION = new SVG12DOMImplementation();
    }

    protected static class XBLShadowTreeElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new XBLOMShadowTreeElement(string, (AbstractDocument)document);
        }
    }

    protected static class XBLImportElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new XBLOMImportElement(string, (AbstractDocument)document);
        }
    }

    protected static class XBLHandlerGroupElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new XBLOMHandlerGroupElement(string, (AbstractDocument)document);
        }
    }

    protected static class XBLContentElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new XBLOMContentElement(string, (AbstractDocument)document);
        }
    }

    protected static class XBLTemplateElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new XBLOMTemplateElement(string, (AbstractDocument)document);
        }
    }

    protected static class XBLDefinitionElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new XBLOMDefinitionElement(string, (AbstractDocument)document);
        }
    }

    protected static class XBLXBLElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new XBLOMXBLElement(string, (AbstractDocument)document);
        }
    }

    protected static class SubImageRefElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMSubImageRefElement(string, (AbstractDocument)document);
        }
    }

    protected static class SubImageElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMSubImageElement(string, (AbstractDocument)document);
        }
    }

    protected static class SolidColorElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMSolidColorElement(string, (AbstractDocument)document);
        }
    }

    protected static class MultiImageElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMMultiImageElement(string, (AbstractDocument)document);
        }
    }

    protected static class HandlerElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMHandlerElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowSpanElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMFlowSpanElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRootElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMFlowRootElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionExcludeElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMFlowRegionExcludeElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMFlowRegionElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionBreakElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMFlowRegionBreakElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowParaElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMFlowParaElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowLineElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMFlowLineElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowDivElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new SVGOMFlowDivElement(string, (AbstractDocument)document);
        }
    }
}

