/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import org.apache.batik.anim.dom.AbstractSVGLength;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.parser.LengthListHandler;
import org.apache.batik.parser.LengthListParser;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;

public abstract class AbstractSVGLengthList
extends AbstractSVGList
implements SVGLengthList {
    protected short direction;
    public static final String SVG_LENGTH_LIST_SEPARATOR = " ";

    @Override
    protected String getItemSeparator() {
        return SVG_LENGTH_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    protected abstract Element getElement();

    protected AbstractSVGLengthList(short s2) {
        this.direction = s2;
    }

    @Override
    public SVGLength initialize(SVGLength sVGLength) {
        return (SVGLength)((Object)this.initializeImpl(sVGLength));
    }

    @Override
    public SVGLength getItem(int n2) {
        return (SVGLength)((Object)this.getItemImpl(n2));
    }

    @Override
    public SVGLength insertItemBefore(SVGLength sVGLength, int n2) {
        return (SVGLength)((Object)this.insertItemBeforeImpl(sVGLength, n2));
    }

    @Override
    public SVGLength replaceItem(SVGLength sVGLength, int n2) {
        return (SVGLength)((Object)this.replaceItemImpl(sVGLength, n2));
    }

    @Override
    public SVGLength removeItem(int n2) {
        return (SVGLength)((Object)this.removeItemImpl(n2));
    }

    @Override
    public SVGLength appendItem(SVGLength sVGLength) {
        return (SVGLength)((Object)this.appendItemImpl(sVGLength));
    }

    @Override
    protected SVGItem createSVGItem(Object object) {
        SVGLength sVGLength = (SVGLength)object;
        return new SVGLengthItem(sVGLength.getUnitType(), sVGLength.getValueInSpecifiedUnits(), this.direction);
    }

    @Override
    protected void doParse(String string, ListHandler listHandler) {
        LengthListParser lengthListParser = new LengthListParser();
        LengthListBuilder lengthListBuilder = new LengthListBuilder(listHandler);
        lengthListParser.setLengthListHandler(lengthListBuilder);
        lengthListParser.parse(string);
    }

    @Override
    protected void checkItemType(Object object) {
        if (!(object instanceof SVGLength)) {
            this.createSVGException((short)0, "expected.length", null);
        }
    }

    protected class LengthListBuilder
    implements LengthListHandler {
        protected ListHandler listHandler;
        protected float currentValue;
        protected short currentType;

        public LengthListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startLengthList() {
            this.listHandler.startList();
        }

        @Override
        public void startLength() {
            this.currentType = 1;
            this.currentValue = 0.0f;
        }

        @Override
        public void lengthValue(float f2) {
            this.currentValue = f2;
        }

        @Override
        public void em() {
            this.currentType = (short)3;
        }

        @Override
        public void ex() {
            this.currentType = (short)4;
        }

        @Override
        public void in() {
            this.currentType = (short)8;
        }

        @Override
        public void cm() {
            this.currentType = (short)6;
        }

        @Override
        public void mm() {
            this.currentType = (short)7;
        }

        @Override
        public void pc() {
            this.currentType = (short)10;
        }

        @Override
        public void pt() {
            this.currentType = (short)3;
        }

        @Override
        public void px() {
            this.currentType = (short)5;
        }

        @Override
        public void percentage() {
            this.currentType = (short)2;
        }

        @Override
        public void endLength() {
            this.listHandler.item(new SVGLengthItem(this.currentType, this.currentValue, AbstractSVGLengthList.this.direction));
        }

        @Override
        public void endLengthList() {
            this.listHandler.endList();
        }
    }

    protected class SVGLengthItem
    extends AbstractSVGLength
    implements SVGItem {
        protected AbstractSVGList parentList;

        public SVGLengthItem(short s2, float f2, short s3) {
            super(s3);
            this.unitType = s2;
            this.value = f2;
        }

        @Override
        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGLengthList.this.getElement();
        }

        @Override
        public void setParent(AbstractSVGList abstractSVGList) {
            this.parentList = abstractSVGList;
        }

        @Override
        public AbstractSVGList getParent() {
            return this.parentList;
        }

        @Override
        protected void reset() {
            if (this.parentList != null) {
                this.parentList.itemChanged();
            }
        }
    }
}

