/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.util.LinkedList;
import org.apache.batik.anim.dom.AbstractElement;
import org.apache.batik.anim.dom.AnimatedAttributeListener;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.values.AnimatableValue;

public abstract class AbstractSVGAnimatedValue
implements AnimatedLiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean hasAnimVal;
    protected LinkedList listeners = new LinkedList();

    public AbstractSVGAnimatedValue(AbstractElement abstractElement, String string, String string2) {
        this.element = abstractElement;
        this.namespaceURI = string;
        this.localName = string2;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public boolean isSpecified() {
        return this.hasAnimVal || this.element.hasAttributeNS(this.namespaceURI, this.localName);
    }

    protected abstract void updateAnimatedValue(AnimatableValue var1);

    @Override
    public void addAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        if (!this.listeners.contains(animatedAttributeListener)) {
            this.listeners.add(animatedAttributeListener);
        }
    }

    @Override
    public void removeAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        this.listeners.remove(animatedAttributeListener);
    }

    protected void fireBaseAttributeListeners() {
        if (this.element instanceof SVGOMElement) {
            ((SVGOMElement)this.element).fireBaseAttributeListeners(this.namespaceURI, this.localName);
        }
    }

    protected void fireAnimatedAttributeListeners() {
        for (Object e2 : this.listeners) {
            AnimatedAttributeListener animatedAttributeListener = (AnimatedAttributeListener)e2;
            animatedAttributeListener.animatedAttributeChanged(this.element, this);
        }
    }
}

