/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import org.apache.batik.anim.dom.AbstractElement;
import org.apache.batik.anim.dom.AbstractSVGAnimatedValue;
import org.apache.batik.anim.dom.AbstractSVGLength;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.w3c.dom.Attr;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;

public abstract class AbstractSVGAnimatedLength
extends AbstractSVGAnimatedValue
implements LiveAttributeValue,
SVGAnimatedLength {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    protected short direction;
    protected BaseSVGLength baseVal;
    protected AnimSVGLength animVal;
    protected boolean changing;
    protected boolean nonNegative;

    public AbstractSVGAnimatedLength(AbstractElement abstractElement, String string, String string2, short s2, boolean bl2) {
        super(abstractElement, string, string2);
        this.direction = s2;
        this.nonNegative = bl2;
    }

    protected abstract String getDefaultValue();

    @Override
    public SVGLength getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGLength(this.direction);
        }
        return this.baseVal;
    }

    @Override
    public SVGLength getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGLength(this.direction);
        }
        return this.animVal;
    }

    public float getCheckedValue() {
        if (this.hasAnimVal) {
            if (this.animVal == null) {
                this.animVal = new AnimSVGLength(this.direction);
            }
            if (this.nonNegative && this.animVal.value < 0.0f) {
                throw new LiveAttributeException(this.element, this.localName, 2, this.animVal.getValueAsString());
            }
            return this.animVal.getValue();
        }
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGLength(this.direction);
        }
        this.baseVal.revalidate();
        if (this.baseVal.missing) {
            throw new LiveAttributeException(this.element, this.localName, 0, null);
        }
        if (this.baseVal.unitType == 0) {
            throw new LiveAttributeException(this.element, this.localName, 1, this.baseVal.getValueAsString());
        }
        if (this.nonNegative && this.baseVal.value < 0.0f) {
            throw new LiveAttributeException(this.element, this.localName, 2, this.baseVal.getValueAsString());
        }
        return this.baseVal.getValue();
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableLengthValue animatableLengthValue = (AnimatableLengthValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGLength(this.direction);
            }
            this.animVal.setAnimatedValue(animatableLengthValue.getLengthType(), animatableLengthValue.getLengthValue());
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGLength sVGLength = this.getBaseVal();
        return new AnimatableLengthValue(animationTarget, sVGLength.getUnitType(), sVGLength.getValueInSpecifiedUnits(), animationTarget.getPercentageInterpretation(this.getNamespaceURI(), this.getLocalName(), false));
    }

    @Override
    public void attrAdded(Attr attr, String string) {
        this.attrChanged();
    }

    @Override
    public void attrModified(Attr attr, String string, String string2) {
        this.attrChanged();
    }

    @Override
    public void attrRemoved(Attr attr, String string) {
        this.attrChanged();
    }

    protected void attrChanged() {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGLength
    extends AbstractSVGLength {
        public AnimSVGLength(short s2) {
            super(s2);
        }

        @Override
        public short getUnitType() {
            if (AbstractSVGAnimatedLength.this.hasAnimVal) {
                return super.getUnitType();
            }
            return AbstractSVGAnimatedLength.this.getBaseVal().getUnitType();
        }

        @Override
        public float getValue() {
            if (AbstractSVGAnimatedLength.this.hasAnimVal) {
                return super.getValue();
            }
            return AbstractSVGAnimatedLength.this.getBaseVal().getValue();
        }

        @Override
        public float getValueInSpecifiedUnits() {
            if (AbstractSVGAnimatedLength.this.hasAnimVal) {
                return super.getValueInSpecifiedUnits();
            }
            return AbstractSVGAnimatedLength.this.getBaseVal().getValueInSpecifiedUnits();
        }

        @Override
        public String getValueAsString() {
            if (AbstractSVGAnimatedLength.this.hasAnimVal) {
                return super.getValueAsString();
            }
            return AbstractSVGAnimatedLength.this.getBaseVal().getValueAsString();
        }

        @Override
        public void setValue(float f2) {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        @Override
        public void setValueInSpecifiedUnits(float f2) {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        @Override
        public void setValueAsString(String string) {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        @Override
        public void newValueSpecifiedUnits(short s2, float f2) {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        @Override
        public void convertToSpecifiedUnits(short s2) {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        @Override
        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGAnimatedLength.this.element;
        }

        protected void setAnimatedValue(int n2, float f2) {
            super.newValueSpecifiedUnits((short)n2, f2);
        }
    }

    protected class BaseSVGLength
    extends AbstractSVGLength {
        protected boolean valid;
        protected boolean missing;

        public BaseSVGLength(short s2) {
            super(s2);
        }

        public void invalidate() {
            this.valid = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void reset() {
            try {
                AbstractSVGAnimatedLength.this.changing = true;
                this.valid = true;
                String string = this.getValueAsString();
                AbstractSVGAnimatedLength.this.element.setAttributeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName, string);
            }
            finally {
                AbstractSVGAnimatedLength.this.changing = false;
            }
        }

        @Override
        protected void revalidate() {
            String string;
            if (this.valid) {
                return;
            }
            this.missing = false;
            this.valid = true;
            Attr attr = AbstractSVGAnimatedLength.this.element.getAttributeNodeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName);
            if (attr == null) {
                string = AbstractSVGAnimatedLength.this.getDefaultValue();
                if (string == null) {
                    this.missing = true;
                    return;
                }
            } else {
                string = attr.getValue();
            }
            this.parse(string);
        }

        @Override
        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGAnimatedLength.this.element;
        }
    }
}

