/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim;

import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.dom.AnimatableElement;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.ext.awt.geom.Cubic;

public abstract class InterpolatingAnimation
extends AbstractAnimation {
    protected int calcMode;
    protected float[] keyTimes;
    protected float[] keySplines;
    protected Cubic[] keySplineCubics;
    protected boolean additive;
    protected boolean cumulative;

    public InterpolatingAnimation(TimedElement timedElement, AnimatableElement animatableElement, int n2, float[] fArray, float[] fArray2, boolean bl2, boolean bl3) {
        super(timedElement, animatableElement);
        int n3;
        this.calcMode = n2;
        this.keyTimes = fArray;
        this.keySplines = fArray2;
        this.additive = bl2;
        this.cumulative = bl3;
        if (n2 == 3) {
            if (fArray2 == null || fArray2.length % 4 != 0) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keySplines"});
            }
            this.keySplineCubics = new Cubic[fArray2.length / 4];
            for (n3 = 0; n3 < fArray2.length / 4; ++n3) {
                this.keySplineCubics[n3] = new Cubic(0.0, 0.0, fArray2[n3 * 4], fArray2[n3 * 4 + 1], fArray2[n3 * 4 + 2], fArray2[n3 * 4 + 3], 1.0, 1.0);
            }
        }
        if (fArray != null) {
            n3 = 0;
            if ((n2 == 1 || n2 == 3 || n2 == 2) && (fArray.length < 2 || fArray[0] != 0.0f || fArray[fArray.length - 1] != 1.0f) || n2 == 0 && (fArray.length == 0 || fArray[0] != 0.0f)) {
                n3 = 1;
            }
            if (n3 == 0) {
                for (int i2 = 1; i2 < fArray.length; ++i2) {
                    if (!(fArray[i2] < 0.0f) && !(fArray[1] > 1.0f) && !(fArray[i2] < fArray[i2 - 1])) continue;
                    n3 = 1;
                    break;
                }
            }
            if (n3 != 0) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyTimes"});
            }
        }
    }

    @Override
    protected boolean willReplace() {
        return !this.additive;
    }

    @Override
    protected void sampledLastValue(int n2) {
        this.sampledAtUnitTime(1.0f, n2);
    }

    @Override
    protected void sampledAt(float f2, float f3, int n2) {
        float f4 = f3 == Float.POSITIVE_INFINITY ? 0.0f : f2 / f3;
        this.sampledAtUnitTime(f4, n2);
    }

    protected abstract void sampledAtUnitTime(float var1, int var2);
}

