/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class SecuritySupport {
    private SecuritySupport() {
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    static String getSystemProperty(String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(string){
            private final String val$propName;
            {
                this.val$propName = string;
            }

            public Object run() {
                return System.getProperty(this.val$propName);
            }
        });
    }

    static FileInputStream getFileInputStream(File file) {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(file){
                private final File val$file;
                {
                    this.val$file = file;
                }

                public Object run() {
                    return new FileInputStream(this.val$file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    static InputStream getResourceAsStream(ClassLoader classLoader, String string) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(classLoader, string){
            private final ClassLoader val$cl;
            private final String val$name;
            {
                this.val$cl = classLoader;
                this.val$name = string;
            }

            public Object run() {
                InputStream inputStream = this.val$cl == null ? ClassLoader.getSystemResourceAsStream(this.val$name) : this.val$cl.getResourceAsStream(this.val$name);
                return inputStream;
            }
        });
    }

    static boolean doesFileExist(File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(file){
            private final File val$f;
            {
                this.val$f = file;
            }

            public Object run() {
                return this.val$f.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }
}

