/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

@Documented
@TypeQualifier(applicableTo=Number.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Nonnegative {
    public When when() default When.ALWAYS;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Checker
    implements TypeQualifierValidator<Nonnegative> {
        @Override
        public When forConstantValue(Nonnegative nonnegative, Object object) {
            boolean bl2;
            if (!(object instanceof Number)) {
                return When.NEVER;
            }
            Number number = (Number)object;
            if (number instanceof Long) {
                bl2 = number.longValue() < 0L;
            } else if (number instanceof Double) {
                bl2 = number.doubleValue() < 0.0;
            } else if (number instanceof Float) {
                bl2 = number.floatValue() < 0.0f;
            } else {
                boolean bl3 = bl2 = number.intValue() < 0;
            }
            if (bl2) {
                return When.NEVER;
            }
            return When.ALWAYS;
        }
    }
}

