/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;

class SecuritySupport {
    private SecuritySupport() {
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    public static InputStream getResourceAsStream(final Class clazz, final String string) {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return clazz.getResourceAsStream(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public static URL[] getResources(final ClassLoader classLoader, final String string) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL[] uRLArray = null;
                try {
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    Enumeration<URL> enumeration = classLoader.getResources(string);
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        URL uRL = enumeration.nextElement();
                        if (uRL == null) continue;
                        arrayList.add(uRL);
                    }
                    if (arrayList.size() > 0) {
                        uRLArray = new URL[arrayList.size()];
                        uRLArray = arrayList.toArray(uRLArray);
                    }
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return uRLArray;
            }
        });
    }

    public static URL[] getSystemResources(final String string) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL[] uRLArray = null;
                try {
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    Enumeration<URL> enumeration = ClassLoader.getSystemResources(string);
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        URL uRL = enumeration.nextElement();
                        if (uRL == null) continue;
                        arrayList.add(uRL);
                    }
                    if (arrayList.size() > 0) {
                        uRLArray = new URL[arrayList.size()];
                        uRLArray = arrayList.toArray(uRLArray);
                    }
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return uRLArray;
            }
        });
    }

    public static InputStream openStream(final URL uRL) {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return uRL.openStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }
}

