/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.publicsuffix;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.thirdparty.publicsuffix.PublicSuffixType;
import java.util.List;

@GwtCompatible
final class TrieParser {
    private static final Joiner PREFIX_JOINER = Joiner.on("");

    TrieParser() {
    }

    static ImmutableMap<String, PublicSuffixType> parseTrie(CharSequence charSequence) {
        ImmutableMap.Builder<String, PublicSuffixType> builder = ImmutableMap.builder();
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; i2 += TrieParser.doParseTrieToBuilder(Lists.newLinkedList(), charSequence, i2, builder)) {
        }
        return builder.build();
    }

    private static int doParseTrieToBuilder(List<CharSequence> list, CharSequence charSequence, int n2, ImmutableMap.Builder<String, PublicSuffixType> builder) {
        String string;
        int n3;
        int n4 = charSequence.length();
        char c2 = '\u0000';
        for (n3 = n2; n3 < n4 && (c2 = charSequence.charAt(n3)) != '&' && c2 != '?' && c2 != '!' && c2 != ':' && c2 != ','; ++n3) {
        }
        list.add(0, TrieParser.reverse(charSequence.subSequence(n2, n3)));
        if ((c2 == '!' || c2 == '?' || c2 == ':' || c2 == ',') && (string = PREFIX_JOINER.join(list)).length() > 0) {
            builder.put(string, PublicSuffixType.fromCode(c2));
        }
        ++n3;
        if (c2 != '?' && c2 != ',') {
            while (n3 < n4) {
                if (charSequence.charAt(n3 += TrieParser.doParseTrieToBuilder(list, charSequence, n3, builder)) != '?' && charSequence.charAt(n3) != ',') continue;
                ++n3;
                break;
            }
        }
        list.remove(0);
        return n3 - n2;
    }

    private static CharSequence reverse(CharSequence charSequence) {
        return new StringBuilder(charSequence).reverse();
    }
}

