/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.publicsuffix;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;

@Beta
@GwtCompatible
public enum PublicSuffixType {
    PRIVATE(':', ','),
    REGISTRY('!', '?');

    private final char innerNodeCode;
    private final char leafNodeCode;

    private PublicSuffixType(char c2, char c3) {
        this.innerNodeCode = c2;
        this.leafNodeCode = c3;
    }

    char getLeafNodeCode() {
        return this.leafNodeCode;
    }

    char getInnerNodeCode() {
        return this.innerNodeCode;
    }

    static PublicSuffixType fromCode(char c2) {
        for (PublicSuffixType publicSuffixType : PublicSuffixType.values()) {
            if (publicSuffixType.getInnerNodeCode() != c2 && publicSuffixType.getLeafNodeCode() != c2) continue;
            return publicSuffixType;
        }
        throw new IllegalArgumentException("No enum corresponding to given code: " + c2);
    }

    static PublicSuffixType fromIsPrivate(boolean bl2) {
        return bl2 ? PRIVATE : REGISTRY;
    }
}

