/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers;

import a.h.bQ;
import a.h.ba;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyNodeRealizer;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class ZyNormalNodeRealizer<NodeType extends ZyGraphNode<?>>
extends ZyNodeRealizer<NodeType> {
    private final ZyLabelContent m_content;

    public ZyNormalNodeRealizer(ZyLabelContent zyLabelContent) {
        Preconditions.checkNotNull(zyLabelContent, "Error: Node content can't be null.");
        this.m_content = zyLabelContent;
        this.setShapeType((byte)1);
        this.setLineType(ba.aLi);
        Rectangle2D rectangle2D = this.getNodeContent().getBounds();
        this.setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public ZyLabelContent getNodeContent() {
        return this.m_content;
    }

    @Override
    public bQ getRealizer() {
        return this;
    }

    @Override
    public void paintHotSpots(Graphics2D graphics2D) {
    }

    @Override
    public void paintNode(Graphics2D graphics2D) {
        super.paintNode(graphics2D);
        Rectangle2D rectangle2D = this.getNodeContent().getBounds();
        double d2 = this.getWidth() / rectangle2D.getWidth();
        double d3 = this.getHeight() / rectangle2D.getHeight();
        graphics2D.scale(d2, d3);
        this.getNodeContent().draw(graphics2D, this.getX() * 1.0 / d2, this.getY() * 1.0 / d3);
        graphics2D.scale(1.0 / d2, 1.0 / d3);
    }

    public String toString() {
        return this.m_content.toString();
    }
}

