/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes;

import a.c.p;
import a.h.U;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.ISelectableNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IViewableNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNodeListener;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.NodeHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyNodeRealizerListener;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.List;

public abstract class ZyGraphNode<RawNodeType extends IViewNode<?>>
implements ISelectableNode,
IViewableNode {
    private RawNodeType m_rawNode;
    private final p m_node;
    private final IZyNodeRealizer m_realizer;
    private final InternalListener m_listener;

    public ZyGraphNode(p p2, IZyNodeRealizer iZyNodeRealizer, RawNodeType RawNodeType) {
        this.m_node = Preconditions.checkNotNull(p2, "Node argument cannot be null");
        this.m_realizer = Preconditions.checkNotNull(iZyNodeRealizer, "Node realizer argument cannot be null");
        this.m_rawNode = (IViewNode)Preconditions.checkNotNull(RawNodeType, "Raw node argument cannot be null");
        this.m_realizer.setX(this.m_rawNode.getX());
        this.m_realizer.setY(this.m_rawNode.getY());
        this.m_realizer.setFillColor(this.m_rawNode.getColor());
        this.m_realizer.setLineColor(this.m_rawNode.getBorderColor());
        this.m_realizer.setSelected(this.m_rawNode.isSelected());
        this.getGraph().a(this.m_node, iZyNodeRealizer.getRealizer());
        this.m_listener = new InternalListener(this.getGraph());
        iZyNodeRealizer.addListener(this.m_listener);
        RawNodeType.addListener(this.m_listener);
    }

    private U getGraph() {
        return (U)this.m_node.T();
    }

    private void updateViews() {
        if (this.getGraph() == null) {
            return;
        }
        this.getGraph().updateViews();
    }

    protected void onSelectionChanged() {
    }

    public void addNodeModifier(IZyNodeRealizerListener<? extends ZyGraphNode<RawNodeType>> iZyNodeRealizerListener) {
        this.m_realizer.addListener(iZyNodeRealizerListener);
    }

    @Override
    public void calcUnionRect(Rectangle2D rectangle2D) {
        this.m_realizer.calcUnionRect(rectangle2D);
    }

    public void clearHighlighting(int n2, int n3) {
        ZyLineContent zyLineContent = this.m_realizer.getNodeContent().getLineContent(n3);
        if (zyLineContent.clearHighlighting(n2)) {
            this.updateViews();
        }
    }

    @Override
    public Rectangle2D.Double getBoundingBox() {
        return this.m_realizer.getBoundingBox();
    }

    public abstract List<? extends ZyGraphNode<?>> getChildren();

    public p getNode() {
        return this.m_node;
    }

    public abstract List<? extends ZyGraphNode<?>> getParents();

    public RawNodeType getRawNode() {
        return this.m_rawNode;
    }

    public IZyNodeRealizer getRealizer() {
        return this.m_realizer;
    }

    public double getX() {
        return this.m_realizer.getX();
    }

    public double getY() {
        return this.m_realizer.getY();
    }

    public int indegree() {
        return this.m_node.aJ();
    }

    @Override
    public boolean isSelected() {
        return this.m_realizer.isSelected();
    }

    public boolean isVisible() {
        return this.getGraph() != null;
    }

    public int outdegree() {
        return this.m_node.aK();
    }

    public int positionToRow(double d2) {
        return this.m_realizer.positionToRow(d2);
    }

    public void removeNodeModifier(IZyNodeRealizerListener<? extends ZyGraphNode<RawNodeType>> iZyNodeRealizerListener) {
        this.m_realizer.removeListener(iZyNodeRealizerListener);
    }

    public void setBackgroundColor(int n2, Color color) {
        ZyLineContent zyLineContent = this.m_realizer.getNodeContent().getLineContent(n2);
        zyLineContent.setBackgroundColor(color);
        this.updateViews();
    }

    public void setBackgroundColor(int n2, int n3, int n4, Color color) {
        this.m_realizer.getNodeContent().getLineContent(n2).setBackgroundColor(n3, n4, color);
        this.updateViews();
    }

    public void setColor(int n2, Color color) {
        ZyLineContent zyLineContent = this.m_realizer.getNodeContent().getLineContent(n2);
        zyLineContent.setTextColor(color);
        this.updateViews();
    }

    public void setColor(int n2, int n3, int n4, Color color) {
        ZyLineContent zyLineContent = this.m_realizer.getNodeContent().getLineContent(n2);
        zyLineContent.setTextColor(n3, n4, color);
        this.updateViews();
    }

    public void setHeight(double d2) {
        this.m_realizer.setHeight(d2);
        this.updateViews();
    }

    public void setHighlighting(int n2, int n3, Color color) {
        ZyLineContent zyLineContent = this.m_realizer.getNodeContent().getLineContent(n3);
        if (zyLineContent.setHighlighting(n2, color)) {
            this.updateViews();
        }
    }

    public void setHighlighting(int n2, int n3, int n4, int n5, Color color) {
        ZyLineContent zyLineContent = this.m_realizer.getNodeContent().getLineContent(n3);
        zyLineContent.setHighlighting(n4, n5, n2, color);
        this.updateViews();
    }

    public void setRawNode(RawNodeType RawNodeType) {
        Preconditions.checkArgument(RawNodeType.getClass().equals(this.m_rawNode.getClass()), "Error: Old node and new node have different types");
        this.m_rawNode.removeListener(this.m_listener);
        this.m_rawNode = RawNodeType;
        this.m_rawNode.addListener(this.m_listener);
    }

    public void setWidth(double d2) {
        this.m_realizer.setWidth(d2);
        this.updateViews();
    }

    private class InternalListener
    implements IViewNodeListener,
    IZyNodeRealizerListener<ZyGraphNode<RawNodeType>> {
        private final U m_graph;
        private p m_pnode;

        public InternalListener(U u2) {
            this.m_graph = u2;
        }

        private void showNode(IViewNode<?> iViewNode, boolean bl2) {
            Object object;
            if (bl2) {
                this.m_graph.j(ZyGraphNode.this.m_node);
                if (iViewNode.getParentGroup() != null && !iViewNode.getParentGroup().isVisible()) {
                    iViewNode.getParentGroup().setVisible(true);
                }
                if (iViewNode instanceof IGroupNode) {
                    object = (IGroupNode)iViewNode;
                    if (object.isCollapsed()) {
                        this.m_graph.getHierarchyManager().dZ(ZyGraphNode.this.m_node);
                    } else {
                        this.m_graph.getHierarchyManager().dY(ZyGraphNode.this.m_node);
                    }
                    if (object.isCollapsed()) {
                        for (IViewNode iViewNode2 : object.getElements()) {
                            iViewNode2.setVisible(true);
                        }
                    }
                }
                if (this.m_pnode != null) {
                    this.m_graph.getHierarchyManager().y(ZyGraphNode.this.m_node, this.m_pnode);
                }
            } else {
                this.m_pnode = this.m_graph.getHierarchyManager().aQ(ZyGraphNode.this.m_node);
                if (this.m_pnode == null && iViewNode.getParentGroup() != null) {
                    throw new IllegalStateException("Error");
                }
                if (iViewNode instanceof IGroupNode && (object = (IGroupNode)iViewNode).isCollapsed()) {
                    for (IViewNode iViewNode2 : object.getElements()) {
                        iViewNode2.setVisible(false);
                    }
                }
                if (iViewNode.getParentGroup() == null || !iViewNode.getParentGroup().isCollapsed()) {
                    this.m_graph.h(ZyGraphNode.this.m_node);
                }
            }
            for (Object object2 : iViewNode.getIncomingEdges()) {
                if (iViewNode.getParentGroup() == null) {
                    object2.setVisible(((IViewNode)object2.getSource()).isVisible() && ((IViewNode)object2.getTarget()).isVisible() && NodeHelpers.getVisibleNode((IViewNode)object2.getTarget()).isVisible() && NodeHelpers.getVisibleNode((IViewNode)object2.getSource()).isVisible());
                    continue;
                }
                if (iViewNode.getParentGroup().isCollapsed()) {
                    object2.setVisible(iViewNode.getParentGroup().isVisible() && ((IViewNode)object2.getSource()).isVisible());
                    continue;
                }
                object2.setVisible(((IViewNode)object2.getSource()).isVisible() && ((IViewNode)object2.getTarget()).isVisible() && NodeHelpers.getVisibleNode((IViewNode)object2.getTarget()).isVisible() && NodeHelpers.getVisibleNode((IViewNode)object2.getSource()).isVisible());
            }
            for (Object object2 : iViewNode.getOutgoingEdges()) {
                if (iViewNode.getParentGroup() == null) {
                    object2.setVisible(((IViewNode)object2.getSource()).isVisible() && ((IViewNode)object2.getTarget()).isVisible() && NodeHelpers.getVisibleNode((IViewNode)object2.getTarget()).isVisible() && NodeHelpers.getVisibleNode((IViewNode)object2.getSource()).isVisible());
                    continue;
                }
                if (iViewNode.getParentGroup().isCollapsed()) {
                    object2.setVisible(iViewNode.getParentGroup().isVisible() && ((IViewNode)object2.getTarget()).isVisible());
                    continue;
                }
                object2.setVisible(((IViewNode)object2.getSource()).isVisible() && ((IViewNode)object2.getTarget()).isVisible() && NodeHelpers.getVisibleNode((IViewNode)object2.getTarget()).isVisible() && NodeHelpers.getVisibleNode((IViewNode)object2.getSource()).isVisible());
            }
        }

        @Override
        public void changedBorderColor(IViewNode<?> iViewNode, Color color) {
            ZyGraphNode.this.m_realizer.setLineColor(color);
            ZyGraphNode.this.updateViews();
        }

        @Override
        public void changedColor(IViewNode<?> iViewNode, Color color) {
            ZyGraphNode.this.m_realizer.setFillColor(color);
            ZyGraphNode.this.updateViews();
        }

        @Override
        public void changedLocation(IZyNodeRealizer iZyNodeRealizer, double d2, double d3) {
            ZyGraphNode.this.m_rawNode.setX(d2);
            ZyGraphNode.this.m_rawNode.setY(d3);
        }

        @Override
        public void changedSelection(IViewNode<?> iViewNode, boolean bl2) {
            ZyGraphNode.this.m_realizer.setSelected(bl2);
            ZyGraphNode.this.onSelectionChanged();
            ZyGraphNode.this.updateViews();
        }

        @Override
        public void changedSelection(IZyNodeRealizer iZyNodeRealizer) {
            ZyGraphNode.this.m_rawNode.setSelected(iZyNodeRealizer.isSelected());
        }

        @Override
        public void changedSize(IZyNodeRealizer iZyNodeRealizer, double d2, double d3) {
            ZyGraphNode.this.m_rawNode.setWidth(d2);
            ZyGraphNode.this.m_rawNode.setHeight(d3);
        }

        @Override
        public void changedVisibility(final IViewNode<?> iViewNode, final boolean bl2) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    InternalListener.this.showNode(iViewNode, bl2);
                }
            }.invokeAndWait();
        }

        @Override
        public void changedVisibility(IZyNodeRealizer iZyNodeRealizer) {
            ZyGraphNode.this.m_rawNode.setVisible(iZyNodeRealizer.isVisible());
        }

        @Override
        public void heightChanged(IViewNode<?> iViewNode, double d2) {
            if (ZyGraphNode.this.m_realizer.getHeight() != d2 && d2 != 0.0) {
                ZyGraphNode.this.m_realizer.setHeight(d2);
                ZyGraphNode.this.updateViews();
            }
        }

        @Override
        public void regenerated(IZyNodeRealizer iZyNodeRealizer) {
        }

        @Override
        public void widthChanged(IViewNode<?> iViewNode, double d2) {
            if (ZyGraphNode.this.m_realizer.getWidth() != d2 && d2 != 0.0) {
                ZyGraphNode.this.m_realizer.setWidth(d2);
                ZyGraphNode.this.updateViews();
            }
        }

        @Override
        public void xposChanged(IViewNode<?> iViewNode, double d2) {
            if (ZyGraphNode.this.m_realizer.getX() != d2) {
                ZyGraphNode.this.m_realizer.setX(d2);
                ZyGraphNode.this.updateViews();
            }
        }

        @Override
        public void yposChanged(IViewNode<?> iViewNode, double d2) {
            if (ZyGraphNode.this.m_realizer.getY() != d2) {
                ZyGraphNode.this.m_realizer.setY(d2);
                ZyGraphNode.this.updateViews();
            }
        }
    }
}

