/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.states;

import a.c.p;
import a.h.aM;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.CStateChange;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IMouseState;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IMouseStateChange;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.CStateFactory;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.transformations.CHitNodesTransformer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.event.MouseEvent;

public class CNodeDraggedLeftState<NodeType extends ZyGraphNode<?>, EdgeType extends ZyGraphEdge<?, ?, ?>>
implements IMouseState {
    private final CStateFactory<NodeType, EdgeType> m_factory;
    private final AbstractZyGraph<NodeType, EdgeType> m_graph;
    private final MouseEvent m_event;
    private final p m_node;
    private final double m_distX;
    private final double m_distY;

    public CNodeDraggedLeftState(CStateFactory<NodeType, EdgeType> cStateFactory, AbstractZyGraph<NodeType, EdgeType> abstractZyGraph, p p2, MouseEvent mouseEvent) {
        this(cStateFactory, abstractZyGraph, p2, mouseEvent, 0.0, 0.0);
    }

    public CNodeDraggedLeftState(CStateFactory<NodeType, EdgeType> cStateFactory, AbstractZyGraph<NodeType, EdgeType> abstractZyGraph, p p2, MouseEvent mouseEvent, double d2, double d3) {
        this.m_factory = Preconditions.checkNotNull(cStateFactory, "Error: factory argument can not be null");
        this.m_graph = Preconditions.checkNotNull(abstractZyGraph, "Error: graph argument can not be null");
        this.m_node = Preconditions.checkNotNull(p2, "Error: node argument can not be null");
        this.m_event = Preconditions.checkNotNull(mouseEvent, "Error: event argument can not be null");
        this.m_distX = d2;
        this.m_distY = d3;
    }

    public double getDistanceX() {
        return this.m_distX;
    }

    public double getDistanceY() {
        return this.m_distY;
    }

    public AbstractZyGraph<NodeType, EdgeType> getGraph() {
        return this.m_graph;
    }

    public p getNode() {
        return this.m_node;
    }

    public CStateFactory<NodeType, EdgeType> getStateFactory() {
        return this.m_factory;
    }

    @Override
    public IMouseStateChange mouseDragged(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        double d2 = this.m_graph.getEditMode().translateX(mouseEvent.getX()) - this.m_graph.getEditMode().translateX(this.m_event.getX());
        double d3 = this.m_graph.getEditMode().translateY(mouseEvent.getY()) - this.m_graph.getEditMode().translateY(this.m_event.getY());
        return new CStateChange(this.m_factory.createNodeDraggedLeftState(this.m_node, mouseEvent, d2, d3), false);
    }

    @Override
    public IMouseStateChange mouseMoved(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        double d2 = this.m_graph.getEditMode().translateX(mouseEvent.getX()) - this.m_graph.getEditMode().translateX(this.m_event.getX());
        double d3 = this.m_graph.getEditMode().translateY(mouseEvent.getY()) - this.m_graph.getEditMode().translateY(this.m_event.getY());
        return new CStateChange(this.m_factory.createNodeDraggedLeftState(this.m_node, mouseEvent, d2, d3), false);
    }

    @Override
    public IMouseStateChange mousePressed(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        double d2 = this.m_graph.getEditMode().translateX(mouseEvent.getX()) - this.m_graph.getEditMode().translateX(this.m_event.getX());
        double d3 = this.m_graph.getEditMode().translateY(mouseEvent.getY()) - this.m_graph.getEditMode().translateY(this.m_event.getY());
        return new CStateChange(this.m_factory.createNodeDraggedLeftState(this.m_node, mouseEvent, d2, d3), false);
    }

    @Override
    public IMouseStateChange mouseReleased(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        double d2 = this.m_graph.getEditMode().translateX(mouseEvent.getX());
        double d3 = this.m_graph.getEditMode().translateY(mouseEvent.getY());
        aM aM2 = this.m_graph.getGraph().getHitInfo(d2, d3);
        if (aM2.Do()) {
            return CHitNodesTransformer.changeNode(this.m_factory, mouseEvent, aM2, this.m_node);
        }
        this.m_factory.createNodeExitState(this.m_node, mouseEvent);
        return CHitNodesTransformer.exitNode(this.m_factory, mouseEvent, aM2, this);
    }
}

