/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode;

import a.h.aI;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.MouseWheelAction;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeFilter;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IViewableNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.MoveFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.helpers.ZoomHelpers;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.event.MouseWheelEvent;
import java.util.Set;

public class ZyEditModeMouseWheelListener<NodeType extends ZyGraphNode<?> & IViewableNode, EdgeType extends ZyGraphEdge<?, ?, ?>>
extends aI {
    private static final double ZOOM_SUB_FACTOR = 0.02;
    private static final double SCROLL_SUB_FACTOR = 0.6;
    private final AbstractZyGraph<NodeType, EdgeType> m_zyGraph;

    public ZyEditModeMouseWheelListener(AbstractZyGraph<NodeType, EdgeType> abstractZyGraph) {
        Preconditions.checkNotNull(abstractZyGraph, "Error: Graph argument can't be null");
        this.m_zyGraph = abstractZyGraph;
        this.setCenterZooming(false);
    }

    private void centerZoom(double d2, boolean bl2) {
        Set<NodeType> set;
        if (bl2 && (set = this.m_zyGraph.getSelectedNodes()).size() != 0) {
            MoveFunctions.centerNodes(this.m_zyGraph, set);
        }
        this.m_zyGraph.zoom(d2);
    }

    private void handleInMoveMode(MouseWheelEvent mouseWheelEvent) {
        boolean bl2;
        boolean bl3 = bl2 = mouseWheelEvent.getUnitsToScroll() > 0;
        if (mouseWheelEvent.isAltDown()) {
            this.moveVertical(bl2);
        } else {
            this.moveHorizontal(bl2);
        }
    }

    private void handleInZoomMode(MouseWheelEvent mouseWheelEvent) {
        this.zoom(mouseWheelEvent, mouseWheelEvent.getUnitsToScroll() > 0, mouseWheelEvent.isShiftDown());
    }

    private boolean hasSelectedNode() {
        return GraphHelpers.any(this.m_zyGraph, new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType NodeType2) {
                return ((ZyGraphNode)NodeType2).isSelected();
            }
        });
    }

    private void moveHorizontal(boolean bl2) {
        if (bl2) {
            MoveFunctions.pan(this.m_zyGraph, 0.0, 0.6 * (double)this.m_zyGraph.getSettings().getMouseSettings().getScrollSensitivity());
        } else {
            MoveFunctions.pan(this.m_zyGraph, 0.0, -0.6 * (double)this.m_zyGraph.getSettings().getMouseSettings().getScrollSensitivity());
        }
    }

    private void moveVertical(boolean bl2) {
        if (bl2) {
            MoveFunctions.pan(this.m_zyGraph, 0.6 * (double)this.m_zyGraph.getSettings().getMouseSettings().getScrollSensitivity(), 0.0);
        } else {
            MoveFunctions.pan(this.m_zyGraph, -0.6 * (double)this.m_zyGraph.getSettings().getMouseSettings().getScrollSensitivity(), 0.0);
        }
    }

    private void zoom(MouseWheelEvent mouseWheelEvent, boolean bl2, boolean bl3) {
        if (!this.hasSelectedNode() || !bl3) {
            super.mouseWheelMoved(mouseWheelEvent);
        } else if (bl2) {
            this.centerZoom(1.0 - (double)this.m_zyGraph.getSettings().getMouseSettings().getZoomSensitivity() * 0.02, bl3);
        } else {
            this.centerZoom(1.0 + (double)this.m_zyGraph.getSettings().getMouseSettings().getZoomSensitivity() * 0.02, bl3);
        }
    }

    @Override
    protected double calcZoom(double d2, int n2) {
        if (n2 > 0) {
            double d3 = ZoomHelpers.getMinimumZoom(this.m_zyGraph.getView());
            this.setMinimumZoom(d3);
            double d4 = 1.0 - (double)this.m_zyGraph.getSettings().getMouseSettings().getZoomSensitivity() * 0.02;
            if (d3 > 0.5) {
                super.setMinimumZoom(0.75);
                return this.m_zyGraph.getView().getZoom() * d4;
            }
            return Math.max(this.m_zyGraph.getView().getZoom() * d4, d3);
        }
        double d5 = 1.0 + (double)this.m_zyGraph.getSettings().getMouseSettings().getZoomSensitivity() * 0.02;
        this.setMaximumZoom(3.0);
        return this.m_zyGraph.getView().getZoom() * d5;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n2 = Math.abs(mouseWheelEvent.getUnitsToScroll());
        boolean bl2 = mouseWheelEvent.isControlDown();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.m_zyGraph.getSettings().getMouseSettings().getMouseWheelAction() == MouseWheelAction.ZOOM && !bl2 || this.m_zyGraph.getSettings().getMouseSettings().getMouseWheelAction() == MouseWheelAction.SCROLL && bl2) {
                this.handleInZoomMode(mouseWheelEvent);
                continue;
            }
            this.handleInMoveMode(mouseWheelEvent);
        }
        this.m_zyGraph.updateViews();
    }
}

