/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode;

import a.c.d;
import a.c.p;
import a.h.P;
import a.h.bb;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.CDefaultLabelEventHandler;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.CDefaultActionFactory;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IMouseState;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IMouseStateChange;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IStateActionFactory;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.ISelectableNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.IZyEditModeListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.CSelectionMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.CStateFactory;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.ZyEditModeMouseWheelListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.helpers.CTooltipUpdater;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ZyEditMode<NodeType extends ZyGraphNode<?> & ISelectableNode, EdgeType extends ZyGraphEdge<?, ?, ?>>
extends P {
    private final IStateActionFactory<NodeType, EdgeType> m_actionFactory;
    private final CStateFactory<NodeType, EdgeType> m_stateFactory;
    private IMouseState m_state;
    private final AbstractZyGraph<NodeType, EdgeType> m_graph;
    private final bb m_magifierViewMode = new bb();
    private final List<IZyEditModeListener<NodeType, EdgeType>> m_listeners = new ArrayList<IZyEditModeListener<NodeType, EdgeType>>();
    private final CDefaultLabelEventHandler m_labelKeyHandler;
    private boolean m_inMouseMoved;
    private boolean m_inMouseDragged;
    private boolean m_inMousePressed;
    private boolean m_inMouseDraggedRight;

    public ZyEditMode(AbstractZyGraph<NodeType, EdgeType> abstractZyGraph) {
        this.m_graph = Preconditions.checkNotNull(abstractZyGraph);
        this.m_labelKeyHandler = this.createNodeKeyHandler(abstractZyGraph);
        this.m_actionFactory = this.createStateActionFactory();
        this.m_stateFactory = new CStateFactory<NodeType, EdgeType>(abstractZyGraph, this.m_listeners, this.m_actionFactory);
        this.m_state = this.m_stateFactory.createDefaultState();
        this.setDefaultBehaviour();
    }

    private boolean getMagnifyingMode() {
        Iterator iterator = this.m_graph.getView().getViewModes();
        while (iterator.hasNext()) {
            if (iterator.next() != this.m_magifierViewMode) continue;
            return true;
        }
        return false;
    }

    private void setDefaultBehaviour() {
        this.allowBendCreation(false);
        this.allowEdgeCreation(false);
        this.allowNodeCreation(false);
        this.allowMoveLabels(true);
        this.allowMovePorts(true);
        this.allowNodeEditing(true);
        this.allowMoving(true);
        this.allowMoveSelection(true);
        this.showEdgeTips(true);
        this.showNodeTips(true);
        this.setSelectionBoxMode(new CSelectionMode<NodeType>(this.m_graph));
        this.m_graph.getView().getCanvasComponent().addMouseWheelListener(new ZyEditModeMouseWheelListener<NodeType, EdgeType>(this.m_graph));
    }

    protected CDefaultLabelEventHandler createNodeKeyHandler(AbstractZyGraph<NodeType, EdgeType> abstractZyGraph) {
        return new CDefaultLabelEventHandler(abstractZyGraph);
    }

    protected IStateActionFactory<NodeType, EdgeType> createStateActionFactory() {
        return new CDefaultActionFactory();
    }

    @Override
    protected String getEdgeTip(d d2) {
        return CTooltipUpdater.updateEdgeTooltip(this.m_graph, d2);
    }

    protected AbstractZyGraph<NodeType, EdgeType> getGraph() {
        return this.m_graph;
    }

    @Override
    protected String getNodeTip(p p2) {
        return CTooltipUpdater.updateNodeTooltip(this.m_graph, p2);
    }

    public void addListener(IZyEditModeListener<NodeType, EdgeType> iZyEditModeListener) {
        this.m_listeners.add(iZyEditModeListener);
    }

    public CDefaultLabelEventHandler getLabelEventHandler() {
        return this.m_labelKeyHandler;
    }

    public boolean isInMouseDragged() {
        return this.m_inMouseDragged;
    }

    public boolean isInMouseDraggedRight() {
        return this.m_inMouseDraggedRight;
    }

    public boolean isInMouseMoved() {
        return this.m_inMouseMoved;
    }

    public boolean isInMousePressed() {
        return this.m_inMousePressed;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Preconditions.checkNotNull(mouseEvent, "Error: mouse event can not be null");
        IMouseStateChange iMouseStateChange = this.m_state.mouseDragged(mouseEvent, this.m_graph);
        this.m_state = iMouseStateChange.getNextState();
        if (iMouseStateChange.notifyYFiles()) {
            this.m_inMouseDragged = true;
            try {
                super.mouseDragged(mouseEvent);
            }
            finally {
                this.m_inMouseDragged = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDraggedRight(double d2, double d3) {
        this.m_inMouseDraggedRight = true;
        try {
            super.mouseDraggedRight(d2, d3);
        }
        finally {
            this.m_inMouseDraggedRight = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(double d2, double d3) {
        this.m_inMouseMoved = true;
        try {
            super.mouseMoved(d2, d3);
        }
        finally {
            this.m_inMouseMoved = false;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Preconditions.checkNotNull(mouseEvent, "Error: mouse event can not be null");
        IMouseStateChange iMouseStateChange = this.m_state.mouseMoved(mouseEvent, this.m_graph);
        this.m_state = iMouseStateChange.getNextState();
        if (iMouseStateChange.notifyYFiles()) {
            this.m_inMouseMoved = true;
            try {
                super.mouseMoved(mouseEvent);
            }
            finally {
                this.m_inMouseMoved = false;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        IMouseStateChange iMouseStateChange = this.m_state.mousePressed(mouseEvent, this.m_graph);
        this.m_state = iMouseStateChange.getNextState();
        if (iMouseStateChange.notifyYFiles()) {
            this.m_inMousePressed = true;
            try {
                super.mousePressed(mouseEvent);
            }
            finally {
                this.m_inMousePressed = false;
            }
        }
    }

    @Override
    public void mouseReleased(double d2, double d3) {
        super.mouseReleased(d2, d3);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        IMouseStateChange iMouseStateChange = this.m_state.mouseReleased(mouseEvent, this.m_graph);
        this.m_state = iMouseStateChange.getNextState();
        if (iMouseStateChange.notifyYFiles()) {
            super.mouseReleased(mouseEvent);
        }
    }

    public void setMagnifyingMode(boolean bl2) {
        if (this.getMagnifyingMode() == bl2) {
            return;
        }
        if (bl2) {
            this.m_graph.getView().addViewMode(this.m_magifierViewMode);
        } else {
            this.m_graph.getView().removeViewMode(this.m_magifierViewMode);
        }
    }

    @Override
    public double translateX(int n2) {
        return super.translateX(n2);
    }

    @Override
    public double translateY(int n2) {
        return super.translateY(n2);
    }
}

