/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges;

import a.c.d;
import a.c.p;
import a.d.l;
import a.h.O;
import a.h.U;
import a.h.t;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IBendListener;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdgeListener;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEdgeRealizerListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeRealizer;
import java.awt.Color;
import java.util.ArrayList;

public class ZyGraphEdge<NodeTypeT extends ZyGraphNode<?>, EdgeTypeT extends ZyGraphEdge<?, ?, ?>, RawEdgeTypeT extends IViewEdge<?>> {
    private d m_edge;
    private RawEdgeTypeT m_rawEdge;
    private final InternalListener m_listener = new InternalListener();
    private final ZyEdgeRealizer<EdgeTypeT> m_realizer;
    private final U m_graph;
    private final NodeTypeT m_targetNode;
    private final NodeTypeT m_sourceNode;

    public ZyGraphEdge(NodeTypeT NodeTypeT, NodeTypeT NodeTypeT2, d d2, ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer, RawEdgeTypeT RawEdgeTypeT) {
        Preconditions.checkNotNull(NodeTypeT, "Source node cannot be null");
        Preconditions.checkNotNull(NodeTypeT2, "Target node cannot be null");
        Preconditions.checkNotNull(d2, "Edge argument cannot be null");
        Preconditions.checkNotNull(RawEdgeTypeT, "Raw edge argument cannot be null");
        this.m_sourceNode = NodeTypeT;
        this.m_targetNode = NodeTypeT2;
        this.m_edge = d2;
        this.m_rawEdge = RawEdgeTypeT;
        this.m_realizer = zyEdgeRealizer;
        this.m_realizer.setSelected(RawEdgeTypeT.isSelected());
        this.m_realizer.setSourcePoint(new l(RawEdgeTypeT.getX1(), RawEdgeTypeT.getY1()));
        this.m_realizer.setTargetPoint(new l(RawEdgeTypeT.getX2(), RawEdgeTypeT.getY2()));
        this.m_graph = (U)d2.T();
        this.m_graph.a(d2, zyEdgeRealizer);
        for (CBend cBend : this.m_rawEdge.getBends()) {
            this.m_realizer.addPoint(cBend.getX(), cBend.getY());
            cBend.addListener(this.m_listener);
        }
        zyEdgeRealizer.addListener(this.m_listener);
        RawEdgeTypeT.addListener(this.m_listener);
    }

    private static U getGraph(d d2) {
        return (U)d2.T();
    }

    private ZyEdgeRealizer<EdgeTypeT> getRealizer(d d2) {
        ZyEdgeRealizer zyEdgeRealizer = (ZyEdgeRealizer)ZyGraphEdge.getGraph(d2).co(d2);
        Preconditions.checkState(zyEdgeRealizer != null, "Node does not have a realizer");
        return zyEdgeRealizer;
    }

    private void updateViews() {
        if (ZyGraphEdge.getGraph(this.m_edge) != null) {
            ZyGraphEdge.getGraph(this.m_edge).updateViews();
        }
    }

    public void addPath(double d2, double d3) {
        this.getRealizer(this.m_edge).addPoint(d2, d3);
    }

    public void dispose() {
        for (CBend cBend : this.m_rawEdge.getBends()) {
            cBend.removeListener(this.m_listener);
        }
        this.m_realizer.removeListener(this.m_listener);
        this.m_rawEdge.removeListener(this.m_listener);
    }

    public d getEdge() {
        return this.m_edge;
    }

    public ArrayList<Pair<Double, Double>> getPaths() {
        int n2 = this.getRealizer(this.m_edge).pointCount();
        ArrayList<Pair<Double, Double>> arrayList = new ArrayList<Pair<Double, Double>>();
        for (int i2 = 0; i2 < n2; ++i2) {
            l l2 = this.getRealizer(this.m_edge).getPoint(i2);
            arrayList.add(new Pair<Double, Double>(l2.x, l2.y));
        }
        return arrayList;
    }

    public RawEdgeTypeT getRawEdge() {
        return this.m_rawEdge;
    }

    public ZyEdgeRealizer<EdgeTypeT> getRealizer() {
        return this.m_realizer;
    }

    public NodeTypeT getSource() {
        return this.m_sourceNode;
    }

    public NodeTypeT getTarget() {
        return this.m_targetNode;
    }

    public double getX1() {
        return this.getRealizer((d)this.m_edge).getSourcePoint().x;
    }

    public double getX2() {
        return this.getRealizer((d)this.m_edge).getTargetPoint().x;
    }

    public double getY1() {
        return this.getRealizer((d)this.m_edge).getSourcePoint().y;
    }

    public double getY2() {
        return this.getRealizer((d)this.m_edge).getTargetPoint().y;
    }

    public boolean isSelected() {
        return this.m_realizer.isSelected();
    }

    public boolean isVisible() {
        return this.m_edge.T() != null;
    }

    public void setRawEdge(RawEdgeTypeT RawEdgeTypeT) {
        this.m_rawEdge.removeListener(this.m_listener);
        this.m_rawEdge = RawEdgeTypeT;
        this.m_rawEdge.addListener(this.m_listener);
    }

    public void setX1(double d2) {
        this.getRealizer(this.m_edge).setSourcePoint(new l(d2, this.getY1()));
    }

    public void setX2(double d2) {
        this.getRealizer(this.m_edge).setTargetPoint(new l(d2, this.getY2()));
    }

    public void setY1(double d2) {
        this.getRealizer(this.m_edge).setSourcePoint(new l(this.getX1(), d2));
    }

    public void setY2(double d2) {
        this.getRealizer(this.m_edge).setTargetPoint(new l(this.getX2(), d2));
    }

    private class InternalListener
    implements IBendListener,
    IViewEdgeListener,
    IZyEdgeRealizerListener<EdgeTypeT> {
        private InternalListener() {
        }

        @Override
        public void addedBend(double d2, double d3) {
            ZyGraphEdge.this.m_rawEdge.addBend(d2, d3);
        }

        @Override
        public void addedBend(IViewEdge<?> iViewEdge, CBend cBend) {
            cBend.addListener(ZyGraphEdge.this.m_listener);
            if (ZyGraphEdge.this.m_realizer.bendCount() == iViewEdge.getBendCount()) {
                return;
            }
            ZyGraphEdge.this.m_realizer.appendBend(cBend.getX(), cBend.getY());
        }

        @Override
        public void bendChanged(int n2, double d2, double d3) {
            CBend cBend = ZyGraphEdge.this.m_rawEdge.getBends().get(n2);
            cBend.setX(d2);
            cBend.setY(d3);
        }

        @Override
        public void changedColor(CViewEdge<?> cViewEdge, Color color) {
            ZyGraphEdge.this.m_realizer.setLineColor(color);
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedLocation(ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer) {
            l l2 = zyEdgeRealizer.getSourcePoint();
            ZyGraphEdge.this.m_rawEdge.setX1(l2.x);
            ZyGraphEdge.this.m_rawEdge.setY1(l2.y);
            l l3 = zyEdgeRealizer.getTargetPoint();
            ZyGraphEdge.this.m_rawEdge.setX2(l3.x);
            ZyGraphEdge.this.m_rawEdge.setY2(l3.y);
        }

        @Override
        public void changedSelection(IViewEdge<?> iViewEdge, boolean bl2) {
            ZyGraphEdge.this.m_realizer.setSelected(bl2);
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedSourceX(CViewEdge<?> cViewEdge, double d2) {
            l l2 = ZyGraphEdge.this.m_realizer.getSourcePoint();
            ZyGraphEdge.this.m_realizer.setSourcePoint(new l(d2, l2.y));
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedSourceY(CViewEdge<?> cViewEdge, double d2) {
            l l2 = ZyGraphEdge.this.m_realizer.getSourcePoint();
            ZyGraphEdge.this.m_realizer.setSourcePoint(new l(l2.x, d2));
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedTargetX(CViewEdge<?> cViewEdge, double d2) {
            l l2 = ZyGraphEdge.this.m_realizer.getTargetPoint();
            ZyGraphEdge.this.m_realizer.setTargetPoint(new l(d2, l2.y));
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedTargetY(CViewEdge<?> cViewEdge, double d2) {
            l l2 = ZyGraphEdge.this.m_realizer.getTargetPoint();
            ZyGraphEdge.this.m_realizer.setTargetPoint(new l(l2.x, d2));
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedType(CViewEdge<?> cViewEdge, EdgeType edgeType) {
        }

        @Override
        public void changedVisibility(IViewEdge<?> iViewEdge, boolean bl2) {
            if (bl2) {
                p p2 = ZyGraphEdge.this.m_sourceNode.getNode();
                p p3 = ZyGraphEdge.this.m_targetNode.getNode();
                if (p2.T() == null || p3.T() == null) {
                    return;
                }
                a.h.a.p p4 = ZyGraphEdge.this.m_graph.getHierarchyManager();
                d d2 = p4.c(p2, p3);
                ZyGraphEdge.this.m_graph.a(d2, (O)ZyGraphEdge.this.m_realizer);
                ZyGraphEdge.this.m_edge = d2;
            } else if (ZyGraphEdge.this.m_edge.T() == ZyGraphEdge.this.m_graph) {
                ZyGraphEdge.this.m_graph.e(ZyGraphEdge.this.m_edge);
            }
        }

        @Override
        public void changedVisibility(ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer) {
            ZyGraphEdge.this.m_rawEdge.setVisible(zyEdgeRealizer.isVisible());
        }

        @Override
        public void changedX(CBend cBend, double d2) {
            int n2 = ZyGraphEdge.this.m_rawEdge.getBends().indexOf(cBend);
            t t2 = ZyGraphEdge.this.m_realizer.getBend(n2);
            t2.setLocation(d2, t2.getY());
        }

        @Override
        public void changedY(CBend cBend, double d2) {
            int n2 = ZyGraphEdge.this.m_rawEdge.getBends().indexOf(cBend);
            t t2 = ZyGraphEdge.this.m_realizer.getBend(n2);
            t2.setLocation(t2.getX(), d2);
        }

        @Override
        public void clearedBends() {
            for (CBend cBend : ZyGraphEdge.this.m_rawEdge.getBends()) {
                cBend.removeListener(this);
            }
            ZyGraphEdge.this.m_rawEdge.clearBends();
        }

        @Override
        public void clearedBends(IViewEdge<?> iViewEdge) {
            if (ZyGraphEdge.this.m_realizer.bendCount() != 0) {
                ZyGraphEdge.this.m_realizer.clearBends();
            }
        }

        @Override
        public void insertedBend(int n2, double d2, double d3) {
            if (ZyGraphEdge.this.m_realizer.bendCount() == ZyGraphEdge.this.m_rawEdge.getBendCount()) {
                return;
            }
            ZyGraphEdge.this.m_rawEdge.insertBend(n2, d2, d3);
        }

        @Override
        public void insertedBend(IViewEdge<?> iViewEdge, int n2, CBend cBend) {
            Preconditions.checkNotNull(iViewEdge, "Edge cannot be null");
            Preconditions.checkNotNull(cBend, "Error: bend argument can not be null");
            cBend.addListener(ZyGraphEdge.this.m_listener);
            if (ZyGraphEdge.this.m_realizer.bendCount() == iViewEdge.getBendCount()) {
                return;
            }
            if (iViewEdge == this) {
                ZyGraphEdge.this.m_realizer.insertBend(cBend.getX(), cBend.getY());
            }
        }

        @Override
        public void regenerated(ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer) {
        }

        @Override
        public void removedBend(CViewEdge<?> cViewEdge, int n2, CBend cBend) {
            cBend.removeListener(ZyGraphEdge.this.m_listener);
            if (ZyGraphEdge.this.m_realizer.bendCount() == ZyGraphEdge.this.m_rawEdge.getBendCount()) {
                return;
            }
            ZyGraphEdge.this.m_realizer.removeBend(ZyGraphEdge.this.m_realizer.getBend(n2));
        }

        @Override
        public void removedBend(ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer, int n2) {
            ZyGraphEdge.this.m_rawEdge.removeBend(n2);
        }
    }
}

