/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph;

import a.c.d;
import a.c.p;
import a.f.R;
import a.h.U;
import a.h.a.k;
import a.h.ar;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.AbstractZyGraphSettings;
import com.google.security.zynamics.zylib.gui.zygraph.CDefaultLabelEventHandler;
import com.google.security.zynamics.zylib.gui.zygraph.CGraphSettingsSynchronizer;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphSelectionListener;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphVisibilityListener;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeIterableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IIterableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.ProximityRangeCalculator;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettings;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.IZyGraphListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.InternalEditModeListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraph2DView;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraphLayeredRenderer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraphMappings;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraphSelectionObserver;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.ZyEditMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.LayoutFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.grouping.GroupHelpers;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.helpers.ZoomHelpers;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyDefaultProximityBrowser;
import java.awt.Cursor;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public abstract class AbstractZyGraph<NodeType extends ZyGraphNode<?>, EdgeType extends ZyGraphEdge<?, ?, ?>>
implements IEdgeIterableGraph<EdgeType>,
IIterableGraph<NodeType> {
    private static final double STANDARD_ZOOM_FACTOR = 0.8;
    private final ListenerProvider<IZyGraphListener<NodeType, EdgeType>> m_graphListeners = new ListenerProvider();
    private final ListenerProvider<IZyGraphVisibilityListener> m_visibilityListener = new ListenerProvider();
    private final AbstractZyGraphSettings m_settings;
    private ZyDefaultProximityBrowser<NodeType, EdgeType> m_proximityBrowser;
    private final U m_graph;
    private final ZyGraph2DView m_view;
    private final ZyEditMode<NodeType, EdgeType> m_editMode;
    private final ZyGraphSelectionObserver m_selectionObserver = new ZyGraphSelectionObserver();
    private final ZyGraphMappings<NodeType, EdgeType> m_mappings;
    private InternalEditModeListener<NodeType, EdgeType> m_editModeListener;
    private final CGraphSettingsSynchronizer m_settingsSynchronizer;

    protected AbstractZyGraph(ZyGraph2DView zyGraph2DView, LinkedHashMap<p, NodeType> linkedHashMap, LinkedHashMap<d, EdgeType> linkedHashMap2, AbstractZyGraphSettings abstractZyGraphSettings) {
        this.m_view = Preconditions.checkNotNull(zyGraph2DView, "Error: View argument can't be null");
        Preconditions.checkNotNull(linkedHashMap, "Error: Node map argument can't be null");
        this.m_graph = this.m_view.getGraph2D();
        this.m_view.setGraph2DRenderer(new ZyGraphLayeredRenderer<ZyGraph2DView>(this.m_view));
        this.m_settings = abstractZyGraphSettings;
        this.m_mappings = new ZyGraphMappings<NodeType, EdgeType>(this.m_graph, linkedHashMap, linkedHashMap2);
        this.setProximityBrowser(new ZyDefaultProximityBrowser(this, this.m_settings));
        this.m_editMode = this.createEditMode();
        this.m_settingsSynchronizer = new CGraphSettingsSynchronizer(this.m_editMode, this.m_settings);
        this.initializeListeners();
        this.initializeView();
        this.setupHierarchyManager();
    }

    private void initializeListeners() {
        this.m_graph.a(this.m_selectionObserver);
        this.m_graph.a(this.m_selectionObserver);
    }

    private void initializeView() {
        this.getView().addViewMode(this.m_editMode);
        this.m_editModeListener = new InternalEditModeListener<NodeType, EdgeType>(this.m_graphListeners);
        this.m_editMode.addListener(this.m_editModeListener);
        this.getView().setAntialiasedPainting(true);
    }

    private void notifyVisibilityListeners() {
        for (IZyGraphVisibilityListener iZyGraphVisibilityListener : this.m_visibilityListener) {
            try {
                iZyGraphVisibilityListener.visibilityChanged();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void setupHierarchyManager() {
        if (this.m_graph.getHierarchyManager() == null) {
            a.h.a.p p2 = new a.h.a.p(this.m_graph);
            this.m_graph.a(p2);
            p2.a(new k.a());
        }
    }

    private void showNeighbors(Collection<NodeType> collection) {
        Set<NodeType> set = ProximityRangeCalculator.getNeighbors(this, collection, this.getSettings().getProximitySettings().getProximityBrowsingChildren(), this.getSettings().getProximitySettings().getProximityBrowsingParents());
        this.showNodesInternal(set);
    }

    private void showNodesInternal(Collection<NodeType> collection) {
        for (ZyGraphNode zyGraphNode : collection) {
            Preconditions.checkNotNull(zyGraphNode, "Error: The list of nodes to show contained an invalid node");
            if (zyGraphNode.getRawNode().isVisible()) continue;
            zyGraphNode.getRawNode().setVisible(true);
        }
    }

    private Collection<NodeType> sortLayers(Collection<NodeType> collection) {
        ArrayList<NodeType> arrayList = new ArrayList<NodeType>(collection);
        Collections.sort(arrayList, new Comparator<NodeType>(){

            private boolean isInsideGroup(IViewNode<?> iViewNode, IGroupNode<?, ?> iGroupNode) {
                IGroupNode<?, ?> iGroupNode2 = iViewNode.getParentGroup();
                if (iGroupNode2 == null) {
                    return false;
                }
                if (iGroupNode2 == iGroupNode) {
                    return true;
                }
                return this.isInsideGroup(iViewNode, iGroupNode.getParentGroup());
            }

            @Override
            public int compare(NodeType NodeType2, NodeType NodeType3) {
                Object RawNodeType = ((ZyGraphNode)NodeType2).getRawNode();
                Object RawNodeType2 = ((ZyGraphNode)NodeType3).getRawNode();
                if (RawNodeType instanceof IGroupNode && RawNodeType2 instanceof IGroupNode) {
                    if (this.isInsideGroup((IViewNode<?>)RawNodeType2, (IGroupNode)RawNodeType)) {
                        return 1;
                    }
                    if (this.isInsideGroup((IViewNode<?>)RawNodeType, (IGroupNode)RawNodeType2)) {
                        return -1;
                    }
                    return 0;
                }
                if (RawNodeType instanceof IGroupNode) {
                    return this.isInsideGroup((IViewNode<?>)RawNodeType2, (IGroupNode)RawNodeType) ? 1 : 0;
                }
                if (NodeType3 instanceof IGroupNode) {
                    return this.isInsideGroup((IViewNode<?>)RawNodeType, (IGroupNode)RawNodeType2) ? 1 : 0;
                }
                return 0;
            }
        });
        return arrayList;
    }

    protected ZyEditMode<NodeType, EdgeType> createEditMode() {
        return new ZyEditMode(this);
    }

    protected void notifyDeletionListeners() {
        for (IZyGraphVisibilityListener iZyGraphVisibilityListener : this.m_visibilityListener) {
            try {
                iZyGraphVisibilityListener.nodeDeleted();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void removeNode(NodeType NodeType2) {
        p p2;
        a.h.a.p p3;
        if (((ZyGraphNode)NodeType2).getNode().T() == null) {
            this.m_graph.j(((ZyGraphNode)NodeType2).getNode());
        }
        if ((p3 = this.m_graph.getHierarchyManager()).eg(p2 = ((ZyGraphNode)NodeType2).getNode())) {
            this.m_graph.h(((ZyGraphNode)NodeType2).getNode());
        } else if (this.getGraph().getHierarchyManager().ef(((ZyGraphNode)NodeType2).getNode())) {
            GroupHelpers.extractFolder(this.m_graph, ((ZyGraphNode)NodeType2).getNode());
            this.m_graph.h(((ZyGraphNode)NodeType2).getNode());
        } else if (this.getGraph().getHierarchyManager().ai(((ZyGraphNode)NodeType2).getNode())) {
            GroupHelpers.extractGroup(this.m_graph, ((ZyGraphNode)NodeType2).getNode());
            this.m_graph.h(((ZyGraphNode)NodeType2).getNode());
        }
        this.m_mappings.removeNode(NodeType2);
    }

    public void addListener(IZyGraphListener<NodeType, EdgeType> iZyGraphListener) {
        this.m_graphListeners.addListener(iZyGraphListener);
    }

    public void addListener(IZyGraphSelectionListener iZyGraphSelectionListener) {
        this.m_selectionObserver.addListener(iZyGraphSelectionListener);
    }

    public void addListener(IZyGraphVisibilityListener iZyGraphVisibilityListener) {
        this.m_visibilityListener.addListener(iZyGraphVisibilityListener);
    }

    public void dispose() {
        this.m_settingsSynchronizer.dispose();
    }

    public void doLayout() {
        LayoutFunctions.doLayout(this, this.m_settings.getLayoutSettings().getCurrentLayouter());
    }

    public EdgeType getEdge(d d2) {
        return this.m_mappings.getEdge(d2);
    }

    public EdgeType getEdge(Object object) {
        return this.m_mappings.getEdge(object);
    }

    public Collection<EdgeType> getEdges() {
        return this.getMappings().getEdges();
    }

    public ZyEditMode<NodeType, ?> getEditMode() {
        return this.m_editMode;
    }

    public U getGraph() {
        return this.m_graph;
    }

    public void updateGraphViews() {
        this.m_graph.updateViews();
    }

    public int getEdgeCount() {
        return this.m_graph.edgeCount();
    }

    public ZyGraphMappings<NodeType, EdgeType> getMappings() {
        return this.m_mappings;
    }

    public NodeType getNode(p p2) {
        return this.m_mappings.getNode(p2);
    }

    public NodeType getNode(Object object) {
        return this.m_mappings.getNode(object);
    }

    public Collection<NodeType> getNodes() {
        return this.getMappings().getNodes();
    }

    public ZyDefaultProximityBrowser<NodeType, EdgeType> getProximityBrowser() {
        return this.m_proximityBrowser;
    }

    public abstract Set<NodeType> getSelectedNodes();

    public AbstractZyGraphSettings getSettings() {
        return this.m_settings;
    }

    public ar getView() {
        return this.m_view;
    }

    public Cursor getViewCursor() {
        return this.m_view.getCursor();
    }

    public void removeViewFocusListener(FocusListener focusListener) {
        this.m_view.removeFocusListener(focusListener);
    }

    public void addViewFocusListener(FocusListener focusListener) {
        this.m_view.addFocusListener(focusListener);
    }

    public void setViewCursor(Cursor cursor) {
        this.m_view.setCursor(cursor);
    }

    public void addViewCanvasKeyListener(CDefaultLabelEventHandler cDefaultLabelEventHandler) {
        this.m_view.getCanvasComponent().addKeyListener(cDefaultLabelEventHandler);
    }

    public void removeViewCanvasKeyListener(CDefaultLabelEventHandler cDefaultLabelEventHandler) {
        this.m_view.getCanvasComponent().removeKeyListener(cDefaultLabelEventHandler);
    }

    public d getYEdge(Object object) {
        return this.m_mappings.getYEdge(object);
    }

    public p getYNode(Object object) {
        return this.m_mappings.getYNode(object);
    }

    @Override
    public void iterate(INodeCallback<NodeType> iNodeCallback) {
        Preconditions.checkNotNull(iNodeCallback, "Callback argument can't be null");
        for (ZyGraphNode zyGraphNode : this.m_mappings.getNodes()) {
            if (iNodeCallback.next(zyGraphNode) != IterationMode.STOP) continue;
            return;
        }
    }

    @Override
    public void iterateEdges(IEdgeCallback<EdgeType> iEdgeCallback) {
        Preconditions.checkNotNull(iEdgeCallback, "Callback argument can't be null");
        for (ZyGraphEdge zyGraphEdge : this.m_mappings.getEdges()) {
            if (iEdgeCallback.nextEdge(zyGraphEdge) != IterationMode.STOP) continue;
            return;
        }
    }

    public void removeListener(IZyGraphListener<NodeType, EdgeType> iZyGraphListener) {
        this.m_graphListeners.removeListener(iZyGraphListener);
    }

    public void removeListener(IZyGraphSelectionListener iZyGraphSelectionListener) {
        this.m_selectionObserver.removeListener(iZyGraphSelectionListener);
    }

    public void removeListener(IZyGraphVisibilityListener iZyGraphVisibilityListener) {
        this.m_visibilityListener.removeListener(iZyGraphVisibilityListener);
    }

    public void saveGraphAsGML(File file) {
        R r2 = new R(this.m_graph);
        String string = file.getPath();
        if (string.toLowerCase().endsWith(".gml")) {
            string = string + ".gml";
        }
        r2.write(string);
    }

    public void selectNode(NodeType NodeType2, boolean bl2) {
        Preconditions.checkNotNull(NodeType2, "Node argument can't be null");
        this.m_graph.av();
        ((ZyGraphNode)NodeType2).getRawNode().setSelected(bl2);
        this.m_graph.aw();
    }

    public void selectNodes(Collection<NodeType> collection, boolean bl2) {
        Preconditions.checkNotNull(collection, "Nodes argument can't be null");
        this.m_graph.av();
        for (ZyGraphNode zyGraphNode : collection) {
            Preconditions.checkNotNull(zyGraphNode, "Error: The list of nodes to select contained an invalid node.");
            zyGraphNode.getRawNode().setSelected(bl2);
        }
        this.m_graph.aw();
    }

    public void selectNodes(Collection<NodeType> collection, Collection<NodeType> collection2) {
        this.m_graph.av();
        for (ZyGraphNode zyGraphNode : collection) {
            Preconditions.checkNotNull(zyGraphNode, "Error: The list of nodes to select contained an invalid node");
            zyGraphNode.getRawNode().setSelected(true);
        }
        for (ZyGraphNode zyGraphNode : collection2) {
            Preconditions.checkNotNull(zyGraphNode, "Error: The list of nodes to unselect contained an invalid node");
            zyGraphNode.getRawNode().setSelected(false);
        }
        this.m_graph.aw();
    }

    public void setProximityBrowser(ZyDefaultProximityBrowser<NodeType, EdgeType> zyDefaultProximityBrowser) {
        if (this.m_proximityBrowser != null) {
            this.m_proximityBrowser.dispose();
        }
        this.m_proximityBrowser = zyDefaultProximityBrowser;
    }

    public void showNode(NodeType NodeType2, boolean bl2) {
        Preconditions.checkNotNull(NodeType2, "Node argument can't be null");
        ((ZyGraphNode)NodeType2).getRawNode().setVisible(bl2);
        if (bl2) {
            ArrayList<ZyGraphNode> arrayList = Lists.newArrayList(NodeType2);
            this.showNeighbors(arrayList);
        }
        this.notifyVisibilityListeners();
    }

    public void showNodes(Collection<NodeType> collection, boolean bl2) {
        for (ZyGraphNode zyGraphNode : collection) {
            Preconditions.checkNotNull(zyGraphNode, "The list of nodes to show contained an invalid node");
            zyGraphNode.getRawNode().setVisible(true);
        }
        if (bl2) {
            this.showNeighbors(collection);
        }
        this.notifyVisibilityListeners();
    }

    public void showNodes(Collection<NodeType> collection, Collection<NodeType> collection2) {
        IProximitySettings iProximitySettings = this.getSettings().getProximitySettings();
        Set<NodeType> set = ProximityRangeCalculator.getNeighbors(this, collection, iProximitySettings.getProximityBrowsingChildren(), iProximitySettings.getProximityBrowsingParents());
        collection2.removeAll(set);
        for (ZyGraphNode zyGraphNode : this.sortLayers(collection2)) {
            Preconditions.checkNotNull(zyGraphNode, "Error: The list of nodes to hide contained an invalid node");
            zyGraphNode.getRawNode().setVisible(false);
        }
        this.showNeighbors(collection);
        this.notifyVisibilityListeners();
    }

    public void showNodes(Collection<NodeType> collection, Collection<NodeType> collection2, boolean bl2) {
        if (bl2) {
            Iterator<NodeType> iterator = this.getSettings().getProximitySettings();
            Object object = ProximityRangeCalculator.getNeighbors(this, collection, iterator.getProximityBrowsingChildren(), iterator.getProximityBrowsingParents());
            collection2.removeAll((Collection<?>)object);
        }
        for (Object object : this.sortLayers(collection2)) {
            Preconditions.checkNotNull(object, "Error: The list of nodes to hide contained an invalid node");
            ((ZyGraphNode)object).getRawNode().setVisible(false);
        }
        if (bl2) {
            this.showNeighbors(collection);
        } else {
            for (Object object : collection) {
                Preconditions.checkNotNull(object, "The list of nodes to show contained an invalid node");
                ((ZyGraphNode)object).getRawNode().setVisible(true);
            }
        }
        this.notifyVisibilityListeners();
    }

    public void updateViews() {
        this.m_graph.updateViews();
    }

    public void zoom(double d2) {
        double d3 = this.m_view.getZoom() * d2;
        this.m_view.setZoom(d3);
        ZoomHelpers.keepZoomValid(this.m_view);
        this.m_graph.updateViews();
    }

    public void zoomIn() {
        this.m_view.setZoom(this.m_view.getZoom() * 1.0 / 0.8);
        ZoomHelpers.keepZoomValid(this.m_view);
        this.m_graph.updateViews();
    }

    public void zoomOut() {
        this.m_view.setZoom(this.m_view.getZoom() * 0.8);
        ZoomHelpers.keepZoomValid(this.m_view);
        this.m_graph.updateViews();
    }
}

