/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.trees;

import com.google.common.collect.Sets;
import com.google.security.zynamics.zylib.types.trees.DepthFirstIterator;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TreeAlgorithms {
    public static <ObjectType> boolean dominates(ITreeNode<ObjectType> iTreeNode, ITreeNode<ObjectType> iTreeNode2, ITreeNode<ObjectType> iTreeNode3) {
        if (iTreeNode.getObject() == iTreeNode3) {
            return false;
        }
        if (iTreeNode.getObject() == iTreeNode2) {
            return true;
        }
        for (ITreeNode<ObjectType> iTreeNode4 : iTreeNode.getChildren()) {
            if (TreeAlgorithms.dominates(iTreeNode4, iTreeNode2, iTreeNode3)) continue;
            return false;
        }
        return true;
    }

    public static <NodeType> HashMap<ITreeNode<NodeType>, Set<ITreeNode<NodeType>>> getDominateRelation(ITreeNode<NodeType> iTreeNode) {
        HashMap<ITreeNode<NodeType>, Set<ITreeNode<NodeType>>> hashMap = new HashMap<ITreeNode<NodeType>, Set<ITreeNode<NodeType>>>();
        HashSet<ITreeNode<NodeType>> hashSet = new HashSet<ITreeNode<NodeType>>();
        hashSet.add(iTreeNode);
        hashMap.put(iTreeNode, hashSet);
        DepthFirstIterator<NodeType> depthFirstIterator = new DepthFirstIterator<NodeType>(iTreeNode);
        while (depthFirstIterator.hasNext()) {
            Object object = depthFirstIterator.next();
            ITreeNode iTreeNode2 = object.getParent();
            HashSet<Object> hashSet2 = Sets.newHashSet((Iterable)hashMap.get(iTreeNode2));
            hashSet2.add(iTreeNode2);
            hashSet2.add(object);
            hashMap.put((ITreeNode<NodeType>)object, (Set<ITreeNode<NodeType>>)hashSet2);
        }
        return hashMap;
    }
}

