/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.trees;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.Iterator;
import java.util.Stack;

public class DepthFirstIterator<ObjectType>
implements Iterator<ITreeNode<ObjectType>> {
    private final Stack<ITreeNode<ObjectType>> m_path = new Stack();

    public DepthFirstIterator(ITreeNode<ObjectType> iTreeNode) {
        Preconditions.checkNotNull(iTreeNode, "Error: Root node argument can not be null");
        for (ITreeNode<ObjectType> iTreeNode2 : iTreeNode.getChildren()) {
            this.m_path.add(iTreeNode2);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.m_path.isEmpty();
    }

    @Override
    public ITreeNode<ObjectType> next() {
        ITreeNode<ObjectType> iTreeNode = this.m_path.pop();
        for (ITreeNode<ObjectType> iTreeNode2 : iTreeNode.getChildren()) {
            this.m_path.add(iTreeNode2);
        }
        return iTreeNode;
    }

    @Override
    public void remove() {
    }
}

