/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.graphs.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.types.graphs.algorithms.MalformedGraphException;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.Tree;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class LengauerTarjan {
    private static <NodeType extends IGraphNode<NodeType>> int depthFirstSearch(NodeType NodeType2, NodeType NodeType3, HashMap<NodeType, Integer> hashMap, HashMap<Integer, NodeType> hashMap2, HashMap<NodeType, NodeType> hashMap3, int n2) {
        hashMap3.put(NodeType3, NodeType2);
        hashMap2.put(n2, NodeType3);
        hashMap.put(NodeType3, n2);
        ++n2;
        Stack<Pair<IGraphNode, Object>> stack = new Stack<Pair<IGraphNode, Object>>();
        for (IGraphNode iGraphNode : Lists.reverse(NodeType3.getChildren())) {
            stack.push(new Pair<IGraphNode, NodeType>(iGraphNode, NodeType3));
        }
        while (!stack.empty()) {
            IGraphNode iGraphNode;
            Pair pair = (Pair)stack.pop();
            iGraphNode = (IGraphNode)pair.first();
            IGraphNode iGraphNode2 = (IGraphNode)pair.second();
            if (hashMap.get(iGraphNode) != -1) continue;
            hashMap.put(iGraphNode, n2);
            hashMap2.put(n2, iGraphNode);
            hashMap3.put(iGraphNode, iGraphNode2);
            ++n2;
            for (IGraphNode iGraphNode3 : Lists.reverse(iGraphNode.getChildren())) {
                stack.push(new Pair<IGraphNode, IGraphNode>(iGraphNode3, iGraphNode));
            }
        }
        return n2 - 1;
    }

    private static <NodeType extends IGraphNode<NodeType>> NodeType getAncestorWithLowestSemi(NodeType NodeType2, HashMap<NodeType, Integer> hashMap, HashMap<NodeType, NodeType> hashMap2, HashMap<NodeType, NodeType> hashMap3, HashMap<NodeType, NodeType> hashMap4) {
        IGraphNode iGraphNode = (IGraphNode)hashMap3.get(NodeType2);
        if (hashMap3.get(iGraphNode) != null) {
            IGraphNode iGraphNode2 = LengauerTarjan.getAncestorWithLowestSemi(iGraphNode, hashMap, hashMap2, hashMap3, hashMap4);
            hashMap3.put(NodeType2, (IGraphNode)hashMap3.get(iGraphNode));
            if (hashMap.get(hashMap2.get(iGraphNode2)) < hashMap.get(hashMap2.get(hashMap4.get(NodeType2)))) {
                hashMap4.put(NodeType2, iGraphNode2);
            }
        }
        return (NodeType)((IGraphNode)hashMap4.get(NodeType2));
    }

    private static <NodeType extends IGraphNode<NodeType>> void link(NodeType NodeType2, NodeType NodeType3, HashMap<NodeType, NodeType> hashMap, HashMap<NodeType, NodeType> hashMap2) {
        hashMap.put(NodeType3, NodeType2);
        hashMap2.put(NodeType3, NodeType3);
    }

    /*
     * WARNING - void declaration
     */
    public static <NodeType extends IGraphNode<NodeType>> Pair<Tree<NodeType>, HashMap<NodeType, ITreeNode<NodeType>>> calculate(Collection<NodeType> collection, NodeType NodeType2) {
        Iterator iterator;
        Object object;
        int n2;
        int n3;
        Object object222;
        Preconditions.checkNotNull(collection, "Error: Nodes argument can not be null");
        if (collection.size() == 0) {
            return new Pair<Object, Object>(null, null);
        }
        Preconditions.checkNotNull(NodeType2, "Error: Root node argument can not be null");
        Preconditions.checkArgument(collection.contains(NodeType2), "Error: Root node is not part of the graph");
        int n4 = 0;
        for (Object object222 : collection) {
            if (object222.getParents().size() != 0) continue;
            ++n4;
        }
        if (n4 > 1) {
            throw new MalformedGraphException("Error: Can not calculate dominator trees for graphs with more than one entry node");
        }
        HashMap hashMap = new HashMap();
        object222 = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap<Object, void> hashMap3 = new HashMap<Object, void>();
        HashMap<IGraphNode, Object> hashMap4 = new HashMap<IGraphNode, Object>();
        HashMap<IGraphNode, IGraphNode> hashMap5 = new HashMap<IGraphNode, IGraphNode>();
        HashMap hashMap6 = new HashMap();
        HashMap hashMap7 = new HashMap();
        HashMap<IGraphNode, Integer> hashMap8 = new HashMap<IGraphNode, Integer>();
        for (IGraphNode iGraphNode : collection) {
            hashMap.put(iGraphNode, new HashSet());
            hashMap8.put(iGraphNode, -1);
            hashMap3.put(iGraphNode, (void)null);
            hashMap4.put(iGraphNode, null);
            ((HashMap)object222).put(iGraphNode, null);
            hashMap5.put(iGraphNode, null);
        }
        for (n3 = n2 = LengauerTarjan.depthFirstSearch(null, NodeType2, hashMap8, hashMap6, hashMap7, 0); n3 >= 1; --n3) {
            void object3;
            IGraphNode iGraphNode;
            object = (IGraphNode)hashMap6.get(n3);
            Iterator iterator2 = (IGraphNode)hashMap7.get(object);
            IGraphNode iGraphNode2 = iterator2;
            for (IGraphNode iGraphNode3 : object.getParents()) {
                iGraphNode = null;
                iGraphNode = (Integer)hashMap8.get(iGraphNode3) <= (Integer)hashMap8.get(object) ? iGraphNode3 : (IGraphNode)hashMap3.get(LengauerTarjan.getAncestorWithLowestSemi(iGraphNode3, hashMap8, hashMap3, hashMap4, hashMap2));
                if ((Integer)hashMap8.get(iGraphNode) >= (Integer)hashMap8.get(object3)) continue;
                IGraphNode iGraphNode4 = iGraphNode;
            }
            hashMap3.put(object, object3);
            ((Set)hashMap.get(object3)).add(object);
            LengauerTarjan.link(iterator2, object, hashMap4, hashMap2);
            for (IGraphNode iGraphNode3 : (Set)hashMap.get(iterator2)) {
                iGraphNode = LengauerTarjan.getAncestorWithLowestSemi(iGraphNode3, hashMap8, hashMap3, hashMap4, hashMap2);
                if (hashMap3.get(iGraphNode) == hashMap3.get(iGraphNode3)) {
                    ((HashMap)object222).put(iGraphNode3, iterator2);
                    continue;
                }
                hashMap5.put(iGraphNode3, iGraphNode);
            }
            ((Set)hashMap.get(iterator2)).clear();
        }
        for (n3 = 1; n3 <= n2; ++n3) {
            object = (IGraphNode)hashMap6.get(n3);
            if (hashMap5.get(object) == null) continue;
            ((HashMap)object222).put(object, (IGraphNode)((HashMap)object222).get(hashMap5.get(object)));
        }
        Iterator iterator3 = null;
        object = new HashMap();
        for (Map.Entry entry : ((HashMap)object222).entrySet()) {
            iterator = new TreeNode<IGraphNode>((IGraphNode)entry.getKey());
            ((HashMap)object).put((IGraphNode)entry.getKey(), iterator);
            if (entry.getValue() != null) continue;
            iterator3 = iterator;
        }
        for (Map.Entry entry : ((HashMap)object222).entrySet()) {
            IGraphNode iGraphNode3;
            iterator = (IGraphNode)entry.getKey();
            iGraphNode3 = (IGraphNode)entry.getValue();
            if (iGraphNode3 == null) continue;
            ((ITreeNode)((HashMap)object).get(iGraphNode3)).addChild((ITreeNode)((HashMap)object).get(iterator));
            ((ITreeNode)((HashMap)object).get(iterator)).setParent((ITreeNode)((HashMap)object).get(iGraphNode3));
        }
        return new Pair(new Tree(iterator3), object);
    }

    public static <NodeType extends IGraphNode<NodeType>> Pair<Tree<NodeType>, HashMap<NodeType, ITreeNode<NodeType>>> calculate(IDirectedGraph<NodeType, ?> iDirectedGraph, NodeType NodeType2) {
        Preconditions.checkNotNull(iDirectedGraph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(NodeType2, "Error: Root node argument can not be null");
        if (iDirectedGraph.nodeCount() == 0) {
            return new Pair<Object, Object>(null, null);
        }
        return LengauerTarjan.calculate(iDirectedGraph.getNodes(), NodeType2);
    }
}

