/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.graphs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MutableDirectedGraph<NodeType, EdgeType extends IGraphEdge<NodeType>>
implements IDirectedGraph<NodeType, EdgeType>,
Iterable<NodeType> {
    private final List<NodeType> m_nodes;
    private final List<EdgeType> m_edges;
    private final Map<NodeType, List<EdgeType>> m_nodeToEdges = new HashMap<NodeType, List<EdgeType>>();

    public MutableDirectedGraph(List<NodeType> list, List<EdgeType> list2) {
        this.m_nodes = Preconditions.checkNotNull(list, "Nodes argument can not be null");
        this.m_edges = Preconditions.checkNotNull(list2, "Edges argument can not be null");
        for (Object object : list) {
            Preconditions.checkNotNull(object, "Node list contains null-nodes");
            this.m_nodeToEdges.put(object, new ArrayList());
        }
        for (Object object : list2) {
            this.updateNodeToEdgeMapping(object);
        }
    }

    private void updateNodeToEdgeMapping(EdgeType EdgeType2) {
        Preconditions.checkNotNull(EdgeType2, "Error: edge argument can not be null");
        if (this.m_nodeToEdges.get(EdgeType2.getSource()) == null) {
            throw new IllegalStateException("Error: The given edge has a source node which is not known to the graph.");
        }
        this.m_nodeToEdges.get(EdgeType2.getSource()).add(EdgeType2);
        if (this.m_nodeToEdges.get(EdgeType2.getTarget()) == null) {
            throw new IllegalStateException("Error: the given edge has a target node which is not known to the graph.");
        }
        this.m_nodeToEdges.get(EdgeType2.getTarget()).add(EdgeType2);
    }

    public void addEdge(EdgeType EdgeType2) {
        Preconditions.checkNotNull(EdgeType2, "Edge argument can not be null");
        this.m_edges.add(EdgeType2);
        this.updateNodeToEdgeMapping(EdgeType2);
    }

    public void addNode(NodeType NodeType2) {
        Preconditions.checkNotNull(NodeType2, "Node argument can not be null");
        this.m_nodes.add(NodeType2);
        this.m_nodeToEdges.put(NodeType2, new ArrayList());
    }

    @Override
    public int edgeCount() {
        return this.m_edges.size();
    }

    @Override
    public List<EdgeType> getEdges() {
        return Collections.unmodifiableList(this.m_edges);
    }

    @Override
    public List<NodeType> getNodes() {
        return Collections.unmodifiableList(this.m_nodes);
    }

    @Override
    public Iterator<NodeType> iterator() {
        return this.m_nodes.iterator();
    }

    @Override
    public int nodeCount() {
        return this.m_nodes.size();
    }

    public void removeEdge(EdgeType EdgeType2) {
        Preconditions.checkArgument(this.m_edges.remove(EdgeType2), "Error: Edge was not part of the graph");
        this.m_nodeToEdges.get(EdgeType2.getSource()).remove(EdgeType2);
        this.m_nodeToEdges.get(EdgeType2.getTarget()).remove(EdgeType2);
    }

    public void removeNode(NodeType NodeType2) {
        Preconditions.checkArgument(this.m_nodes.remove(NodeType2), String.format("Error: Node '%s' was not part of the graph", NodeType2));
        this.m_edges.removeAll((Collection)this.m_nodeToEdges.get(NodeType2));
        this.m_nodeToEdges.remove(NodeType2);
    }
}

