/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.graphs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeFilter;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.types.graphs.algorithms.LengauerTarjan;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.Tree;
import com.google.security.zynamics.zylib.types.trees.TreeAlgorithms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class GraphAlgorithms {
    private GraphAlgorithms() {
    }

    private static <NodeType extends IGraphNode<NodeType>> void getPredecessors(IGraphNode<NodeType> iGraphNode, Set<NodeType> set, Set<NodeType> set2) {
        for (IGraphNode iGraphNode2 : iGraphNode.getParents()) {
            if (set2.contains(iGraphNode2)) continue;
            set2.add(iGraphNode2);
            set.add(iGraphNode2);
            GraphAlgorithms.getPredecessors(iGraphNode2, set, set2);
        }
    }

    private static <NodeType extends IGraphNode<NodeType>> void getPredecessorsInternal(NodeType NodeType2, int n2, List<NodeType> list, Set<NodeType> set) {
        if (n2 <= 0) {
            return;
        }
        for (IGraphNode iGraphNode : NodeType2.getParents()) {
            if (set.contains(iGraphNode)) continue;
            set.add(iGraphNode);
            list.add(iGraphNode);
            GraphAlgorithms.getPredecessorsInternal(iGraphNode, n2 - 1, list, set);
        }
    }

    private static <NodeType extends IGraphNode<NodeType>> void getSuccessors(IGraphNode<NodeType> iGraphNode, Set<NodeType> set, Set<NodeType> set2) {
        for (IGraphNode iGraphNode2 : iGraphNode.getChildren()) {
            if (set2.contains(iGraphNode2)) continue;
            set2.add(iGraphNode2);
            set.add(iGraphNode2);
            GraphAlgorithms.getSuccessors(iGraphNode2, set, set2);
        }
    }

    private static <NodeType extends IGraphNode<NodeType>> void getSuccessorsInternal(NodeType NodeType2, int n2, List<NodeType> list, HashSet<NodeType> hashSet) {
        if (n2 <= 0) {
            return;
        }
        for (IGraphNode iGraphNode : NodeType2.getChildren()) {
            if (hashSet.contains(iGraphNode)) continue;
            hashSet.add(iGraphNode);
            list.add(iGraphNode);
            GraphAlgorithms.getSuccessorsInternal(iGraphNode, n2 - 1, list, hashSet);
        }
    }

    public static <NodeType extends IGraphNode<NodeType>> Collection<NodeType> collectChildren(NodeType NodeType2, INodeFilter<NodeType> iNodeFilter) {
        Preconditions.checkNotNull(NodeType2, "Error: Node argument can't be null");
        return GraphAlgorithms.collectNodes(NodeType2.getChildren(), iNodeFilter);
    }

    public static <NodeType> Collection<NodeType> collectNodes(Collection<? extends NodeType> collection, INodeFilter<NodeType> iNodeFilter) {
        Preconditions.checkNotNull(collection, "Error: Nodes argument can't be null");
        Preconditions.checkNotNull(iNodeFilter, "Error: Filter argument can't be null");
        ArrayList<NodeType> arrayList = new ArrayList<NodeType>();
        for (NodeType NodeType2 : collection) {
            if (!iNodeFilter.qualifies(NodeType2)) continue;
            arrayList.add(NodeType2);
        }
        return arrayList;
    }

    public static <NodeType extends IGraphNode<NodeType>> Collection<NodeType> collectParents(NodeType NodeType2, INodeFilter<NodeType> iNodeFilter) {
        Preconditions.checkNotNull(NodeType2, "Error: Node argument can't be null");
        return GraphAlgorithms.collectNodes(NodeType2.getParents(), iNodeFilter);
    }

    public static <NodeType extends IGraphNode<NodeType>> HashMap<NodeType, ArrayList<NodeType>> getBackEdges(IDirectedGraph<NodeType, ?> iDirectedGraph, NodeType NodeType2) {
        Preconditions.checkNotNull(iDirectedGraph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(NodeType2, "Error: Root Node argument can not be null");
        HashMap hashMap = new HashMap();
        Pair<Tree<NodeType>, HashMap<NodeType, ITreeNode<NodeType>>> pair = LengauerTarjan.calculate(iDirectedGraph, NodeType2);
        HashMap<NodeType, ITreeNode<NodeType>> hashMap2 = pair.second();
        HashMap<ITreeNode<NodeType>, Set<ITreeNode<NodeType>>> hashMap3 = TreeAlgorithms.getDominateRelation(pair.first().getRootNode());
        for (IGraphNode iGraphNode : iDirectedGraph.getNodes()) {
            ArrayList<IGraphNode> arrayList = new ArrayList<IGraphNode>();
            Set<ITreeNode<NodeType>> set = hashMap3.get(hashMap2.get(iGraphNode));
            if (set != null) {
                for (IGraphNode iGraphNode2 : iGraphNode.getChildren()) {
                    if (!set.contains(hashMap2.get(iGraphNode2))) continue;
                    arrayList.add(iGraphNode2);
                }
            }
            hashMap.put(iGraphNode, arrayList);
        }
        return hashMap;
    }

    public static <T extends IGraphNode<T>> ArrayList<Set<T>> getGraphLoops(IDirectedGraph<T, ?> iDirectedGraph) {
        IGraphNode iGraphNode = null;
        ArrayList<Set<T>> arrayList = new ArrayList<Set<T>>();
        for (Object object : iDirectedGraph.getNodes()) {
            if (object.getParents().size() != 0) continue;
            iGraphNode = object;
            break;
        }
        if (iGraphNode == null) {
            return null;
        }
        HashMap<Object, ArrayList<Object>> hashMap = GraphAlgorithms.getBackEdges(iDirectedGraph, iGraphNode);
        for (IGraphNode iGraphNode2 : iDirectedGraph.getNodes()) {
            ArrayList arrayList2 = (ArrayList)hashMap.get(iGraphNode2);
            for (IGraphNode iGraphNode3 : arrayList2) {
                arrayList.add(GraphAlgorithms.getLoopNodes(iGraphNode2, iGraphNode3));
            }
        }
        return arrayList;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getLoopNodes(NodeType NodeType2, NodeType NodeType3) {
        Object object3;
        Object object2;
        if (NodeType2 == NodeType3) {
            ArrayList<NodeType> arrayList = new ArrayList<NodeType>();
            arrayList.add(NodeType2);
            return new HashSet(arrayList);
        }
        ArrayList<NodeType> arrayList = new ArrayList<NodeType>();
        arrayList.add(NodeType3);
        HashSet<Object> hashSet = new HashSet<Object>(arrayList);
        Stack<Object> stack = new Stack<Object>();
        stack.push(NodeType2);
        while (!stack.empty()) {
            object2 = (IGraphNode)stack.pop();
            hashSet.add(object2);
            for (Object object3 : object2.getParents()) {
                if (hashSet.contains(object3)) continue;
                hashSet.add(object3);
                stack.push(object3);
            }
        }
        object2 = new ArrayList();
        HashSet hashSet2 = new HashSet(object2);
        object3 = new Stack<NodeType>();
        ((Stack)object3).push(NodeType3);
        while (!((Stack)object3).empty()) {
            IGraphNode iGraphNode = (IGraphNode)((Stack)object3).pop();
            hashSet2.add(iGraphNode);
            for (IGraphNode iGraphNode2 : iGraphNode.getChildren()) {
                if (hashSet2.contains(iGraphNode2)) continue;
                hashSet2.add(iGraphNode2);
                ((Stack)object3).push(iGraphNode2);
            }
        }
        hashSet.retainAll(hashSet2);
        return hashSet;
    }

    public static <NodeType extends IGraphNode<NodeType>> Collection<NodeType> getPredecessors(Collection<NodeType> collection) {
        Preconditions.checkNotNull(collection, "Error: Nodes argument can't be null");
        HashSet<NodeType> hashSet = new HashSet<NodeType>();
        for (IGraphNode iGraphNode : collection) {
            hashSet.addAll(GraphAlgorithms.getPredecessors(iGraphNode));
        }
        return hashSet;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getPredecessors(IGraphNode<NodeType> iGraphNode) {
        Preconditions.checkNotNull(iGraphNode, "Error: Start node can't be null");
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        GraphAlgorithms.getPredecessors(iGraphNode, hashSet, hashSet2);
        return hashSet;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getPredecessorsUpToNode(IGraphNode<NodeType> iGraphNode, IGraphNode<NodeType> iGraphNode2) {
        Preconditions.checkNotNull(iGraphNode, "Error: endNode argument can not be null");
        Preconditions.checkNotNull(iGraphNode2, "Error: startNode argument can not be null");
        HashSet hashSet = Sets.newHashSet();
        HashSet<IGraphNode<NodeType>> hashSet2 = Sets.newHashSet();
        hashSet2.add(iGraphNode2);
        GraphAlgorithms.getPredecessors(iGraphNode, hashSet, hashSet2);
        return hashSet;
    }

    public static <NodeType extends IGraphNode<NodeType>> List<NodeType> getPredecessors(Iterable<NodeType> iterable, int n2) {
        ArrayList<IGraphNode> arrayList = new ArrayList<IGraphNode>();
        for (IGraphNode iGraphNode : iterable) {
            arrayList.addAll(GraphAlgorithms.getPredecessors(iGraphNode, n2));
        }
        return arrayList;
    }

    public static <NodeType extends IGraphNode<NodeType>> List<NodeType> getPredecessors(NodeType NodeType2, int n2) {
        ArrayList arrayList = new ArrayList();
        GraphAlgorithms.getPredecessorsInternal(NodeType2, n2, arrayList, new HashSet());
        return arrayList;
    }

    public static <NodeType extends IGraphNode<NodeType>> Collection<NodeType> getSuccessors(Collection<NodeType> collection) {
        Preconditions.checkNotNull(collection, "Error: Nodes argument can't be null");
        HashSet<NodeType> hashSet = new HashSet<NodeType>();
        for (IGraphNode iGraphNode : collection) {
            hashSet.addAll(GraphAlgorithms.getSuccessors(iGraphNode));
        }
        return hashSet;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getSuccessors(IGraphNode<NodeType> iGraphNode) {
        Preconditions.checkNotNull(iGraphNode, "Error: Start node can't be null");
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        GraphAlgorithms.getSuccessors(iGraphNode, hashSet, hashSet2);
        return hashSet;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getSuccessorsDownToNode(IGraphNode<NodeType> iGraphNode, IGraphNode<NodeType> iGraphNode2) {
        Preconditions.checkNotNull(iGraphNode, "Error: parent node can't be null");
        Preconditions.checkNotNull(iGraphNode2, "Error: maximumChildNode argument can not be null");
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        GraphAlgorithms.getSuccessors(iGraphNode, hashSet, hashSet2);
        return hashSet;
    }

    public static <NodeType extends IGraphNode<NodeType>> List<NodeType> getSuccessors(Iterable<NodeType> iterable, int n2) {
        ArrayList<IGraphNode> arrayList = new ArrayList<IGraphNode>();
        for (IGraphNode iGraphNode : iterable) {
            arrayList.addAll(GraphAlgorithms.getSuccessors(iGraphNode, n2));
        }
        return arrayList;
    }

    public static <NodeType extends IGraphNode<NodeType>> List<NodeType> getSuccessors(NodeType NodeType2, int n2) {
        ArrayList arrayList = new ArrayList();
        GraphAlgorithms.getSuccessorsInternal(NodeType2, n2, arrayList, new HashSet());
        return arrayList;
    }

    public static <NodeType extends IGraphNode<NodeType>> boolean isRootNode(NodeType NodeType2) {
        return NodeType2.getParents().size() == 0;
    }
}

