/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.graphs;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphEdge;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DirectedGraph<NodeType extends IGraphNode<NodeType>, EdgeType extends IGraphEdge<NodeType>>
implements IDirectedGraph<NodeType, EdgeType>,
Iterable<NodeType> {
    private final List<NodeType> m_nodes;
    private final List<EdgeType> m_edges;
    private final SetMultimap<NodeType, EdgeType> m_incomingEdges = HashMultimap.create();
    private final SetMultimap<NodeType, EdgeType> m_outgoingEdges = HashMultimap.create();

    public DirectedGraph(List<NodeType> list, List<EdgeType> list2) {
        Preconditions.checkNotNull(list, "Error: Nodes argument can not be null");
        Preconditions.checkNotNull(list2, "Error: Edges argument can not be null");
        for (Object object : list) {
            Preconditions.checkNotNull(object, "Error: Node list contains null-nodes");
        }
        for (Object object : list2) {
            this.m_outgoingEdges.put((IGraphNode)object.getSource(), object);
            this.m_incomingEdges.put((IGraphNode)object.getTarget(), object);
        }
        this.m_nodes = list;
        this.m_edges = list2;
    }

    @Override
    public int edgeCount() {
        return this.m_edges.size();
    }

    @Override
    public List<EdgeType> getEdges() {
        return Collections.unmodifiableList(this.m_edges);
    }

    public Set<EdgeType> getIncomingEdges(NodeType NodeType2) {
        return this.m_incomingEdges.get((Object)NodeType2);
    }

    @Override
    public List<NodeType> getNodes() {
        return Collections.unmodifiableList(this.m_nodes);
    }

    public Set<EdgeType> getOutgoingEdges(NodeType NodeType2) {
        return this.m_outgoingEdges.get((Object)NodeType2);
    }

    @Override
    public Iterator<NodeType> iterator() {
        return this.m_nodes.iterator();
    }

    @Override
    public int nodeCount() {
        return this.m_nodes.size();
    }
}

