/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.common;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.common.ICollectionMapper;
import com.google.security.zynamics.zylib.types.common.IFilteredItemCallback;
import com.google.security.zynamics.zylib.types.common.IItemCallback;
import com.google.security.zynamics.zylib.types.common.IIterableCollection;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionHelpers {
    public static <ItemType> boolean all(Collection<ItemType> collection, ICollectionFilter<ItemType> iCollectionFilter) {
        for (ItemType ItemType : collection) {
            if (iCollectionFilter.qualifies(ItemType)) continue;
            return false;
        }
        return true;
    }

    public static <ItemType> boolean any(Collection<ItemType> collection, ICollectionFilter<ItemType> iCollectionFilter) {
        for (ItemType ItemType : collection) {
            if (!iCollectionFilter.qualifies(ItemType)) continue;
            return true;
        }
        return false;
    }

    public static <ItemType> int count(Collection<? extends ItemType> collection, ItemType ItemType) {
        int n2 = 0;
        for (ItemType ItemType2 : collection) {
            if (ItemType2 != ItemType) continue;
            ++n2;
        }
        return n2;
    }

    public static <ItemType> int countIf(Collection<? extends ItemType> collection, ICollectionFilter<ItemType> iCollectionFilter) {
        int n2 = 0;
        for (ItemType ItemType : collection) {
            if (!iCollectionFilter.qualifies(ItemType)) continue;
            ++n2;
        }
        return n2;
    }

    public static <ItemType> List<ItemType> filter(Collection<? extends ItemType> collection, ICollectionFilter<ItemType> iCollectionFilter) {
        ArrayList<ItemType> arrayList = new ArrayList<ItemType>();
        for (ItemType ItemType : collection) {
            if (!iCollectionFilter.qualifies(ItemType)) continue;
            arrayList.add(ItemType);
        }
        return arrayList;
    }

    public static <T> Collection<T> flatten(Collection<? extends Collection<T>> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Collection<T> collection2 : collection) {
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    public static <ItemType, CollectionType extends IIterableCollection<IItemCallback<ItemType>>> void iterate(CollectionType CollectionType, final ICollectionFilter<ItemType> iCollectionFilter, final IItemCallback<ItemType> iItemCallback) {
        Preconditions.checkNotNull(CollectionType, "Error: Graph argument can't be null");
        Preconditions.checkNotNull(iItemCallback, "Error: Callback argument can't be null");
        Preconditions.checkNotNull(iCollectionFilter, "Error: Filter argument can't be null");
        CollectionType.iterate(new IItemCallback<ItemType>(){

            @Override
            public IterationMode next(ItemType ItemType) {
                if (iCollectionFilter.qualifies(ItemType)) {
                    return iItemCallback.next(ItemType);
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public static <ItemType, CollectionType extends IIterableCollection<IItemCallback<ItemType>>> void iterate(CollectionType CollectionType, final IFilteredItemCallback<ItemType> iFilteredItemCallback) {
        CollectionType.iterate(new IItemCallback<ItemType>(){

            @Override
            public IterationMode next(ItemType ItemType) {
                if (iFilteredItemCallback.qualifies(ItemType)) {
                    return iFilteredItemCallback.next(ItemType);
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public static <InputType, OutputType> List<OutputType> map(Collection<? extends InputType> collection, ICollectionMapper<InputType, OutputType> iCollectionMapper) {
        ArrayList<OutputType> arrayList = new ArrayList<OutputType>();
        for (InputType InputType : collection) {
            arrayList.add(iCollectionMapper.map(InputType));
        }
        return arrayList;
    }

    public static <ItemType> ItemType nth(Collection<? extends ItemType> collection, ICollectionFilter<ItemType> iCollectionFilter, int n2) {
        int n3 = 0;
        for (ItemType ItemType : collection) {
            if (!iCollectionFilter.qualifies(ItemType)) continue;
            if (n3 == n2) {
                return ItemType;
            }
            ++n3;
        }
        throw new IllegalStateException("Error: nth element does not exist");
    }

    public static <S, T> Pair<Collection<S>, Collection<T>> unzip(Collection<Pair<S, T>> collection) {
        ArrayList<S> arrayList = new ArrayList<S>(collection.size());
        ArrayList<T> arrayList2 = new ArrayList<T>(collection.size());
        for (Pair<S, T> pair : collection) {
            arrayList.add(pair.first());
            arrayList2.add(pair.second());
        }
        return new Pair<Collection<S>, Collection<T>>(arrayList, arrayList2);
    }
}

