/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.system;

import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;

public final class SystemHelpers {
    public static String getAllUsersApplicationDataDirectory() {
        String string = SystemHelpers.isRunningWindows() ? System.getenv("ProgramData") : (SystemHelpers.isRunningLinux() ? "/etc/opt" : (SystemHelpers.isRunningMacOSX() ? "/Library/Application Support" : System.getProperty("user.home")));
        return FileUtils.ensureTrailingSlash(string);
    }

    public static String getAllUsersApplicationDataDirectory(String string) {
        return SystemHelpers.getAllUsersApplicationDataDirectory() + (SystemHelpers.isRunningWindows() ? string : "." + string.toLowerCase()) + File.separator;
    }

    public static String getApplicationDataDirectory() {
        String string;
        if (SystemHelpers.isRunningWindows()) {
            string = System.getenv("APPDATA");
        } else {
            string = System.getProperty("user.home");
            if (SystemHelpers.isRunningMacOSX()) {
                string = string + "/Library/Application Support";
            }
        }
        return FileUtils.ensureTrailingSlash(string);
    }

    public static String getApplicationDataDirectory(String string) {
        return SystemHelpers.getApplicationDataDirectory() + (SystemHelpers.isRunningLinux() ? "." + string.toLowerCase() : string) + File.separator;
    }

    public static String getTempDirectory() {
        return FileUtils.ensureTrailingSlash(System.getProperty("java.io.tmpdir"));
    }

    public static String getTempDirectory(String string) {
        return SystemHelpers.getTempDirectory() + (SystemHelpers.isRunningWindows() ? string : string.toLowerCase()) + File.separator;
    }

    public static String getUserDirectory() {
        return FileUtils.ensureTrailingSlash(System.getProperty("user.home"));
    }

    public static boolean isRunningLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isRunningMacOSX() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean isRunningWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean is64BitArchitecture() {
        if (SystemHelpers.isRunningWindows()) {
            return "AMD64".equals(System.getenv("PROCESSOR_ARCHITECTURE")) || "AMD64".equals(System.getenv("PROCESSOR_ARCHITEW6432"));
        }
        throw new RuntimeException("Not implemented");
    }
}

