/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.system;

import com.google.security.zynamics.zylib.system.IdaException;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public final class IdaHelpers {
    public static final String IDA32_EXECUTABLE;
    public static final String IDA64_EXECUTABLE;

    public static Process createIdaProcess(String string, String string2, String string3) {
        ProcessBuilder processBuilder = new ProcessBuilder(string, "-A", "-OBinExportModule:" + string3, "-OBinExportAutoAction:BinExportBinary", string2);
        processBuilder.environment().put("TVHEADLESS", "1");
        try {
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String string4;
                while ((string4 = bufferedReader.readLine()) != null) {
                    System.out.println(string4);
                }
            }
            return process;
        }
        catch (IOException iOException) {
            throw new IdaException("Failed attempting to launch the importer with IDA: " + iOException.getMessage(), iOException);
        }
    }

    static {
        if (SystemHelpers.isRunningWindows()) {
            IDA32_EXECUTABLE = "ida.exe";
            IDA64_EXECUTABLE = "ida64.exe";
        } else {
            IDA32_EXECUTABLE = "ida";
            IDA64_EXECUTABLE = "ida64";
        }
    }
}

