/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.plugins;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarResources {
    private final Hashtable<String, Integer> htSizes = new Hashtable();
    private final Hashtable<String, byte[]> htJarContents = new Hashtable();
    private final String jarFileName;
    public boolean debugOn = false;

    public JarResources(String string) {
        this.jarFileName = string;
        this.init();
    }

    private String dumpZipEntry(ZipEntry zipEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        if (zipEntry.isDirectory()) {
            stringBuffer.append("d ");
        } else {
            stringBuffer.append("f ");
        }
        if (zipEntry.getMethod() == 0) {
            stringBuffer.append("stored   ");
        } else {
            stringBuffer.append("defalted ");
        }
        stringBuffer.append(zipEntry.getName());
        stringBuffer.append("\t");
        stringBuffer.append("" + zipEntry.getSize());
        if (zipEntry.getMethod() == 8) {
            stringBuffer.append("/" + zipEntry.getCompressedSize());
        }
        return stringBuffer.toString();
    }

    private void init() {
        try {
            Object object;
            ZipFile zipFile = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (this.debugOn) {
                    System.out.println(this.dumpZipEntry((ZipEntry)object));
                }
                this.htSizes.put(((ZipEntry)object).getName(), (int)((ZipEntry)object).getSize());
            }
            zipFile.close();
            object = new FileInputStream(this.jarFileName);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n2;
                if (zipEntry.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + zipEntry.getName() + ",getSize()=" + zipEntry.getSize());
                }
                if ((n2 = (int)zipEntry.getSize()) == -1) {
                    n2 = this.htSizes.get(zipEntry.getName());
                }
                byte[] byArray = new byte[n2];
                int n3 = 0;
                int n4 = 0;
                while (n2 - n3 > 0 && (n4 = zipInputStream.read(byArray, n3, n2 - n3)) != -1) {
                    n3 += n4;
                }
                this.htJarContents.put(zipEntry.getName(), byArray);
                if (!this.debugOn) continue;
                System.out.println(zipEntry.getName() + "  rb=" + n3 + ",size=" + n2 + ",csize=" + zipEntry.getCompressedSize());
            }
            zipInputStream.close();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("done.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] getResource(String string) {
        return this.htJarContents.get(string);
    }
}

