/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.io;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.io.StreamUtils;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class FileUtils {
    public static String calcMD5(File file) {
        MessageDigest messageDigest;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            assert (false) : "MD5 not in list of algorithms";
            throw new RuntimeException(noSuchAlgorithmException);
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by2 : byArray2) {
            stringBuilder.append(String.format("%02X", by2));
        }
        return stringBuilder.toString();
    }

    public static boolean containsDirectory(File file, String string) {
        if (file == null || !file.isDirectory()) {
            return false;
        }
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory() || !file2.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFile(File file, String string) {
        if (file == null || !file.isDirectory()) {
            return false;
        }
        for (File file2 : file.listFiles()) {
            if (!file2.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean createDirectory(String string) {
        return new File(string).mkdirs();
    }

    public static String ensureTrailingSlash(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.charAt(stringBuilder.length() - 1) == File.separatorChar) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.append(File.separatorChar).toString();
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static String extractNameFromPath(String string) {
        return new File(string).getName();
    }

    public static String findLocalRootPath(Class<?> clazz) {
        String string;
        Object object;
        int n2;
        String string2 = clazz.getSimpleName() + ".class";
        URL uRL = clazz.getResource(string2);
        Preconditions.checkNotNull(uRL, "Cannot find resource for class " + clazz.getCanonicalName());
        String string3 = uRL.getProtocol();
        String string4 = uRL.getPath();
        int n3 = n2 = SystemHelpers.isRunningWindows() ? 1 : 0;
        if (string3.equals("file")) {
            object = clazz.getPackage();
            if (object != null) {
                String string5 = object != null ? ((Package)object).getName().replace('.', '/') : "";
                string = string4.substring(n2, string4.lastIndexOf(string5));
            } else {
                string = string4.substring(n2, string4.lastIndexOf(47));
            }
        } else {
            if (!string3.equals("jar")) {
                throw new RuntimeException("Cannot find root path for remote classes");
            }
            if (!string4.startsWith("file:")) {
                throw new IllegalArgumentException("Cannot find root path for class " + clazz.getCanonicalName());
            }
            object = string4.substring(5, string4.lastIndexOf(33));
            string = ((String)object).substring(n2, ((String)object).lastIndexOf(47));
        }
        try {
            return URLDecoder.decode(string.replace('/', File.separatorChar), System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false) : "Platform default URL encoding should always be available";
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String getFileBasename(File file) {
        String string = file.getName();
        int n2 = string.lastIndexOf(".");
        return n2 == -1 ? string : string.substring(0, n2);
    }

    public static String getFileExtension(File file) {
        String string = file.getAbsolutePath();
        int n2 = string.lastIndexOf(".");
        if (n2 < 1 || n2 == string.length() - 1) {
            return "";
        }
        return string.substring(n2 + 1);
    }

    public static String getPathEllipsis(String string, int n2) {
        return FileUtils.getPathEllipsis(string, n2, "...");
    }

    public static String getPathEllipsis(String string, int n2, String string2) {
        int n3 = string.length();
        int n4 = string2.length();
        Preconditions.checkArgument(n2 >= 4 * n4, "Maximum length too short");
        if (n3 <= n2) {
            return string;
        }
        char c2 = File.separatorChar;
        boolean bl2 = false;
        for (int i2 = 0; !bl2 && i2 < n3; ++i2) {
            c2 = string.charAt(i2);
            bl2 = c2 == '/' || c2 == '\\';
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl2) {
            stringBuilder.append(string.substring(0, n2 - n4));
            stringBuilder.append(string2);
        } else {
            int n5 = string.lastIndexOf(c2);
            int n6 = n2 - (n3 - n5);
            int n7 = n6 / 2 - n4 / 2;
            if (n7 > 0) {
                stringBuilder.append(string.substring(0, n7 - n4 % 2 + n6 % 2));
                stringBuilder.append(string2);
                stringBuilder.append(string.substring(n5 - n7 + n4 % 2));
            } else {
                stringBuilder.append(string.substring(0, 3));
                stringBuilder.append(string2);
                stringBuilder.append(string.substring(n5, n5 + n2 - 3 - 2 * n4));
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextfile(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static String readTextfile(String string) {
        return FileUtils.readTextfile(new File(string));
    }

    public static List<String> readTextfileLines(File file) {
        return StreamUtils.readLinesFromReader(new FileReader(file));
    }

    public static void writeBinaryFile(File file, byte[] byArray) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(byArray);
        }
    }

    public static void writeTextFile(File file, String string) {
        Preconditions.checkNotNull(file, "Error: file argument can not be null");
        Preconditions.checkNotNull(string, "Error: text argument can not be null");
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            bufferedWriter.write(string);
        }
    }
}

