/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.io;

import com.google.security.zynamics.zylib.io.IDirectoryTraversalCallback;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class DirUtils {
    public static void traverse(File file, IDirectoryTraversalCallback iDirectoryTraversalCallback) {
        DirUtils.traverse(file, iDirectoryTraversalCallback, true);
    }

    public static void traverse(File file, IDirectoryTraversalCallback iDirectoryTraversalCallback, boolean bl2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        iDirectoryTraversalCallback.entering(file);
        for (File file2 : fileArray) {
            if (file2.isDirectory()) continue;
            iDirectoryTraversalCallback.nextFile(file2);
        }
        if (bl2) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                DirUtils.traverse(file2, iDirectoryTraversalCallback);
            }
        }
        iDirectoryTraversalCallback.leaving(file);
    }

    public static void traverse(File file, IDirectoryTraversalCallback iDirectoryTraversalCallback, Comparator<File> comparator) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        Arrays.sort(fileArray, comparator);
        iDirectoryTraversalCallback.entering(file);
        for (File file2 : fileArray) {
            if (file2.isDirectory()) continue;
            iDirectoryTraversalCallback.nextFile(file2);
        }
        for (File file2 : fileArray) {
            if (!file2.isDirectory()) continue;
            DirUtils.traverse(file2, iDirectoryTraversalCallback);
        }
        iDirectoryTraversalCallback.leaving(file);
    }
}

