/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.wrappers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ViewNodeAdapter
implements IGraphNode<ViewNodeAdapter> {
    private final IViewNode<?> m_viewNode;

    public ViewNodeAdapter(IViewNode<?> iViewNode) {
        Preconditions.checkNotNull(iViewNode, "Error: View node argument can not be null");
        this.m_viewNode = iViewNode;
    }

    private static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> Collection<NodeType> convert(AbstractZyGraph<NodeType, ?> abstractZyGraph, Collection<? extends IViewNode<?>> collection) {
        ArrayList<NodeType> arrayList = new ArrayList<NodeType>();
        for (IViewNode<?> iViewNode : collection) {
            arrayList.add(abstractZyGraph.getNode(iViewNode));
        }
        return arrayList;
    }

    public static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> Collection<NodeType> unwrap(AbstractZyGraph<NodeType, ?> abstractZyGraph, Collection<ViewNodeAdapter> collection) {
        FilledList filledList = new FilledList();
        for (ViewNodeAdapter viewNodeAdapter : collection) {
            filledList.add(viewNodeAdapter.getNode());
        }
        return ViewNodeAdapter.convert(abstractZyGraph, filledList);
    }

    public static List<ViewNodeAdapter> wrap(List<? extends IViewNode<?>> list) {
        ArrayList<ViewNodeAdapter> arrayList = new ArrayList<ViewNodeAdapter>();
        for (IViewNode<?> iViewNode : list) {
            arrayList.add(new ViewNodeAdapter(iViewNode));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        return object instanceof ViewNodeAdapter && ((ViewNodeAdapter)object).getNode() == this.getNode();
    }

    @Override
    public List<ViewNodeAdapter> getChildren() {
        List<?> list = this.m_viewNode.getOutgoingEdges();
        ArrayList<IViewNode> arrayList = new ArrayList<IViewNode>();
        for (IViewEdge iViewEdge : list) {
            arrayList.add((IViewNode)iViewEdge.getTarget());
        }
        return ViewNodeAdapter.wrap(arrayList);
    }

    public IViewNode<?> getNode() {
        return this.m_viewNode;
    }

    @Override
    public List<ViewNodeAdapter> getParents() {
        List<?> list = this.m_viewNode.getIncomingEdges();
        ArrayList<IViewNode> arrayList = new ArrayList<IViewNode>();
        for (IViewEdge iViewEdge : list) {
            arrayList.add((IViewNode)iViewEdge.getSource());
        }
        return ViewNodeAdapter.wrap(arrayList);
    }

    public int hashCode() {
        return this.m_viewNode.hashCode();
    }
}

